/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vls5
 */

// forked from siouxcitizen's Away3D Gold Practice06 Cube 5つ表示
// forked from siouxcitizen's Away3D Gold Practice05 光のあて方よくわからない。。。
// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//Away3D 4.0 Gold で複数Cylinderを表示してみました
//
//以下サイトを参考にしました
//
//CylinderGeometry
//http://away3d.com/livedocs/away3d/4.0/away3d/primitives/CylinderGeometry.html
//
//WireframeCube
//http://away3d.com/livedocs/away3d/4.0/away3d/primitives/WireframeCube.html
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.ColorMaterial;
    import away3d.primitives.CylinderGeometry;
    import away3d.primitives.WireframeCylinder;
    import away3d.primitives.PrimitiveBase;
    import away3d.lights.DirectionalLight;
    import away3d.materials.lightpickers.StaticLightPicker;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class CylinderSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _cylinderGeo : PrimitiveBase;
        private var _cylinderMat : ColorMaterial;
        private var _cylinder01 : Mesh;
        private var _cylinder02 : Mesh;
        private var _cylinder03 : Mesh;
        private var _cylinder04 : Mesh;
        private var _cylinder05 : Mesh;
        private var _wfrmCylin01 : WireframeCylinder;
        private var _wfrmCylin02 : WireframeCylinder;
        private var _wfrmCylin03 : WireframeCylinder;
        private var _wfrmCylin04 : WireframeCylinder;
        private var _direcLight : DirectionalLight;

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function CylinderSample() {

            // wonderfl capture
            Wonderfl.disable_capture();
            //addChild(new Bitmap(_capture)) ;

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x999999;

            _direcLight = new DirectionalLight();
            _direcLight.direction = new Vector3D(1, -1, 1);
            _direcLight.specular = 0.1;
            _direcLight.diffuse = 0.9;
            _direcLight.ambient = 0.1;
            _scene.addChild(_direcLight);

            var lightPicker:StaticLightPicker = new StaticLightPicker([_direcLight]);

            _cylinderMat =  new ColorMaterial(0xff0000, 1);
            _cylinderGeo = new CylinderGeometry(1, 50, 200, 16, 1);
            _cylinderMat.lightPicker = lightPicker;
            _cylinder01 = new Mesh(_cylinderGeo, _cylinderMat);
            _cylinder01.y += 250;
            _scene.addChild(_cylinder01);

            _cylinderMat =  new ColorMaterial(0x00ff00, 1);
            _cylinderGeo = new CylinderGeometry(1, 50, 200, 16, 1);
            _cylinderMat.lightPicker = lightPicker;
            _cylinder02 = new Mesh(_cylinderGeo, _cylinderMat);
            _cylinder02.x = -250;
            _scene.addChild(_cylinder02);

            _cylinderMat =  new ColorMaterial(0x0000ff, 1);
            _cylinderGeo = new CylinderGeometry(1, 50, 200, 16, 1);
            _cylinderMat.lightPicker = lightPicker;
            _cylinder03 = new Mesh(_cylinderGeo, _cylinderMat);
            _cylinder03.x = 250;
            _scene.addChild(_cylinder03);

            _cylinderMat =  new ColorMaterial(0xffff00, 1);
            _cylinderGeo = new CylinderGeometry(1, 50, 200, 16, 1);
            _cylinderMat.lightPicker = lightPicker;
            _cylinder04 = new Mesh(_cylinderGeo, _cylinderMat);
            _cylinder04.y = -250;
            _scene.addChild(_cylinder04);

            _cylinderMat =  new ColorMaterial(0xff00ff, 1);
            _cylinderGeo = new CylinderGeometry(50, 50, 200, 16, 1);
            _cylinderMat.lightPicker = lightPicker;
            _cylinder05 = new Mesh(_cylinderGeo, _cylinderMat);
            _cylinder05.x = 0;
            _cylinder05.y = 0;
            _scene.addChild(_cylinder05);

           _wfrmCylin01 = new WireframeCylinder(1, 50, 100, 16, 1);
           _wfrmCylin01.x = -250;
           _wfrmCylin01.y = 250;
           _scene.addChild(_wfrmCylin01);

           _wfrmCylin02 = new WireframeCylinder(50, 1, 100, 16, 1);
           _wfrmCylin02.x = 250;
           _wfrmCylin02.y = 250;
           _scene.addChild(_wfrmCylin02);

           _wfrmCylin03 = new WireframeCylinder(50, 35, 100, 16, 1);
           _wfrmCylin03.x = -250;
           _wfrmCylin03.y = -250;
           _scene.addChild(_wfrmCylin03);

           _wfrmCylin04 = new WireframeCylinder(35, 50, 100, 16, 1);
           _wfrmCylin04.x = 250;
           _wfrmCylin04.y = -250;
           _scene.addChild(_wfrmCylin04);

            _camera.y = 0;
            _camera.z = -700;

            addEventListener(Event.ENTER_FRAME, update);
                   
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _cylinder01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cylinder01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _cylinder02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cylinder02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _cylinder03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cylinder03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _cylinder04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cylinder04.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _cylinder05.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _cylinder05.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wfrmCylin01.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wfrmCylin01.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wfrmCylin02.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wfrmCylin02.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wfrmCylin03.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wfrmCylin03.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wfrmCylin04.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wfrmCylin04.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}