/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vlOo
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author ypc
     */
    [SWF(width = "465", height = "465", backgroundColor = "#000000")]
    public class Main extends Sprite 
    {
        
        public var backBitmapData:BitmapData;
        public var backBitmap:Bitmap;
        
        public var segment:Array;
        public var H:Number = 0.9;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            backBitmapData = new BitmapData(465, 465, false, 0x0);
            backBitmap = new Bitmap(backBitmapData);
            addChild(backBitmap);
            
            stage.addEventListener(MouseEvent.CLICK, onGenerate);
            
            onGenerate();
            
            
            
            
        }
        
        private function onGenerate(e:MouseEvent = null):void
        {
            
            backBitmapData.fillRect(backBitmapData.rect, 0x0);
            
            
            var nowRange:Number = 1;
            var index:int = 0;
            var n:int;
            var len:int;
            var temp:Number;
            
            H = Math.random() * 0.3 + 0.8;
            segment = [0, 1];
            while (index < 8)
            {
                len = Math.pow(2, index);
                for (n = 1; n <= len; n += 1)
                {
                    segment.splice(2 * n - 1, 0, Math.random() * nowRange * 2 - nowRange); //index : 1; 1,3; 1,3,5,7; ...
                    segment[2 * n - 1] += (segment[2 * n - 2] + segment[2 * n]) / 2;
                    //trace(temp);
                }
                
                nowRange *= Math.pow(2, -H);
                //trace(nowRange);
                index += 1;
                //trace(segment);
            }
            
            var height:Number = 465 / 2;
            var height2:Number = 465 / 4;
            var line:Shape = new Shape();
            line.graphics.clear();
            line.graphics.lineStyle(0, 0x0);
            line.graphics.beginFill(0x0);
            line.graphics.moveTo(0, height);
            
            len = segment.length;
            
            for (n = 1; n < len; n += 1)
            {
                line.graphics.lineTo(n / len * 465, segment[n] * height2 + height);
            }
            n = len - 1;
            //trace(segment[n] * height2 + height);
            line.graphics.lineTo(465, segment[n] * height2 + height);
            line.graphics.lineTo(465, 465);
            line.graphics.lineTo(0, 465);
            line.graphics.lineTo(0, height);
            line.graphics.endFill();
            //line.graphics.lineTo(465, height);
            
            
            
            var stepNum:int = Math.random() * 10 + 25; //add Sky
            var oneStep:int = 465 / stepNum;
            var nowStep:int;
            var nowStepY:int = 0;
            
            for (n = 0; n < stepNum; n += 1)
            {
                nowStep = oneStep * (Math.random() * 0.8 + 0.6);
                backBitmapData.fillRect(new Rectangle(0, nowStepY, 465, nowStep), (n / stepNum * 255) << 16 | ((n / stepNum * 127) + 0x80) << 8 | (n / stepNum * 127) + 0x80);
                nowStepY += nowStep;
            }
            
            
            //add Some Cute Stars
            var starNum:int = Math.random() * 10 + 20;
            var size:int;
            for (n = 0; n < starNum; n += 1)
            {
                size = Math.random() * 3 + 2;
                backBitmapData.fillRect(new Rectangle(Math.random() * 465, Math.random() * 465, size, size), 0xcccccc);
            }
            
            
            backBitmapData.draw(line); //add Mountain
            
            
            
            
        }
        
    }
    
}