/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vkak
 */

/**
 El Arbol. VLD - Vladimir Israel Rámírez Díaz
 */

// 
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.getTimer;
    
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.Font3D;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;

    [SWF(width=465, height=465, frameRate=60)]
    public class Arbol extends BasicView {
        private var level:int = 0;
        private var rot:Number = 0;
        private var ArbolPixels:Pixels;
        private var canvas:BitmapData;
        private var mtx:Matrix;
        
        public static const COLOR1:uint = 0xFFCC9900;
        public static const COLOR2:uint = 0xFF330066;
        public static const COLOR3:uint   = 0xFFCC0099;
        public static const COLOR4:uint  = 0xFF0098FF;
        public static const COLOR5:uint = 0xFF60066;
        public static const COLORES:Array = [COLOR1, COLOR2, COLOR3, COLOR4, COLOR5];
        
        private var material:Letter3DMaterial;
        private var font3D:Font3D;
        private var texto3D:Text3D;
        private var easeOut:Number = 0.6;
        private var reachX:Number = 0.5;
        private var reachY:Number = 0.5;
        private var reachZ:Number = 0.5;
        /**
        *
        */ 
        public function Arbol() {
            stage.quality = StageQuality.MEDIUM;
            opaqueBackground = 0;
            
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight);
            bfx.addEffect(new BitmapColorEffect(4, 1, 1, 0.75));
            viewport.containerSprite.addLayer(bfx);

            ArbolPixels = new Pixels(bfx);
            scene.addChild(ArbolPixels);

            // Arbol
            DibujaArbol(0, -1000, 0, 500, 90, COLOR3);

            
            // Estrellas
            for(var i:int=0; i< 300; i++){
                var pix:Pixel3D = new Pixel3D(0xFF99CCFF,
                    10000 * (Math.random() - 0.5),
                    10000 * (Math.random() - 0.5),
                    10000 * (Math.random() - 0.5));
                ArbolPixels.addPixel3D(pix);
            }
            
            // Plano
            var p:Plane = new Plane(new WireframeMaterial(0xFF99CCFF), 5000, 5000, 8, 8);
            p.rotationX = 90;
            p.y = -1000;
            scene.addChild(p);
            
            // Canvas
            canvas = new BitmapData(465 / 4, 465 / 4, false, 0x000000);
            var bmp:Bitmap = new Bitmap(canvas, PixelSnapping.NEVER, false);
            bmp.scaleX = bmp.scaleY = 4;
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            
            mtx = new Matrix();
            mtx.scale(0.25, 0.25);
            
            //Texto 3D
            var text:String = "El arbol en nuestra dimension.";
            material = new Letter3DMaterial(0x000000);
            font3D = new HelveticaBold();
            texto3D = new Text3D(text,font3D,material);
            texto3D.x = 850;
            texto3D.y = 620;
            texto3D.localRotationY = -30;
            //texto3D.localRotationX = -30;
            texto3D.scale = 2;
            texto3D.material.lineThickness = 2;
            texto3D.material.lineAlpha = 1;
            texto3D.material.lineColor = 0xFF0000;
            scene.addChild(texto3D);
            // Inica el renderizado
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
            
            
        }
        
        /**
        * 
        */
        private function DibujaArbol(x:Number, y:Number, z:Number, length:Number, angle:Number, cf:int):void {
            level += 1;
            var destx:Number = x + length * Math.cos(angle * (Math.PI / 180));
            var desty:Number = y + length * Math.sin(angle * (Math.PI / 180));
            var destz:Number = z + length * (Math.random() - 0.5) * 2;

            if (Math.random() < 0.5)
                cf = COLORES[COLORES.length * Math.random() | 0];

            var max:int = 8 - level / 2;

            for (var i:int = 0; i < max; i++) {
                ArbolPixels.addPixel3D(new Pixel3D(cf,
                    destx * i / max + x * (max - i) / max,
                    desty * i / max + y * (max - i) / max,
                    destz * i / max + z * (max - i) / max
                    ));
            }

            if (level < 7) {
                DibujaArbol(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
                DibujaArbol(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
             // DibujaArbol(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
                //DibujaArbol(destx, desty, destz, length * (1 + 3 * Math.random()) * 0.25, angle + 60 * (Math.random() - Math.random()), cf);
            }
            level -= 1;
        }
        
        /**
        * エンターフレーム
        */ 
        private function loop(e:Event):void {
            // Movimiento de camara
            rot += (mouseX / stage.stageWidth * 3 * Math.PI - rot) * .1
            camera.x = Math.sin(rot) * 1500;
            camera.z = Math.cos(rot) * 1500;
            camera.y += (mouseY / stage.stageHeight * 3000 - 500 - camera.y) * .05;
            camera.fov = Math.sin(getTimer() / 2000) * 10 + 60;
            
            // Reticula
            canvas.fillRect(canvas.rect, 0x000000);
            canvas.draw(viewport, mtx);
        }
    }
}