/**
 * Copyright Pelisalinet ( http://wonderfl.net/user/Pelisalinet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vkHo
 */

// forked from Pelisalinet's FollowCamera - Alternativa3D
package {
    import flash.text.*;
    import flash.text.engine.*;
    
    import alternativ5.engine3d.loaders.*;
    import alternativ5.utils.*;
    import alternativ5.types.*;
    import alternativa.engine3d.core.*;
    import alternativ5.engine3d.materials.*;
    import alternativ5.engine3d.primitives.*;
    import alternativa.engine3d.events.MouseEvent3D;
    import alternativ5.engine3d.controllers.*;
    import alternativa.engine3d.core.*;
    import alternativa.engine3d.loaders.*;
    import alternativ5.engine3d.materials.DevMaterial;
    
    import com.bit101.components.*;
     
    import flash.geom.*;
    import flash.display.*;
    import flash.utils.describeType;
    import flash.events.*;
    import flash.ui.Keyboard;
    import flash.net.*;
    import flash.system.*;
    
    
    [SWF(width = 1200, height = 700, frameRate = 60, backgroundColor=0x00000000)]
    public class SimpleDemo extends Sprite {

    public var template:BasicTemplate = new BasicTemplate();
    
        public function SimpleDemo():void {
            
            Wonderfl.capture_delay(9);            
            
            addChild(template);
           
           var back_map:Loader = new Loader();
           back_map.load(new URLRequest('http://www.iamthomasvogel.de/wp-content/uploads/skybox_360.jpg'));
           addChildAt(back_map,0);
           
           //desing images
           var rank_ico:Loader = new Loader();
           rank_ico.load(new URLRequest('http://images.wikia.com/halo/images/a/ae/ReachRank11.png'));
           addChild(rank_ico);
           var rank_box:MovieClip = new MovieClip();
           rank_box.graphics.lineStyle(1,0x00ff00);
           rank_box.graphics.beginFill(0x0000FF);
            rank_box.graphics.drawRect(0,0,280,15);
            rank_box.graphics.endFill();
            rank_box.x = 60;
            addChild(rank_box);
            var health_box:MovieClip = new MovieClip();
           health_box.graphics.lineStyle(1,0x00ff00);
           health_box.graphics.beginFill(0x00055500);
            health_box.graphics.drawRect(0,0,200,15);
            health_box.graphics.endFill();
            health_box.x = 520;
            addChild(health_box);
           var health_box_icon:Loader = new Loader();
           health_box_icon.load(new URLRequest('http://www.praguepost.com/css/classifieds/category-health.png'));
           //health_box_icon.width = health_box_icon.height = 30;
           health_box_icon.y = stage.stageHeight-50;
           addChild(health_box_icon);
           var time_ico:Loader = new Loader();
           time_ico.load(new URLRequest('http://www.haahtelahr.fi/img/Clock.png'));
           time_ico.x = 370;
           addChild(time_ico);
           var flag_ico:Loader = new Loader();
           flag_ico.load(new URLRequest('http://png-5.findicons.com/files/icons/1588/farm_fresh_web/32/flag_green.png'));
           flag_ico.x = 440;
           addChild(flag_ico);
           //desing text
           var myFormat:TextFormat = new TextFormat();
            myFormat.size = 25;
           var rank_txt:TextField = new TextField();
           rank_txt.text = "0/10000";
           rank_txt.x = rank_ico.width+rank_ico.x+60;
           rank_txt.textColor = 0xFF0000;
           rank_txt.defaultTextFormat = myFormat;
           addChild(rank_txt);
           var action_txt:TextField = new TextField();
           action_txt.text = 'jouni1 killed tank_masotor\njouni1 has got enimy flag\n';
           action_txt.y = 50;
           action_txt.width = 200;
           action_txt.textColor = 0xFF0000;
           addChild(action_txt);
           var health_box_txt:TextField = new TextField();
           health_box_txt.text = "100%";
           health_box_txt.y = stage.stageHeight-36;
           health_box_txt.x = 10;
           addChild(health_box_txt);
           var chat_txt:TextField = new TextField();
           chat_txt.text = "jouni1: Hi tank_masotor\ntank_masotor: Hi Jouni1!\nkiril500: How I buy weapons?";
           chat_txt.width = 200;
           chat_txt.y = stage.stageHeight-130;
           chat_txt.x = 5;
           chat_txt.textColor = 0xFFFFFF;
           addChild(chat_txt);
           var time_txt:TextField = new TextField();
           time_txt.text = "10.00";
           time_txt.x = 400;
           time_txt.textColor = 0xFFFFFF;
           addChild(time_txt);
           var flag_txt:TextField = new TextField();
           flag_txt.text = "15";
           flag_txt.x = 470;
           flag_txt.textColor = 0xFFFFFF;
           addChild(flag_txt);
           
           
           /*var welcome_panel:Panel = new Panel(this, stage.stageWidth/2-500/2, 40);
           welcome_panel.width = 500;
           welcome_panel.height = 300;
           
           var wtext:Label = new Label(welcome_panel);
           wtext.text = "Welcome to the tank war!\n\nUse arrows to move your tank.\nPress space to shoot.\n";
           wtext.x = 50;
           wtext.y = 20;
           
           var wclose:PushButton = new PushButton(welcome_panel,500-15,0,"X",closeW);
           wclose.label = "X";
           wclose.x = 500-15;
           wclose.width = 15;
           
           function closeW():void {
               removeChild(welcome_panel);
           }*/


           var _sizeh:int = 80;

            /*for(var o:int=0; o < 200; o++){
            _sizeh = rando(40,100);
            var starf1:Box=new Box(20,20,_sizeh);
            starf1.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            starf1.y -= 50*o;
            starf1.z += _sizeh/2;
            starf1.x -= 35;
            template.scene.root.addChild(starf1);
            }*/
            
           

            
            var tmap:Loader = new Loader();
            tmap.load(new URLRequest(''));
            
            var light:Sphere = new Sphere(5);
                light.cloneMaterialToAllSurfaces(new FillMaterial(0xCCCC00));
                light.coords=new Point3D(-100,-100, 50);
            
            template.scene.root.addChild(light);
            
            var starf2A:Array = [];   
            
            var valo_1:shadingBox = new shadingBox(2,2.5,100);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            valo_1.originalDevMaterial(0x0000FF);
            valo_1.x -= 100;
            valo_1.y -= 100;
            valo_1.z += 0;
            starf2A.push(valo_1);
            
            template.scene.root.addChild(valo_1);
            
           /* for(var i:int=0; i < 1; i++){
            _sizeh = rando(40,100);
            var starf2:shadingBox = new shadingBox(20,20,_sizeh);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            starf2.originalDevMaterial(0x0000FF);
            starf2.y -= rando(-1000,1000);
            starf2.z += _sizeh/2;
            starf2.x += rando(-1000,1000);
            starf2A.push(starf2);

            template.scene.root.addChild(starf2);
            } */
            
            
            //x = x
            //y = z
            //z = y
            
            var taulu_1:shadingBox = new shadingBox(2,2.5,25);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            taulu_1.originalDevMaterial(0x0000FF);
            taulu_1.x -= 120;
            taulu_1.y -= 10;
            taulu_1.z += 0;
            starf2A.push(taulu_1);
            
             var taulu_11:shadingBox = new shadingBox(2,20,15);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            taulu_11.originalDevMaterial(0xFFFFFF);
            taulu_11.x -= 120;
            taulu_11.y -= 10;
            taulu_11.z += 20;
            starf2A.push(taulu_11);

            template.scene.root.addChild(taulu_1);
             template.scene.root.addChild(taulu_11);
             
             var taulu_2:shadingBox = new shadingBox(2,2.5,25);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            taulu_2.originalDevMaterial(0x0000FF);
            taulu_2.x += 100;
            taulu_2.y -= 10;
            taulu_2.z += 0;
            starf2A.push(taulu_2);
            
             var taulu_22:shadingBox = new shadingBox(2,20,15);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            taulu_22.originalDevMaterial(0xFFFFFF);
            taulu_22.x += 100;
            taulu_22.y -= 10;
            taulu_22.z += 20;
            starf2A.push(taulu_22);

            template.scene.root.addChild(taulu_2);
             template.scene.root.addChild(taulu_22);
             
             var bigbox:shadingBox = new shadingBox(70,70,10);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            bigbox.originalDevMaterial(0x0000FF);
            bigbox.x = 0;
            bigbox.y -= 10;
            bigbox.z += 0;
            starf2A.push(bigbox);
            
            template.scene.root.addChild(bigbox);
            
            var rbox:shadingBox = new shadingBox(30,2,15);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            rbox.originalDevMaterial(0x0000FF);
            rbox.x += 20;
            rbox.y -= 40;
            rbox.z += 10;
            starf2A.push(rbox);
            
            var rbox2:shadingBox = new shadingBox(2,30,15);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            rbox2.originalDevMaterial(0x0000FF);
            rbox2.x += 30;
            rbox2.y -= 30;
            rbox2.z += 10;
            starf2A.push(rbox2);
            
            template.scene.root.addChild(rbox);
            template.scene.root.addChild(rbox2);
            
             var kbox:shadingBox = new shadingBox(340,10,7);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            kbox.originalDevMaterial(0x0000FF);
            kbox.x -= 30;
            kbox.y -= 100;
            kbox.z += 10;
            starf2A.push(kbox);
            
            template.scene.root.addChild(kbox);
            
            var kbox2:shadingBox = new shadingBox(10,340,7);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            kbox2.originalDevMaterial(0x0000FF);
            kbox2.x += 145;
            kbox2.y -= 40;
            kbox2.z += 10;
            starf2A.push(kbox2);
            
            template.scene.root.addChild(kbox2);
            
            var kbox3:shadingBox = new shadingBox(340,10,7);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            kbox3.originalDevMaterial(0x0000FF);
            kbox3.x -= 30;
            kbox3.y -= 100;
            kbox3.z += 10;
            starf2A.push(kbox3);
            
            template.scene.root.addChild(kbox3);
            
            var kbox4:shadingBox = new shadingBox(340,10,7);
            //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
            kbox4.originalDevMaterial(0x0000FF);
            kbox4.x -= 30;
            kbox4.y = 100;
            kbox4.z += 10;
            starf2A.push(kbox4);
            
            template.scene.root.addChild(kbox4);
            
            for(var ff:int = 0; ff < 5; ff++){
                var kboxB:shadingBox = new shadingBox(13,15,10);
                //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
                kboxB.originalDevMaterial(0x0000FF);
                kboxB.x = 15*ff;
                kboxB.y -= 150;
                kboxB.z += 10;
                starf2A.push(kboxB);
            
                template.scene.root.addChild(kboxB);
            }
            
            for(var ff2:int = 0; ff2 < 5; ff2++){
                var kboxB2:shadingBox = new shadingBox(13,15,10);
                //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
                kboxB2.originalDevMaterial(0x0000FF);
                kboxB2.x = 15*ff2;
                kboxB2.y -= 150;
                kboxB2.z += 21;
                starf2A.push(kboxB2);
            
                template.scene.root.addChild(kboxB2);
            }

            
            
            function rando(low:Number=0, high:Number=1):Number
            {
              return Math.round(Math.random() * (high - low)) + low;
            }
            
            function onLoadingComplete(e:Event):void {
           for (var o:* in e.currentTarget.content.children) {
               Wonderfl.log(o.name);
               //cube = o;
            // template.scene.root.addChild(o);  
           }
           }
           
           var cube2:Box=new Box(4,4,3);
           cube2.cloneMaterialToAllSurfaces(new FillMaterial(10000000));
           
           var cube:Box=new Box(10,10,10);
           cube.cloneMaterialToAllSurfaces(new FillMaterial(10000000));
           
           var loader:Loader3DS = new Loader3DS();
            loader.smooth = true;
            loader.precision = TextureMaterialPrecision.HIGH;
            loader.load("http://s.tankionline.com/resources/0/114/140/154/1/object.3ds");
            loader.addEventListener(Event.COMPLETE, onLoadingComplete);
            
            //var light:Light = new Light(0xFFFFFF,0.8);
            
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,function(e:KeyboardEvent):void {
             if(e.keyCode == 32){
                var shootball:shadingBox = new shadingBox(2,2,2);
                //starf2.cloneMaterialToAllSurfaces(new FillMaterial(10010010));
                shootball.originalDevMaterial(0x0000FF);
                shootball.x = cube.x;
                shootball.y = cube.y-20;
                shootball.z = cube.z;
                starf2A.push(shootball); 
                template.scene.root.addChild(shootball);
                addEventListener(Event.ENTER_FRAME,function(e:Event):void {
                  shootball.y-=10;
                });

             }

           });
            
            
            
            //template.scene.root.addChild(cube2);
            template.scene.root.addChild(cube);
            
            cube.rotationY += 360/2;
            cube2.z = 12;
            cube.z = 5;
            //template.scene.root.addChild(cube);
             

            //var material:FillMaterial = new FillMaterial(0x666666, 1, 0,0x0);
            
            var plane:Plane = new Plane(2000, 2000, 4, 4);
            //plane.setMaterialToAllFaces(material);
            plane.cloneMaterialToAllSurfaces(new FillMaterial(00010000));
            template.scene.root.addChild(plane);
            
            /*var ti1:Plane = new Plane(90,10000,4,4);
            ti1.cloneMaterialToAllSurfaces(new FillMaterial(103050700));
            ti1.x += 10;
            ti1.y = -50;
            ti1.z = 2;
            template.scene.root.addChild(ti1);*/

            // SpringCameraController
            var cameraContoller:SpringCameraController=new SpringCameraController(this,template.camera);
            cameraContoller.target=cube;

            template.camera.fov=100*Math.PI/180

            cameraContoller.mass = 30;    
            cameraContoller.damping = 30;            
            cameraContoller.stiffness = 1;            
            cameraContoller.positionOffset = new Point3D(0, 50, 8);
            cameraContoller.lookOffset = new Point3D(0, 0, 0);
            
           

            var rot:Number = 0;
            var isKey:int;
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onEnterRend);
            
            function onEnterRend(k : KeyboardEvent):void{
                isKey = k.keyCode;
              
            }
            
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyOutRend);
            
            function onKeyOutRend(k : KeyboardEvent):void{
                
                isKey = 0;
            }

            var _speed:int = 5;
            var _times:int = 0;

            template.onPreRender = function():void {

                rot += 0.15;
               
                cube2.x = cube.x;
                cube2.y = cube.y;
                cube2.z = cube.z+4;
               
                cameraContoller.move();
                
                //light.y--;                
                
                if(_times < starf2A.length){
                starf2A[_times].shading(light); 
                _times++;
                }else{
                    _times=0;
                }

            }
            
            var controller:WalkController;
            
            controller = new WalkController(stage);

            controller.setDefaultBindings();
            controller.bindKey(KeyboardUtils.UP, ObjectController.ACTION_FORWARD);
            controller.bindKey(KeyboardUtils.DOWN, ObjectController.ACTION_BACK);
            controller.bindKey(KeyboardUtils.LEFT, ObjectController.ACTION_LEFT);
            controller.bindKey(KeyboardUtils.RIGHT, ObjectController.ACTION_RIGHT);

            controller.object = cube;
            controller.checkCollisions = true;
            controller.speed = 50;
            controller.jumpSpeed = 50;
            controller.gravity = 100;
            controller.objectZPosition = 0.95;
            controller.maxGroundAngle = MathUtils.toRadian(45);
            controller.speedMultiplier = 4;
            controller.coords = new Point3D(0, 0, 5);
            controller.lookAt(new Point3D(0, 0, 0));
            controller.collider.offsetThreshold = 0.0001;
            controller.collider.radiusX = 1;
            controller.collider.radiusY = 1;
            controller.collider.radiusZ = 5;
            
             addEventListener(Event.ENTER_FRAME,function():void{
            controller.processInput();
            });
            
        }
        
       



    }
}
import flash.net.URLRequest;
import flash.display.Loader;


import flash.display.DisplayObject;
import alternativ5.engine3d.controllers.WalkController;
import alternativ5.types.Matrix3D;
import alternativ5.types.Point3D;
import flash.utils.*;

//-------------------------------------------------------------------
//SpringCameraController
//-------------------------------------------------------------------
class SpringCameraController extends WalkController{
    
    private var _camTarget:Object3D
    private var _zrot:Number = 0;

    public var mass:Number = 40;
    public var damping:Number = 4;
    public var stiffness:Number = 1;
    public var positionOffset:Point3D = new Point3D(0, -50, 5);
    public var lookOffset:Point3D = new Point3D(0, 10, 2);


    public function SpringCameraController(eventSourceObject:DisplayObject, object:Object3D = null) {
        super(eventSourceObject,object)
    }

    public function set target(t:Object3D):void {
        _camTarget=t
    }

    public function get target():Object3D {
        return _camTarget;
    }

    public function set zrot(n:Number):void {
        _zrot = n;
        if(_zrot < 0.001) n = 0;
    }

    public function get zrot():Number {
        return _zrot;
    }

    private var _velocity:Point3D = new Point3D();
    private var _dv:Point3D = new Point3D();
    private var _stretch:Point3D = new Point3D();
    private var _force:Point3D = new Point3D();
    private var _acceleration:Point3D = new Point3D();

    private var _desiredPosition:Point3D = new Point3D();
    private var _lookAtPosition:Point3D = new Point3D();
    private var _xPosition:Point3D = new Point3D();

    public function move():void {
        if(_camTarget != null) {

            _desiredPosition = _camTarget.coords.clone();
            _desiredPosition.add(positionOffset.clone())

            _stretch.x = (coords.x - _desiredPosition.x) * -stiffness;
            _stretch.y = (coords.y - _desiredPosition.y) * -stiffness;
            _stretch.z = (coords.z - _desiredPosition.z) * -stiffness;

            _dv.x = _velocity.x * damping;
            _dv.y = _velocity.y * damping;
            _dv.z = _velocity.z * damping;

            _force.x = _stretch.x - _dv.x;
            _force.y = _stretch.y - _dv.y;
            _force.z = _stretch.z - _dv.z;

            _acceleration.x = _force.x * (1 / mass);
            _acceleration.y = _force.y * (1 / mass);
            _acceleration.z = _force.z * (1 / mass);

            _velocity.add(_acceleration);

            _xPosition=coords.clone()
            _xPosition.add(_velocity)
            coords=_xPosition

            _lookAtPosition=_camTarget.coords.clone()
            _lookAtPosition.add(lookOffset.clone())
            lookAt(_lookAtPosition);
            if(Math.abs(_zrot) > 0) object.rotationY = _zrot;

        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.display.BlendMode
import flash.events.Event;
import flash.geom.Rectangle
import flash.geom.ColorTransform

import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.types.Texture;
import alternativ5.types.Point3D;
import alternativ5.types.Matrix3D;
import alternativ5.engine3d.display.View;

import alternativ5.engine3d.primitives.Box;
import alternativ5.engine3d.primitives.Cone;
import alternativ5.engine3d.events.MouseEvent3D
import alternativ5.engine3d.materials.DevMaterial;
import alternativ5.engine3d.materials.FillMaterial;
import alternativ5.engine3d.materials.SurfaceMaterial;
import alternativ5.engine3d.materials.TextureMaterial
import alternativ5.utils.MathUtils;

/**
 * 追記
 * フラットシェーディングするbox
 */
class shadingBox extends Box{

    private var effectUtl:effectUtility;

    private var textureObj:Object;


    public function shadingBox(width:Number = 100, length:Number = 100, height:Number = 100, widthSegments:uint = 1, lengthSegments:uint = 1, heightSegments:uint = 1, reverse:Boolean = false, triangulate:Boolean = false) {
        super(width, length, height, widthSegments, lengthSegments, heightSegments, reverse, triangulate);
        effectUtl=new effectUtility(this);
        textureObj={}

    }


    public function lookAt(targetObject:*, upAxis:Point3D=null ):void {
        effectUtl.lookAt(targetObject, this.getFaceById('top_0_0').normal)
    }

    public function originalDevMaterial(color:uint):void {
        //originalのフラットシェーディングできるTextureを作成
        textureObj.top        =    new originalDevTexture(color);
        textureObj.front    =    new originalDevTexture(color);
        textureObj.right    =    new originalDevTexture(color);
        textureObj.bottom    =    new originalDevTexture(color);
        textureObj.back        =    new originalDevTexture(color);
        textureObj.left        =    new originalDevTexture(color);

        //各materialにTextureをセット
        this.setMaterialToSurface(new TextureMaterial(textureObj.top)            ,'top');
        this.setMaterialToSurface(new TextureMaterial(textureObj.front)        ,'front');
        this.setMaterialToSurface(new TextureMaterial(textureObj.right)        ,'right');
        this.setMaterialToSurface(new TextureMaterial(textureObj.bottom)        ,'bottom');
        this.setMaterialToSurface(new TextureMaterial(textureObj.back)            ,'back');
        this.setMaterialToSurface(new TextureMaterial(textureObj.left)            ,'left');
        
    }


    public function shading(targetObject:*):void {
        //光源(targetObject)に対してshadingLvを求め、Textureを変更
        textureObj.top.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('top_0_0').normal)));
        textureObj.front.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('front_0_0').normal)));
        textureObj.right.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('right_0_0').normal)));
        textureObj.bottom.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('bottom_0_0').normal)));
        textureObj.back.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('back_0_0').normal)));
        textureObj.left.shadeLv(toDegree(effectUtl.shadowLv(targetObject, this.getFaceById('left_0_0').normal)));

    }

    private function toDegree(no:Number):uint {
        var result:uint =Math.round(Math.abs(MathUtils.toDegree(no)));
        return result;
    }

}



//originalのフラットシェーディングできるTextureを作成するクラス
class originalDevTexture extends Texture{
    private var shadeBm:Bitmap;
    private var tempSprite:Sprite;

    public function originalDevTexture(color:int,_width:Number=10,_height:Number=10) {

        tempSprite = new Sprite();
        tempSprite.addChild(new Bitmap(new BitmapData(_width,_height, true, 0xFF000000 | color)))

        shadeBm = new Bitmap(new BitmapData(_width,_height, true, 0xFFFFFFFF))
        shadeBm.blendMode=BlendMode.HARDLIGHT
        tempSprite.addChild(shadeBm)

        super(new BitmapData(_width,_height, true, 0xFFFFFFFF));

        this.bitmapData.draw(tempSprite)
    }

    public function shadeLv(_lv:uint):void {
        //shadingLvでTextureをtranceform
        //0:明るい(100%[1])～180:暗い(0%[0])
        var cTransform:ColorTransform  = new ColorTransform();
        var lv:Number=(180-_lv)/180;

        cTransform.redMultiplier=lv
        cTransform.greenMultiplier=lv
        cTransform.blueMultiplier=lv
        shadeBm.transform.colorTransform = cTransform;

        this.bitmapData.draw(tempSprite)
    }

}




//プリミティブで使う、各種Utilityクラス
class effectUtility {

    private var thisObject:*
    public function effectUtility(mc:*) {
        thisObject=mc;
    }

    //光源に対してのシャドーLvを返す。
    public function shadowLv(targetObject:*, vAxis:Point3D=null ):Number {

        var position :Point3D = thisObject.coords;
        var target     :Point3D = targetObject.coords;
        var result     :Number = 0;

        //光源に対するZ方向(と距離)
        var zAxis      :Point3D = Point3D.difference(target,position);
        //光源への距離
        var length:Number =Math.sqrt(Math.pow(zAxis.x,2)+Math.pow(zAxis.y,2)+Math.pow(zAxis.z,2));

        //光源に対するZ方向(正規化)
        zAxis.normalize();

        //各面の法線は、faceから直接もらう

        if (vAxis) {
            //箱の方向で、各面の法線を回転
            var mtr    :Matrix3D = thisObject.transformation;
            mtr.d=0
            mtr.h=0
            mtr.l=0
            vAxis.transform(mtr)

            //内積を求めて、角度に変換(0:明るい～180:暗い)
            result=Math.acos(Point3D.dot(zAxis,vAxis))
        }

        return result;

    }


    public function lookAt(targetObject:*, vAxis:Point3D=null ):void {

        var position :Point3D = thisObject.coords;
        var target     :Point3D = targetObject.coords;

        var zAxis      :Point3D = Point3D.difference(target,position);
        zAxis.normalize();

        if (!vAxis) {
            vAxis=new Point3D(0,1,0)
        }

        //var mtr    :Matrix3D = thisObject.transformation;
        //vAxis.transform(mtr)

        if( modulo(zAxis) > 0.1 ) {
            var xAxis :Point3D = Point3D.cross(vAxis, zAxis);
            xAxis.normalize();
            var yAxis :Point3D = Point3D.cross( zAxis, xAxis);
            yAxis.normalize();

            var look    :Matrix3D = thisObject.transformation;

            var mtr:Matrix3D=new Matrix3D()
            mtr.rotate(MathUtils.toRadian(90),MathUtils.toRadian(90),MathUtils.toRadian(90))
            vAxis.transform(mtr)

            look.a =    xAxis.x * thisObject.scaleX*reverseCheck(vAxis.x);
            look.e =    xAxis.y * thisObject.scaleX*reverseCheck(vAxis.x);
            look.i =    xAxis.z * thisObject.scaleX*reverseCheck(vAxis.x);
            
            look.b =    yAxis.x * thisObject.scaleY*reverseCheck(vAxis.y);
            look.f =    yAxis.y * thisObject.scaleY*reverseCheck(vAxis.y);
            look.j =    yAxis.z * thisObject.scaleY*reverseCheck(vAxis.y);
            
            look.c =    zAxis.x * thisObject.scaleZ*reverseCheck(vAxis.z);
            look.g =    zAxis.y * thisObject.scaleZ*reverseCheck(vAxis.z);
            look.k =    zAxis.z * thisObject.scaleZ*reverseCheck(vAxis.z);

            var rotations:Point3D = look.getRotations();
            
            thisObject.rotationX = rotations.x;
            thisObject.rotationY = rotations.y;
            thisObject.rotationZ = rotations.z;

        }

    }


    private function modulo(target:Point3D):Number {
        return Math.sqrt( target.x*target.x + target.y*target.y + target.z*target.z );
    }

    private function reverseCheck(no:Number):Number {
        var result:Number=1;
        if (no<0) result=-1;
        return result;
    }
    
}


import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{

    public var scene:Scene3D;

    public var view:View;

    public var camera:Camera3D;

    public var cameraController:CameraController;
    
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;


    public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        // Creating scene
        scene = new Scene3D();
        scene.splitAnalysis = false; // not analysis for performance
        scene.root = new Object3D();
        
        // Adding camera
        camera = new Camera3D();
        camera.z = -1000;
        scene.root.addChild(camera);
        
        // camera contoller
        cameraController = new CameraController(this);
        cameraController.camera = camera;
        
        // set view
        view = new View();
        view.camera = camera;
        addChild(view);
        
        // stage
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    

    protected function atInit():void {}
    

    private var _onInit:Function = function():void { };
    public function get onInit():Function { return _onInit; }
    public function set onInit(value:Function):void {
        _onInit = value;
    }
    

    protected function atPreRender():void {}
    

    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    

    protected function atPostRender():void {
    }
    

    protected var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void {
        _onPostRender = value;
    }
    
 
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }

    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    public function singleRender():void {
        onRenderTick();
    }
    
    /**
     * @private
     */
    private function init(e:Event = null):void {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        // resize
        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
        
        // render
        startRendering();
        
        atInit();
        _onInit();
        
    }
    
    /**
     * @private
     */
    private function onRenderTick(e:Event = null):void {
        atPreRender();
        _onPreRender();
        scene.calculate();
        atPostRender();
        _onPostRender();
    }
    
    /**
     * @private
     */
    private function onResize(event:Event = null):void {
        if (_scaleToStage) {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
            view.graphics.clear()
            view.graphics.beginFill(0x000000)
            view.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)  
            var b:Loader = new Loader();
            b.load(new URLRequest('http://www.mrpaulmaul.com/wp-content/uploads/2010/02/sunset-palm-trees.jpg'));
            view.addChildAt(b,0);          
        }else {
            view.width = _viewWidth;
            view.height = _viewHeight;
            view.graphics.clear();
            view.graphics.beginFill(0x000000)
            view.graphics.drawRect(0,0,_viewWidth,_viewHeight)
        }
    }
}



