/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vj1b
 */

package {
    import flash.display.*;
    import flash.net.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.utils.*;
    import flash.media.*;
    import com.bit101.components.PushButton;
    
    //task
    //直近の１０種類のタスクをリスト表示
    //１０リスト以上を表示するにはmoreを選択
    //タスクの名前は後から変更可能
    public class FlashTest extends Sprite {
        private var so:SharedObject;
        private var taskNameList:Array;
        private var tf1:TextField = new TextField();
        private var tf2:TextField = new TextField();
        private var tf3:TextField = new TextField();
        private var tf4:TextField = new TextField();
        private var logText:String;
        
        private var slider1:Slider;
        private var timer:Date;
        private var log:Array;
        
        //private var date1:Date = new Date(2014,0,1);
        private var date1:Date = new Date(2013,11,31);
        private var txt:TextField = new TextField();

        private function onFrame(e:Event):void{
            var now:Date =new Date();
            var n:Number = date1.getTime()-now.getTime();
            n -= 3600*1000*9;
            var n2:Date = new Date();
            n2.setTime(n);
            var n3:int = (n/(3600*1000))
            n3 += 9;
            n3 /= 24;
           
            var str:String = new String();
            //str+= (n2.getFullYear()-1970).toString();
            //str+= (n2.getMonth()).toString();
            //str+= "/"+(n2.getDate()).toString();
            str+= "残り時間 "+n3.toString()+"日 + ";
            str+= " "+(n2.getHours()).toString();
            str+= ":"+(n2.getMinutes()).toString();
            str+= ":"+(n2.getSeconds()).toString();
            str+= "."+(n2.getMilliseconds()).toString();
            txt.text = str;
        }
        
        public function FlashTest() {
            
                        addChild(txt);

            txt.width =200;
            txt.y = 320;
            addEventListener(Event.ENTER_FRAME,onFrame);

            
            this.slider1 = new Slider(this, 30, 280, 300, 30,""," min", false, true, 0, 120, 60);
            slider1.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            slider1.addChild(tf3);
            tf4.text = "no task";
            tf4.x = 200;
            tf4.y = 200;
            tf4.height = 40;
            addChild(tf4);
            tf3.text = "aaa2";
            tf3.selectable = false;
            tf3.height = 40;
            tf3.x = slider1.getWidth();
            tf3.y = 30;
            addChild(tf1);
            tf1.border = true;
            tf1.type = "input";
            addChild(tf2);
            tf2.x = 300;
            tf2.height = 200;
            // write as3 code here..
            so = SharedObject.getLocal("data");
            if(so){ 
                //so.clear();
                if(so.data.text != null){
                    tf1.text = so.data.text;
                }
                else{    
                    tf1.text "";
                    so.data.text = tf1.text;
                }
                if(so.data.list != null){
                    taskNameList = so.data.list;
                    var str:String =new String();
                    for(var i:int=0;i<taskNameList.length;i++){
                        str+=taskNameList[i]+"\n";
                    }
                    tf2.text = str;

                }
                else{
                    taskNameList = new Array();
                    so.data.list = taskNameList;
                }
                if(so.data.logText == null){
                    logText = new String();
                    so.data.logText = logText;
                }
                else{
                    logText = so.data.logText;
                    tf2.text = logText;
                    tf2.scrollV = tf2.maxScrollV;
                }






            }
            stage.addEventListener(KeyboardEvent.KEY_UP,onKey);
        }
        2
        private function onMouseDown(e:MouseEvent):void{
            stage.addEventListener(Event.ENTER_FRAME,onMove);
            slider1.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            ch.stop();
        }

        
        private function onMove(e:Event):void{
            var now:Date = new Date();
            var time:Date = new Date();
            time.setTime(now.getTime()+Math.round(slider1.getValue())*60*1000);
            var str:String = new String();
            var val:int = slider1.getValue();
            str += tf1.text+"\n";


            str += now.getHours().toString()+":";
            str += now.getMinutes().toString();
            str += " - "+time.getHours().toString()+":";
            str += time.getMinutes().toString();
            
            str += "\n"+Math.round(slider1.getValue()).toString()+"min";
            tf3.text = str;
            
        }

        private function onMouseUp(e:MouseEvent):void{
            stage.removeEventListener(Event.ENTER_FRAME,onMove);
            slider1.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            

            
            var now:Date = new Date();
            var time:Date = new Date();
            time.setTime(now.getTime()+slider1.getValue()*60*1000);
            var str:String = new String();
            str += tf1.text+" ";
            str += now.getHours().toString()+":";
            str += now.getMinutes().toString();
            
            str += " - "+time.getHours().toString()+":";
            str += time.getMinutes().toString();
            setTimer(slider1.getValue()*60*1000);
            
            //str += now.getSeconds().toString();
            tf4.text = str;
            
            tf2.appendText(str+"\n");//ログ追記
            so.data.logText = logText;
            logText += str+"\n";
            tf2.text = logText;
            tf2.scrollV = tf2.maxScrollV;
            
        }
        
        private var ti:Timer;
        private var sndUrl:URLRequest = new URLRequest("http://192.168.11.7/sound/bgm01.mp3");
        private var snd:Sound = new Sound(sndUrl);
        private function setTimer(ms:Number):void{
            timer = new Date();
            timer.setTime(timer.getTime()+ms);
            ti = new Timer(1000,0);
            ti.addEventListener(TimerEvent.TIMER,onTime);
            ti.start();
        }
        private var ch:SoundChannel;
        private function onTime(e:TimerEvent):void{
            var now:Date = new Date();
                if(timer.getTime() < now.getTime()){
                    //ch.stop();
                    e.target.removeEventListener(TimerEvent.TIMER,onTime);
                    tf2.appendText("[alarm] "+tf1.text+"\n");
                    tf4.text = "no task";
                    e.target.stop();
                    ch = snd.play(0,10);
                }
                var cnt:Number = timer.getTime()-now.getTime()
                var offset:Date = new Date();
                offset.setTime(timer.getTime()-now.getTime());
                var str:String = new String();
                str += offset.getUTCHours()+":";
                str += offset.getMinutes()+":";
                str += offset.getSeconds();
                //tf3.text = cnt.toString();
                tf4.text = tf1.text + "\n"+str; 
        }
        
        //taskName,timeStamp,sec



        
        private function onKey(e:KeyboardEvent):void{
            so.data.text = tf1.text;
            if(e.keyCode == 13){
                var str:String = tf1.text;
                taskNameList.push(str);
                tf1.text = "";
                tf2.appendText(str+"\n");
                
            }
            if(e.keyCode == Keyboard.SPACE){
                this.slider1.setValue(Math.random()*80);
            }


        }

    }
}






//スライダークラス
 
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import com.bit101.components.Label;
import com.bit101.components.Style; 

class Slider extends Sprite{
    public var myValue:Number = 0.0;
    private var bar:Sprite;
    private var myLine:Sprite;
    private var inline:Sprite;
    private var lineheight:int;
    private var max:Number = 1.0;
    private var min:Number = 0.0;
    private var spacer:int;
    private var addedSpacer:int;
    private var myParent:Sprite;
    private var suffix:String;
    private var preLabel:Label;
    private var valuePreLabel:String;
    private var valueLabel:Label;
    private var myWidth:int; 
    private var myHeight:int;
    private var showNumber:Boolean;
    private var showFiller:Boolean;
    
    public function Slider(refParent:Sprite, refX:int=0, refY:int=0, refWidth:int=100, refHeight:int=10, refLabel:String="", 
                           refSuffix:String="", refShowNumber:Boolean=true, refShowFiller:Boolean=true, min:Number = 0.0, max:Number = 1.0, refInitValue:Number= 0){
        this.myParent=refParent;
        this.x= refX;
        this.y= refY;
        this.myWidth= refWidth;
        this.myHeight= refHeight;
        this.valuePreLabel= refLabel;
        this.suffix= refSuffix;
        this.spacer= this.myHeight;
        this.showNumber= refShowNumber
        this.showFiller= refShowFiller;
        this.min = min;
        this.max = max;
        if(this.min>this.max){
            this.min = this.max;
        }
        if(this.max<this.min){
            this.max = this.min;
        }
        this.DrawSlider(refInitValue);
    }
    
    private function DrawSlider(refInitValue:Number):void{
        this.preLabel= new Label(this, 0, (this.myHeight/2) - Style.fontSize, this.valuePreLabel);
        this.myLine = new Sprite();
        this.addChild(this.myLine);
         
        this.inline = new Sprite();
        this.addChild(this.inline);
        
        this.valueLabel = new Label(this, this.addedSpacer + this.spacer + this.myLine.width, (this.myHeight/2) - Style.fontSize, this.myValue.toFixed(1) + this.suffix);
        if(this.showNumber==false){
            this.valueLabel.visible= false;
        }
 
        this.bar = new Sprite();
        this.addChild(this.bar);
        this.bar.addEventListener(MouseEvent.MOUSE_DOWN, onMyMouseDown);
        this.UpdateDrawing();
        this.myParent.addChild(this);
        this.setValue(refInitValue);
    }
    
    private function onMyMouseDown(event:MouseEvent):void{
        this.bar.startDrag(false, new Rectangle(0, 0, this.myWidth, 0));
        var stopIt:Function = function():void {bar.stopDrag(); removeEventListener(Event.ENTER_FRAME, Loop);};
        stage.addEventListener(Event.MOUSE_LEAVE, stopIt);
        stage.addEventListener(MouseEvent.MOUSE_UP, stopIt);
        this.addEventListener(Event.ENTER_FRAME, Loop);
    }
 
    private function Loop(event:Event):void{
        this.myValue = this.min + bar.x / this.myWidth * (this.max - this.min);
        if(this.showFiller==true){    
            this.inline.x= this.lineheight+this.addedSpacer - ((this.lineheight*bar.x)/this.myWidth) - (this.addedSpacer * (bar.x+this.lineheight)/this.myWidth);
            this.inline.width= bar.x;
        }
        this.dispatchEvent(new Event(Event.CHANGE));
        this.valueLabel.text = this.myValue.toFixed(1) + this.suffix;
    }
    
    private function UpdateDrawing():void{
        this.spacer= this.myHeight;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(this.myWidth, this.myHeight, 90 * Math.PI / 180, -6, -5);
        this.preLabel.y= (this.myHeight/2) - Style.fontSize;
                
        this.lineheight= Math.floor(this.myHeight/10);
        if(lineheight<1){
            lineheight=1;
        }
        this.addedSpacer= this.preLabel.width + this.spacer + this.lineheight;
        this.myLine.graphics.clear();
        this.myLine.graphics.lineStyle(this.lineheight, 0x939393);
        this.myLine.graphics.beginGradientFill("linear", [0xBEBEBE, 0xFFFFFF], [1.0, 1.0], [0, 255], matrix);
        this.myLine.graphics.drawRoundRect(this.addedSpacer, 0, this.myWidth, this.myHeight, 5, 5);
        this.myLine.graphics.endFill();
        
        this.inline.graphics.clear();
        this.inline.graphics.beginGradientFill("linear", [0x243f83, 0x558ac8], [1.0, 1.0], [0, 255], matrix);
        this.inline.graphics.drawRoundRect(this.addedSpacer + this.lineheight/2, this.lineheight/2, this.myWidth-this.lineheight, this.myHeight-this.lineheight, 5, 5);
        this.inline.graphics.endFill();
        
        this.valueLabel.x = this.addedSpacer + this.spacer + this.myLine.width;    
        this.valueLabel.y = (this.myHeight/2) - Style.fontSize;
        
        this.bar.graphics.clear();
        this.bar.graphics.lineStyle(this.lineheight, 0xE0E0E0);
        this.bar.graphics.beginGradientFill("linear", [0xBEBEBE, 0xFFFFFF], [1.0, 1.0], [0, 255], matrix);
        this.bar.graphics.drawCircle(this.addedSpacer, this.myHeight/2, this.myHeight-this.lineheight);
        this.bar.graphics.endFill();
        this.setValue(this.myValue);
    }
    
    public function setValue(refValue:Number):void{
        if(refValue<this.min){
            refValue=this.min;
        }
        if(refValue>this.max){
            refValue=this.max;
        }
        bar.x= (refValue - this.min) * this.myWidth / (this.max - this.min);
        this.Loop(null);
    }
    
    public function getValue():Number{
        return this.myValue;
    }
    
    public function setX(refX:Number):void{
        this.x= refX;
    }
    
    public function getX():Number{
        return this.x;
    }
    
    public function setY(refY:Number):void{
        this.y= refY;
    }

    public function getY():Number{
        return this.y;
    }

    public function setWidth(refWidth:Number):void{
        this.myWidth= refWidth;
        this.UpdateDrawing();
    }
    
    public function getWidth():Number{
        return this.myWidth;
    }
    
    public function setHeight(refHeight:Number):void{
        this.myHeight= refHeight;
        this.UpdateDrawing();
    }
    
    public function getHeight():Number{
        return this.myHeight;
    }
    
    public function setPreLabel(refLabel:String):void{
        this.valuePreLabel= refLabel;
        this.preLabel.text= this.valuePreLabel;
        this.UpdateDrawing();
    }
    
    public function setSuffix(refSuffix:String):void{
        this.suffix= refSuffix;
        this.Loop(null);
    }

    public function setShowNumber(refShowNumber:Boolean):void{
        this.showNumber= refShowNumber;
        this.valueLabel.visible= this.showNumber;
    }

    public function getShowNumber():Boolean{
        return this.showNumber;
    }

    public function setShowFiller(refShowFiller:Boolean):void{
        this.showFiller= refShowFiller;
        this.inline.visible= this.showFiller;
    }
    
    public function getShowFiller():Boolean{
        return this.showFiller;
    }

    public function setMinMax(refMin:Number,refMax:Number):void{
        this.min= refMin;
        this.max= refMax;
        if(this.min>this.max){
            this.min = this.max;
        }
        if(this.max<this.min){
            this.max = this.min;
        }
        this.Loop(null);
    }
    
    public function getMin():Number{
        return this.min;
    }
    
    public function getMax():Number{
        return this.max;
    }
    
}