/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vitY
 */

package  {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import net.hires.debug.Stats;
	
	[SWF(backgroundColor="0", frameRate="30", width="465", height="465")]
	
	/**
	 * ...
	 * @author 393
	 */
	public class Yura extends Sprite{
		private var _bmd:BitmapData = new BitmapData(465, 465,false,0);
		private var _bm:Bitmap = new Bitmap(_bmd);
		private var _phase:int;
		private var _gain:int;
		
		public function Yura() {
			addChild(_bm);
			addChild(new Stats());
			
			addEventListener(Event.ENTER_FRAME, timerHandler);
		};
		private function timerHandler(e:Event):void {
			_gain += (((mouseY - (stage.stageHeight / 2))) - _gain) * 0.1;
			
			var substract:int = ((mouseX - stage.stageWidth/2)/stage.stageWidth) * 200+2;
			_phase -= substract;
			if (_phase >= 0) _phase -= 360;
			if (_phase <= -360) _phase = 360 + _phase;
			
			_bmd.lock();
			_bmd.fillRect(_bmd.rect, 0);
			drawLine(0+_phase,_gain,0xFF0000);
			drawLine(1+_phase+3*_phase-120,_gain,0x00FF00);
			drawLine(2+_phase+6*_phase-240,_gain,0x0000FF);
			_bmd.unlock();
		}
		private function drawLine(phase:int, gain:int, color:int):void {
			for (var i:int = phase; i < 465; i += 3) {
				var yMax:int = Math.sin(Math.PI / (mouseX/360) * (phase + i)) * gain+465 / 2;
				for (var j:int = 0; j < yMax; j++) {
					_bmd.setPixel(i, j, color);
				}
			}
		}
	}
}