/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vhupv
 */

// forked from plus-tic's パーティクル練習
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
 
	public class Main extends Sprite
	{
		private var balls:Vector.<Ball> = new Vector.<Ball>();
		private var bd:BitmapData;
		private var circle:BitmapData;
 
		public function Main()
		{
			var c:Sprite = new Sprite();
			c.graphics.beginFill(0x009AD6);
			c.graphics.drawCircle(5, 5, 2);
			c.graphics.endFill();
 
			circle = new BitmapData(10, 10, true, 0x0);
			circle.draw(c);
			circle.applyFilter(circle, circle.rect, new Point(), new GlowFilter(0xFFFFFF));
 
			addChild(new Bitmap(bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)));
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void 
		{
			var ball:Ball = new Ball();
			ball.x = Math.random() * stage.stageWidth;
			ball.y = 0;
			ball.vy = Math.random() * 3 + 3;
			balls.push(ball);
 
			bd.fillRect(bd.rect, 0x0);
 
			for (var i:int = 0; i < balls.length; i++)
			{
				ball = balls[i];
				ball.y += ball.vy;
				bd.copyPixels(circle, circle.rect, new Point(ball.x, ball.y), null, null, true);
 
				if (ball.y >= stage.stageHeight + 10)
				{
					balls.splice(i--, 1);
				}
			}
		}
	}
}
 
class Ball
{
	public var x:Number;
	public var y:Number;
 
	public var vx:Number;
	public var vy:Number;
}
 