/**
 * Copyright ekumeko ( http://wonderfl.net/user/ekumeko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vhtR
 */

// forked from bkzen's マトリックスっぽいの
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import com.flashdynamix.motion.Tweensy;
    import com.flashdynamix.motion.TweensyTimeline;
    import fl.motion.easing.Cubic;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    
    /**
     * 間に合わんかった上に作りたかったものとちょっとちがう。
     * さらにソースが汚すぎる。
     * 朝ワンの時間だけで作るのは無理だな。
     */
    [SWF(width = "465", height = "465", backgroundColor = "0x0", frameRate = "30")]
    public class Professional extends Sprite {
        
        private var patterns: Array;
        private var texts: Array;
        private var txtMatrix: Array;
        private var txtMatrix2: Matrix = new Matrix();
        private var length: int;
        private var grid: BitmapData;
        private var matrix: Matrix;
        private var frame: int;
        private var phase: int;
        private var scale: int;
        private var shape: Shape;
        private var maskSp: Sprite;
        private var bmd: BitmapData;
        private var tmpBmd: BitmapData;
        private var tmpBmd2: BitmapData;
        private var point: Point = new Point();
        private var blur: BlurFilter = new BlurFilter();
        
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            patterns = makePatterns();
            grid     = makeGrid();
            shape = new Shape();
            addChild(new Bitmap(bmd = new BitmapData(465, 465, true, 0x0), "auto", true));
            tmpBmd = bmd.clone();
            tmpBmd2 = bmd.clone();
            matrix = new Matrix();
            scale = 100;
            makeTexts();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function makeTexts(): void
        {
            texts = [], txtMatrix = [];
            var txt: TextField = new TextField(), str: String = "Wesave ", i: int, w: Number = 0, bmd: BitmapData, m: Matrix;
            for (i = 0; i < str.length; i++ )
            {
                txt.text = str.charAt(i);
                txt.autoSize = TextFieldAutoSize.LEFT;
                //txt.textColor = 0xFFFFFF;
                txt.scaleX = txt.scaleY = 4;
                bmd = new BitmapData(txt.width, txt.height, true, 0x0);
                bmd.draw(txt, txt.transform.matrix);
                texts.push(bmd);
                w += bmd.width + 50;
            }
            w /= 2;
            w -= 78;
            var timeline: TweensyTimeline;
            for (i = 0; i < texts.length; i++ )
            {
                bmd = texts[i];
                m = new Matrix();
                m.tx = (465 - w) / 2;
                m.ty = - 100;
                txtMatrix.push(m);
                w -= bmd.width
                switch (i)
                {
                    case 0:
                        w -= 40;
                    break;
                    case 1:
                    case 2:
                        w -= 20;
                    break;
                    case 3:
                        w -= 30;
                    break;
                    case 4:
                        w -= 10;
                    break;
                }
                timeline = Tweensy.to(m, { ty: (465 - bmd.height) / 2 }, 1, Cubic.easeIn, Math.random() * 3);
                timeline.onComplete = onComp;
            }
        }
        
        private function onComp(): void
        {
            phase ++;
        }
        
        private function loop(e:Event):void 
        {
            var b: BitmapData;
            var m: Matrix;
            switch (phase)
            {
                case 6:
                    scale ++;
                    if (scale > 600) phase = 7;
                break;
                case 7:
                    scale --;
                    if (scale < 2) phase = 6;
                break;
            }
            matrix.a = matrix.d = scale / 300;
            matrix.tx = matrix.ty = 232
            var g:Graphics = shape.graphics;
            var pattern: BitmapData = patterns[frame % length];
            g.clear();
            g.beginBitmapFill(pattern, matrix, true, true);
            g.drawRect(0, 0, 480, 480);
            g.endFill();
            g.beginBitmapFill(grid);
            g.drawRect(0, 0, 480, 480);
            tmpBmd.lock();
            tmpBmd.fillRect(tmpBmd.rect, 0x0);
            var n: int = texts.length, i: int;
            for (i = 0; i < n; i++ )
            {
                b = texts[i];
                m = txtMatrix[i];
                tmpBmd.draw(b, m, null, null, null, true);
            }
            tmpBmd.unlock();
            tmpBmd2.lock();
            txtMatrix2.a = txtMatrix2.d = Cubic.easeIn(scale, 0.3, 150, 600);
            txtMatrix2.tx = txtMatrix2.ty = (465 - 465 * txtMatrix2.a) / 2;
            tmpBmd2.draw(tmpBmd, txtMatrix2, null, null, null, true);
            tmpBmd2.applyFilter(tmpBmd2, tmpBmd2.rect, point, blur);
            tmpBmd2.colorTransform(tmpBmd2.rect, new ColorTransform(1, 1, 1, 1, 0, 0, 0, -10));
            tmpBmd2.unlock();
            bmd.lock();
            bmd.fillRect(bmd.rect, 0x0);
            bmd.draw(shape);
            bmd.copyChannel(tmpBmd2, tmpBmd2.rect, point, BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
            bmd.unlock();
            frame++;
        }
        public function makePatterns(): Array
        {
            patterns = [];
            var i: int, a: Array, j: int, n: int = 13;
            length = patternArray.length / n;
            for (i = 0; i < length; i++ )
            {
                patterns.push(BitmapPatternBuilder.build(patternArray, colorArray));
                for (j = 0; j < n; j++ )
                {
                    a = patternArray.pop();
                    patternArray.unshift(a);
                }
            }
            return patterns;
        }
        
        public function makeGrid(): BitmapData
        {
            return BitmapPatternBuilder.build([[0, 0, 1], [0, 0, 1], [1, 1, 1]], [0x20000000, 0xC0000000]);
        }
        
        private const patternArray: Array = [[0,0,0,1,2,3,3,3,4,5,5,5,5,5,5,5,5,3,3,3,3,1,1,0,0,0,0,0,0,0,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0],
        [0,1,1,3,3,3,5,5,5,5,5,5,6,6,5,5,5,5,5,5,3,3,2,1,0,0,0,0,1,1,2,3,3,3,4,5,5,5,5,5,5,5,5,5,3,3,3,1,0,0,0,0],
        [1,2,3,3,5,5,5,5,6,6,6,6,6,6,6,6,6,6,5,5,5,4,3,3,1,1,1,1,2,3,3,4,5,5,5,5,5,6,6,6,6,6,5,5,5,4,3,2,1,0,0,0],
        [2,3,3,5,5,5,6,6,7,7,7,7,7,7,7,7,7,6,6,6,5,5,5,3,3,2,2,3,3,3,5,5,5,5,6,6,6,6,7,7,7,6,6,6,5,5,3,3,1,0,0,0],
        [3,3,5,5,6,6,7,7,8,8,8,8,8,8,8,8,8,7,7,6,6,5,5,5,3,3,3,3,3,5,5,5,6,6,7,7,7,8,8,8,8,7,7,6,6,5,5,3,2,0,0,1],
        [3,5,5,6,6,7,8,8,9,10,11,11,11,11,11,11,10,8,8,7,7,6,5,5,5,3,3,3,5,5,6,6,7,7,8,8,8,9,9,12,13,11,10,7,6,5,5,3,3,1,1,2],
        [5,5,6,6,7,8,9,13,11,11,11,11,11,11,11,11,11,11,14,8,8,7,6,5,5,5,3,5,5,5,6,7,7,8,8,9,13,11,11,11,11,11,13,7,6,6,5,4,3,1,1,3],
        [5,6,6,7,8,9,11,11,11,11,11,11,11,11,11,11,11,11,11,13,8,8,7,6,5,5,5,5,5,6,6,15,10,11,11,11,11,11,11,11,11,11,10,8,7,6,5,5,3,2,2,3],
        [5,6,7,8,9,11,11,11,11,11,11,13,14,14,11,11,11,11,11,11,13,8,7,6,6,5,5,5,5,6,8,11,11,11,11,11,11,11,11,11,11,11,13,8,7,6,5,5,3,2,3,4],
        [6,7,8,9,10,11,11,11,11,11,16,14,14,14,14,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,6,11,11,11,11,11,11,11,11,11,11,11,10,9,7,6,5,5,3,3,3,5],
        [6,7,8,14,11,11,11,11,11,11,13,14,14,14,14,11,11,11,11,11,11,11,9,8,7,6,5,5,5,6,6,7,8,14,10,11,11,11,11,11,11,11,13,9,8,6,5,5,3,3,4,5],
        [7,8,9,11,11,11,11,11,11,11,14,9,9,9,14,13,11,11,11,11,11,11,14,8,7,6,5,5,5,5,6,7,8,9,14,11,11,11,11,11,11,11,13,9,8,6,5,5,3,3,5,5],
        [7,8,14,11,11,11,11,11,11,16,14,9,9,9,9,14,11,11,11,11,11,11,16,9,8,6,6,5,5,5,6,6,7,9,14,13,11,11,11,11,11,11,13,9,8,6,5,5,3,3,5,6],
        [7,9,10,11,11,11,11,11,11,13,9,9,8,8,9,14,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,8,9,13,11,11,11,11,11,11,13,9,8,6,5,5,4,5,5,6],
        [8,9,11,11,11,11,11,11,11,13,9,8,8,8,9,9,11,11,11,11,11,11,11,14,8,7,6,5,5,5,5,6,7,8,9,13,11,11,11,11,11,11,10,9,8,6,5,5,4,5,5,6],
        [8,9,11,11,11,11,11,11,11,14,9,8,7,8,8,9,16,11,11,11,11,11,11,10,9,7,6,5,5,5,5,6,6,8,9,13,11,11,11,11,11,11,10,9,8,6,5,5,5,5,5,6],
        [8,14,11,11,11,11,11,11,11,14,9,8,7,7,8,9,10,11,11,11,11,11,11,11,9,8,6,5,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,5,6],
        [8,13,11,11,11,11,11,11,11,9,8,8,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [9,10,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [9,13,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [9,13,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,6,5,5,5,6,7],
        [9,13,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,6,5,5,5,6,7],
        [9,13,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [9,13,11,11,11,11,11,11,11,9,8,7,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [8,13,11,11,11,11,11,11,11,9,8,8,7,7,8,9,13,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,6,7],
        [8,14,11,11,11,11,11,11,11,14,9,8,7,7,8,9,10,11,11,11,11,11,11,11,9,8,6,5,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,6,5,5,5,5,5,6],
        [8,9,11,11,11,11,11,11,11,14,9,8,7,8,8,9,16,11,11,11,11,11,11,13,9,7,6,5,5,4,5,5,6,7,9,13,11,11,11,11,11,11,10,9,8,6,5,5,5,5,5,6],
        [8,9,11,11,11,11,11,11,11,13,9,8,8,8,9,9,11,11,11,11,11,11,11,13,8,7,6,5,5,4,5,5,6,7,9,13,11,11,11,11,11,11,10,9,8,7,6,5,5,5,5,6],
        [7,9,10,11,11,11,11,11,11,13,9,9,8,8,9,14,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,5,6,8,9,13,11,11,11,11,11,11,10,9,8,7,6,5,5,5,5,6],
        [7,8,14,11,11,11,11,11,11,16,14,9,9,9,9,14,11,11,11,11,11,11,11,9,8,6,6,5,5,5,5,6,7,8,9,13,11,11,11,11,11,11,16,9,8,7,6,5,5,5,5,6],
        [7,8,9,11,11,11,11,11,11,11,14,9,9,9,14,13,11,11,11,11,11,11,14,8,7,6,5,5,5,5,5,6,7,8,9,13,11,11,11,11,11,11,16,9,8,7,6,5,5,5,5,5],
        [6,7,8,14,11,11,11,11,11,11,13,14,14,14,14,11,11,11,11,11,11,11,9,8,7,6,5,5,5,5,6,6,7,8,9,13,11,11,11,11,11,11,11,14,8,7,6,6,5,5,5,5],
        [6,7,8,9,16,11,11,11,11,11,16,14,14,14,14,11,11,11,11,11,11,14,8,7,6,5,5,5,5,5,6,7,7,8,9,13,11,11,11,11,11,11,11,14,9,8,7,6,5,5,5,5],
        [5,6,7,8,9,11,11,11,11,11,11,13,14,14,11,11,11,11,11,11,10,8,7,7,6,5,5,5,5,5,6,7,8,9,14,11,11,11,11,11,11,11,11,14,9,8,7,6,6,5,5,5],
        [5,6,6,7,8,9,11,11,11,11,11,11,11,11,11,11,11,11,11,13,8,8,7,6,5,5,5,5,5,6,7,13,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,17,6,5,5,5],
        [5,5,6,6,7,8,9,13,11,11,11,11,11,11,11,11,11,11,14,8,8,7,6,5,5,5,5,5,5,6,15,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10,6,5,5,5],
        [4,5,5,6,6,7,8,8,9,10,11,11,11,11,11,11,10,8,8,7,7,6,5,5,5,3,3,5,5,5,6,10,10,10,10,14,14,13,13,13,13,14,14,10,10,10,10,17,6,5,5,4],
        [3,4,5,5,6,6,7,7,8,8,8,9,9,9,9,8,8,8,7,7,6,5,5,5,3,3,3,4,5,5,6,6,7,7,8,8,9,9,9,9,9,9,8,8,8,7,6,6,5,5,5,3],
        [3,3,4,5,5,6,6,7,7,7,8,8,8,8,8,8,7,7,6,6,5,5,5,3,3,3,3,3,5,5,6,6,7,7,7,8,8,8,8,8,8,8,8,8,7,7,6,6,5,5,4,3],
        [2,3,3,5,5,5,6,6,7,7,7,8,8,8,8,7,7,6,6,5,5,5,3,3,2,2,3,3,5,5,5,6,6,7,7,8,8,8,8,8,8,8,8,7,7,6,6,6,5,5,3,3],
        [3,3,3,5,5,5,6,6,7,7,7,8,8,8,8,7,7,6,6,5,5,3,3,1,1,1,3,3,5,5,6,6,7,7,7,8,8,8,8,8,8,8,8,7,7,7,6,6,5,5,3,3],
        [3,3,5,5,5,6,6,7,7,8,8,8,8,8,8,8,7,6,6,5,5,3,2,1,1,2,3,3,5,5,6,6,7,8,8,8,9,9,9,9,9,9,8,8,8,7,6,6,5,5,3,3],
        [3,4,5,5,6,6,7,7,8,8,9,9,9,10,11,11,12,7,6,5,5,3,2,1,1,2,3,5,5,6,6,7,8,8,9,10,11,11,11,11,11,11,10,9,8,8,7,6,6,5,5,3],
        [3,5,5,5,6,7,7,8,9,14,10,11,11,11,11,11,12,7,6,6,5,3,3,1,2,3,4,5,6,6,7,8,8,10,11,11,11,11,11,11,11,11,11,11,10,8,8,7,6,6,5,5],
        [5,5,5,6,7,12,10,11,11,11,11,11,11,11,11,11,14,8,7,6,5,4,3,2,3,3,5,5,6,7,8,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,9,8,7,6,5,5],
        [5,5,5,6,12,11,11,11,11,11,11,11,11,11,11,11,14,8,7,6,5,5,3,3,3,5,5,6,7,8,9,13,11,11,11,11,11,11,14,14,11,11,11,11,11,11,13,9,8,7,6,5],
        [5,5,5,6,17,11,11,11,11,11,11,11,11,11,11,11,14,8,7,6,5,5,3,3,3,5,6,6,7,8,13,11,11,11,11,11,11,14,14,14,14,11,11,11,11,11,11,14,8,7,6,6],
        [5,5,5,6,6,7,8,14,16,11,11,11,11,11,11,11,13,8,7,6,5,5,3,3,5,5,6,7,8,9,11,11,11,11,11,11,13,14,14,14,14,13,11,11,11,11,11,11,9,8,7,6],
        [5,5,5,6,6,7,8,9,14,11,11,11,11,11,11,11,13,8,7,6,5,5,3,3,5,5,6,7,8,10,11,11,11,11,11,11,14,14,9,9,14,14,11,11,11,11,11,11,10,8,7,6],
        [5,5,5,5,6,7,8,9,14,11,11,11,11,11,11,11,13,9,7,6,5,5,3,4,5,6,7,8,9,11,11,11,11,11,11,11,14,9,9,9,9,14,11,11,11,11,11,11,11,9,8,7],
        [6,5,5,5,6,6,7,8,14,11,11,11,11,11,11,11,13,9,7,6,5,5,3,5,5,6,7,8,14,11,11,11,11,11,11,11,9,9,8,8,9,9,11,11,11,11,11,11,11,14,8,7],
        [6,5,5,5,5,6,7,8,9,16,11,11,11,11,11,11,13,9,7,6,5,5,4,5,5,6,7,9,10,11,11,11,11,11,11,13,9,8,8,8,8,9,10,11,11,11,11,11,11,10,9,7],
        [6,5,5,5,5,6,7,8,9,16,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,6,8,9,11,11,11,11,11,11,11,13,9,8,8,8,8,9,13,11,11,11,11,11,11,11,9,8],
        [6,5,5,5,5,6,7,8,9,10,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,13,9,8,7,7,8,9,13,11,11,11,11,11,11,11,9,8],
        [6,5,5,5,5,6,6,8,9,10,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,14,9,8,7,7,8,9,14,11,11,11,11,11,11,11,9,8],
        [6,5,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,9,8,7,7,8,9,14,11,11,11,11,11,11,11,14,8],
        [7,6,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,8,8,7,7,8,8,14,11,11,11,11,11,11,11,13,8],
        [7,6,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,8,7,7,7,7,8,14,11,11,11,11,11,11,11,13,8],
        [7,6,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,8,7,7,7,7,8,14,11,11,11,11,11,11,11,13,8],
        [7,6,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,8,8,7,7,8,8,14,11,11,11,11,11,11,11,13,8],
        [6,5,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,13,11,11,11,11,11,11,11,14,9,8,7,7,8,9,14,11,11,11,11,11,11,11,13,8],
        [6,5,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,14,9,8,7,7,8,9,14,11,11,11,11,11,11,11,9,8],
        [6,5,5,5,5,5,6,8,9,13,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,13,9,8,7,7,8,9,13,11,11,11,11,11,11,11,9,8],
        [6,5,5,4,5,5,6,8,9,10,11,11,11,11,11,11,13,9,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,13,9,8,8,8,8,9,13,11,11,11,11,11,11,11,9,8],
        [6,5,5,4,5,6,7,8,9,10,11,11,11,11,11,11,13,9,7,6,5,5,5,5,5,6,7,9,13,11,11,11,11,11,11,13,9,8,8,8,8,9,10,11,11,11,11,11,11,13,9,7],
        [6,5,5,5,5,6,7,8,9,10,11,11,11,11,11,11,13,9,8,6,5,5,5,5,5,6,7,8,14,11,11,11,11,11,11,11,9,9,8,8,9,9,11,11,11,11,11,11,11,14,8,7],
        [5,5,5,5,5,6,7,8,9,16,11,11,11,11,11,11,13,9,8,7,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,14,9,9,9,9,14,11,11,11,11,11,11,11,9,8,7],
        [5,5,5,5,5,6,7,8,9,16,11,11,11,11,11,11,13,9,8,7,6,5,5,5,5,6,6,7,9,10,11,11,11,11,11,11,14,14,9,9,14,14,11,11,11,11,11,11,10,9,7,6],
        [5,5,5,5,6,6,7,8,14,11,11,11,11,11,11,11,13,9,8,7,6,6,5,5,5,5,6,7,8,9,11,11,11,11,11,11,13,14,14,14,14,13,11,11,11,11,11,11,9,8,7,6],
        [5,5,5,5,6,7,8,9,14,11,11,11,11,11,11,11,13,9,8,7,7,6,5,5,5,5,6,6,7,8,13,11,11,11,11,11,11,14,14,14,14,11,11,11,11,11,11,13,8,7,6,6],
        [5,5,5,6,6,7,8,9,14,11,11,11,11,11,11,11,11,14,9,8,7,6,5,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,14,14,11,11,11,11,11,11,11,9,8,7,6,5],
        [5,5,5,6,17,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,13,7,6,5,5,5,5,5,6,7,8,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,9,8,7,6,5,5],
        [5,5,5,6,10,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,15,6,5,5,5,5,5,6,6,7,8,8,10,11,11,11,11,11,11,11,11,11,11,10,8,8,7,6,6,5,5],
        [4,5,5,6,18,10,10,10,13,14,14,14,14,14,14,14,14,10,10,10,10,6,5,5,5,3,4,5,5,6,6,7,8,8,9,10,11,11,11,11,11,11,10,9,8,8,7,6,6,5,5,3],
        [3,5,5,5,6,6,7,7,8,8,8,8,8,8,8,8,8,8,7,7,6,6,5,5,4,3,3,3,5,5,6,6,7,7,8,8,8,8,8,8,8,8,8,8,7,7,6,6,5,5,3,3],
        [3,3,5,5,5,6,6,6,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,5,3,3,3,3,3,5,5,5,6,6,7,7,7,7,7,7,7,7,7,7,6,6,5,5,5,3,3,3],
        [3,3,4,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,3,3,2,2,2,3,3,4,5,5,5,6,6,6,6,6,6,6,6,6,6,5,5,5,4,3,3,2,1],
        [2,3,3,3,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,3,3,3,1,1,1,1,2,3,3,5,5,5,5,5,5,6,6,5,5,5,5,5,5,3,3,2,1,0,0]];
        
        private const colorArray: Array = [0x0, 0x8000, 0xC000, 0xE000, 0x2000E000, 0x2000FF00, 0x4000FF00, 0x6000FF00, 0x8000FF00, 0xA000FF00, 0xE000E000, 0xFF00FF00, 0xC000E000, 0xE000FF00, 0xC000FF00, 0xA000E000, 0xFF00E000, 0x8000E000, 0x6000E000];
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}