/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vhSh
 */

package {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.DropShadowFilter;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class FlashTest extends Sprite {
		// 定数
		private const WIDTH:uint = Constant.WIDTH;
		private const HEIGHT:uint = Constant.HEIGHT;
		private const MAX_SCORE:uint = 99999999;
		private const MAX_LEVEL:uint = 50;
		
		// オブジェクト
		private var _layerInfo:Sprite;
		private var _layerGatherRect:Sprite;
		private var _layerStar:Sprite;
		private var _tfScore:TextField;
		private var _tfLevel:TextField;
		private var _tfEXP:TextField;
		private var _starContainer:/*Star*/Array;
		
		// データ
		private var _score:uint = 0;
		private var _level:uint = 1;
		private var _exp:uint = 0;
		private var _size:Number = 120.0;
		private var _genSpeed:Number = 10.0;
		private var _genStock:Number = 0.0;

		public function FlashTest() {
			init();
		}
		
		private function init():void {
			// 初期設定
			stage.frameRate = 30;
			updateParam();
			
			// 背景
			var g:Graphics = this.graphics;
			g.beginFill( 0x000000 );
			g.drawRect( 0, 0, WIDTH, HEIGHT );
			g.endFill();
			
			// レイヤー
			{
				_layerInfo = new Sprite();
				_layerGatherRect = new Sprite();
				_layerStar = new Sprite();
				
				// 下からadd
				this.addChild( _layerStar );
				this.addChild( _layerGatherRect );
				this.addChild( _layerInfo );
			}

			// 文字関連
			_tfScore = generateTextField();
			_tfScore.y = 400;
			_tfLevel = generateTextField();
			_tfLevel.y = 430;
			_tfEXP = generateTextField();
			_tfEXP.x = 140;
			_tfEXP.y = 430;
			updateInfo();
			
			// コンテナ
			_starContainer = new Array();
			
			// イベント
			stage.addEventListener( Event.ENTER_FRAME, proc );
			stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDown );
		}

		private function generateTextField():TextField {
			var format:TextFormat = new TextFormat();
			format.font = "_typewriter";
			format.size = 28;
			format.color = 0xFFFFFF;

			var textField:TextField = new TextField();
			textField.width = 400;
			textField.defaultTextFormat = format;
			textField.selectable = false;
			
			var dropShadow:DropShadowFilter = new DropShadowFilter( 2, 45, 0x000000, 1.0, 2, 2 );
			textField.filters = [ dropShadow ];
			
			_layerInfo.addChild( textField );
			
			return textField;
		}
		
		private function proc(e:Event):void {
			_genStock += _genSpeed;

			while ( _genStock >= 100.0 ) {
				var s:Star = new Star();
				_layerStar.addChild( s );
				s.x = Math.random() * 465;
				s.y = -20;
				
				_starContainer.push( s );

				_genStock -= 100.0;
			}
		}
		
		private function mouseDown(e:MouseEvent):void {
			// 枠
			var rect:GatherRect = new GatherRect( e.stageX, e.stageY, _size );
			_layerGatherRect.addChild( rect );
			
			// 取得判定
			var starCount:uint = 0;
			var sizeHalf:Number = _size * 0.5;
			for ( var i:uint = 0; i < _starContainer.length; ++i ) {
				var s:Star = _starContainer[ i ];
				if ( ( s.x - s.sizeHalf - sizeHalf < e.stageX ) && ( e.stageX < s.x + s.sizeHalf + sizeHalf ) ) {
					if ( ( s.y - s.sizeHalf - sizeHalf < e.stageY ) && ( e.stageY < s.y + s.sizeHalf + sizeHalf ) ) {
						++starCount;
						s.onGatherd();
						_starContainer.splice( i, 1 );
						--i;
						continue;
					}
				}
			}
			
			if ( starCount > 0 ) {
				// 取得数
				var count:GatherCount = new GatherCount( e.stageX, e.stageY, starCount );
				_layerInfo.addChild( count );
				
				// スコア取得
				if ( _score < MAX_SCORE ) {
					_score += Calc.Score( starCount );
					if ( _score > MAX_SCORE ) _score = MAX_SCORE;
				}

				// 経験値取得
				if ( _level < MAX_LEVEL ) {
					var levelUp:Boolean = false;
					_exp += Calc.EXP( starCount );
					while ( _exp >= Calc.NextEXP( _level ) ) {
						levelUp = true;
						_exp -= Calc.NextEXP( _level );
						++_level;
					}
					if ( _level > MAX_LEVEL ) _level = MAX_LEVEL;

					// レベルアップ時
					if ( levelUp ) {
						updateParam();
						_layerInfo.addChild( new LevelUp() );
					}
				}

				// 表示更新
				updateInfo();
			}
		}

		private function updateInfo():void {
			_tfScore.text = "SCORE : " + toScoreString( _score );
			
			if ( _level < MAX_LEVEL ) {
				_tfLevel.text = "LV " + _level + "  EXP " + _exp + "/" + Calc.NextEXP( _level );
			}
			else {
				_tfLevel.text = "LV " + _level + " (Maximum)";
			}
		}
		
		private function updateParam():void {
			_size = 112;
			for ( var idx:uint = 0; idx < _level; ++idx ) {
				if ( idx < 5 ) _size += 8;
				else if ( idx < 10 ) _size += 4;
				else if ( idx < 20 ) _size += 3;
				else if ( idx < 30 ) _size += 2;
				else _size += 1;
			}
			
			_genSpeed = 5 + ( _level * 2 );
		}
		
		private function toScoreString(value:uint):String {
			var s:String = "";
			for ( var i:uint = 1; i < 8; ++i ) {
				if ( value < Math.pow( 10, i ) ) s += "0";
			}
			s += value.toString();
			return s;
		}
	}
}

import caurina.transitions.Tweener;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.display.StageQuality;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.events.Event;
import flash.geom.Point;

class Constant extends Sprite {
	static public const WIDTH:uint = 465;
	static public const HEIGHT:uint = 465;
}

class Star extends Sprite {
	private var _sizeHalf:Number;
	private var _speed:Number;
	private var _rotSpeed:Number;
	private var _color:uint;

	public function get sizeHalf():Number { return _sizeHalf; }
	
	public function Star() {
		_sizeHalf = 6.0 + ( Math.random() * 8.0 );
		_speed = 4.0 + ( Math.random() * 2.0 );
		_rotSpeed = ( Math.random() * 6.0 ) - 3.0;
		
		var colors:Array = [ 0xffff80, 0xff4040, 0x40ff40, 0x8080ff, 0x80ffff, 0xff80ff ];
		_color = colors[ uint( Math.random() * colors.length ) ];

		Drawer.DrawStar( this.graphics, _sizeHalf, _color );
		this.addEventListener( Event.ENTER_FRAME, proc )
	}
	
	private function proc(e:Event):void {
		this.y += _speed;
		this.rotationZ += _rotSpeed;
		
		if ( this.y > 500 ) {
			dead();
			return;
		}
	}
	
	public function onGatherd():void {
		for ( var i:uint = 0; i < 4; ++i ) {
			var ptcl:Ptcl = new Ptcl( this.x, this.y, _sizeHalf * 0.7, _color );
			this.parent.addChild( ptcl );
		}
		
		dead();
	}
	
	public function dead():void {
		if ( this.parent != null ) {
			this.parent.removeChild( this );
			this.removeEventListener( Event.ENTER_FRAME, proc );
		}
	}
}

class Ptcl extends Sprite {
	public function Ptcl( x:Number, y:Number, sizeHalf:Number, color:uint ) {
		this.x = x;
		this.y = y;
		
		Drawer.DrawStar( this.graphics, sizeHalf, color );
		
		var rad:Number = Math.random() * Math.PI * 2;
		var cos:Number = Math.cos( rad );
		var sin:Number = Math.sin( rad );
		
		var speed:Number = 8.0;
		
		var tweenParam:Object = {
			alpha:0,
			time:25,
			useFrames:true,
			onUpdate:function():void {
				this.x += cos * speed;
				this.y += sin * speed;
			},
			onComplete:function():void {
				if ( this.parent != null ) {
					this.parent.removeChild( this );
				}
			}
		};
		
		Tweener.addTween( this, tweenParam );
	}
}

class GatherRect extends Sprite {
	public function GatherRect( x:Number, y:Number, size:Number ) {
		this.x = x;
		this.y = y;
		
		var g:Graphics = this.graphics;
		g.lineStyle( 1, 0xffffff );
		
		var sizeHalf:Number = size * 0.5;
		g.drawRect( -sizeHalf, -sizeHalf, size, size );

		this.alpha = 0;
		
		var scale:Number = 0.75;
		this.scaleX = scale;
		this.scaleY = scale;
		
		var tweenParam1:Object = {
			alpha:1,
			scaleX:1,
			scaleY:1,
			time:5,
			useFrames:true
		};

		var tweenParam2:Object = {
			alpha:0,
			delay:5,
			time:2,
			useFrames:true,
			onComplete:function():void {
				if ( this.parent != null ) {
					this.parent.removeChild( this );
				}
			}
		};

		Tweener.addTween( this, tweenParam1 );
		Tweener.addTween( this, tweenParam2 );
	}
}

class GatherCount extends Sprite {
	
	private var _tf:TextField;
	private var _tfScore:TextField;
	private var _tfEXP:TextField;
	
	public function GatherCount( x:Number, y:Number, count:uint ) {
		this.x = x;
		this.y = y;
		
		_tf = new TextField();
		_tfScore = new TextField();
		_tfEXP = new TextField();

		setup( _tf, -40, 20 );
		setup( _tfScore, 20, 14 );
		setup( _tfEXP, 36, 14 );

		if ( count > 1 ) {
			_tf.text = "" + count.toString() + " Stars!!";
		}
		else {
			_tf.text = "1 Star";
		}
		
		_tfScore.text = "+" + Calc.Score( count ) + " Score";
		_tfEXP.text = "+" + Calc.EXP( count ) + " EXP";

		var scale:Number = 2.0;
		
		var tweenParam:Object = {
			delay:5,
			time:5,
			alpha:0,
			useFrames:true,
			onComplete:function():void {
				this.removeChild( _tf );
				this.removeChild( _tfScore );
				this.removeChild( _tfEXP );
				
				if ( this.parent != null ) {
					this.parent.removeChild( this );
				}
			}
		};

		Tweener.addTween( this, tweenParam );
	}

	private function setup( tf:TextField, y:Number, size:Number ):void {
		var width:Number = 200;
		
		tf.x = -( width * 0.5 );
		tf.y = y;
		tf.width = width;
		tf.defaultTextFormat = createFormat( size );
		tf.selectable = false;
		
		this.addChild( tf );
	}
	
	private function createFormat( size:Number ):TextFormat {
		var format:TextFormat = new TextFormat();
		format.font = "_typewriter";
		format.size = size;
		format.color = 0xFFFFFF;
		format.align = "center";
		return format;
	}
}

class LevelUp extends Sprite {
	
	private var _tf:TextField;
	
	public function LevelUp() {
		this.x = 0;
		this.y = Constant.HEIGHT * 0.5 - 20;
		
		var format:TextFormat = new TextFormat();
		format.font = "_typewriter";
		format.size = 48;
		format.color = 0xFFFFFF;
		format.align = "center";

		_tf = new TextField();
		_tf.width = Constant.WIDTH;
		_tf.defaultTextFormat = format;
		_tf.selectable = false;
		
		this.addChild( _tf );

		_tf.text = "Level UP !";

		var tweenParam:Object = {
			delay:25,
			time:5,
			alpha:0,
			useFrames:true,
			onComplete:function():void {
				this.removeChild( _tf );
				if ( this.parent != null ) {
					this.parent.removeChild( this );
				}
			}
		};

		Tweener.addTween( this, tweenParam );
	}
}

class Drawer {
	static public function DrawStar(g:Graphics, size:Number, color:uint):void {
		g.beginFill( color );
		var lengthMin:Number = size * 0.55;
		var lengthMid:Number = size * 0.85;
		var lengthMax:Number = size * 1.0;
		var rad:Number = ( -Math.PI * 0.5 ) + ( Math.PI * 0.2 );
		g.moveTo( Math.cos( rad ) * lengthMin, Math.sin( rad ) * lengthMin );
		for (var index:uint = 0; index < 5; ++index) {
			rad += Math.PI * 0.16;
			g.lineTo( Math.cos(rad) * lengthMid, Math.sin(rad) * lengthMid );
			rad += Math.PI * 0.04;
			var ctrlX:Number = Math.cos( rad ) * lengthMax;
			var ctrlY:Number = Math.sin( rad ) * lengthMax;
			rad += Math.PI * 0.04;
			g.curveTo( ctrlX, ctrlY, Math.cos( rad ) * lengthMid, Math.sin( rad ) * lengthMid);
			rad += Math.PI * 0.16;
			g.lineTo(Math.cos( rad ) * lengthMin, Math.sin( rad ) * lengthMin);
		}
		g.endFill();
	}
}

class Calc {
	static public function Score( count:uint ):uint {
		return -1 + ( count * 2 );
	}
	static public function EXP( count:uint ):uint {
		return -1 + ( count * 2 );
	}
	static public function NextEXP( level:uint ):uint {
		return 10 + ( ( level - 1 ) * 10 );
	}
}