/**
 * Copyright alambertsimon ( http://wonderfl.net/user/alambertsimon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vhAf
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Graphics;
    
    [SWF(width = "465", height = "465", frameRate="60")]
    
    public class Main extends Sprite {
        
        private var _particles:Vector.<Particle>;
        private var canvasshape:Shape;
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        public function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            canvasshape = new Shape();
            addChild( canvasshape );
            
            _particles = new Vector.<Particle>();
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        private function AddParticle() : void
        {
            var p:Particle = new Particle();
            p.x = Math.random() * WIDTH;
            p.z = Math.random() * HEIGHT / 2 + HEIGHT / 2;
            _particles.push( p );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            var g:Graphics = canvasshape.graphics;
            g.clear();
            g.lineStyle(1, 0);
        
            var pnum:int = _particles.length;
            for ( var i:int = pnum - 1; i >= 0; i-- )
            {
                _particles[i].Move(mouseX, mouseY);
                
                if ( _particles[i].life == 0 )    _particles.splice( i, 1 );
                else
                {
                    g.drawCircle( _particles[i].x, _particles[i].z - _particles[i].y, 5 - (_particles[i].life / Particle.LIFE_MAX)*4 );        
                }
            }
            
            AddParticle();
        }
        
    }
    
}

const WIDTH:int = 465;
const HEIGHT:int = 465;

class Particle {

    public static const LIFE_MAX:int = 2000;
    
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public var rolPower:Number;
    public var upPower:Number;
    public var life:Number;
    
    public function Particle() {
        life = LIFE_MAX;
        rolPower = 100;
        upPower = 0;
        x = 0;
        y = 0;
        z = 0;
    }
    
    
    public function Move(tx:Number, tz:Number) : void
    {
        var sin:Number = Math.sin( (45 + rolPower) / 180 * Math.PI );
        var cos:Number = Math.cos( (45 + rolPower) / 180 * Math.PI );
        rolPower *= 0.999;
        
        var vecX:Number = (x - tx);
        var vecZ:Number = (z - tz); 
        var vx : Number = vecX * cos + vecZ * -sin;
        var vz : Number = vecX * sin + vecZ * cos;
        var r : Number = Math.sqrt(vx * vx + vz * vz);
        
        vx /= r; 
        vz /= r;
        
        x += vx * 4 * 5;
        z += vz * 1 * 5;
        
        y += upPower;
        upPower += 0.001;

        if( life > 0 )    life--;
    }
    
   
}