/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vgWK
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{	
		private var bd:BitmapData;
		private var brush:BitmapData;
		private var prev:Point = new Point();
 
		public function Main()
		{		
			bd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0);
			addChild(new Bitmap(bd));
 
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(30, 30, 45 * Math.PI / 180, 0, 0);
 
			var circle:Sprite = new Sprite();
			circle.graphics.beginGradientFill("linear", [0x80E0F8, 0xCbF7FE], [1.0, 1.0], [0, 255], matrix);
			circle.graphics.drawCircle(15, 15, 15);
			circle.graphics.endFill();
 
			brush = new BitmapData(30, 30, true, 0x0);
			brush.draw(circle);
			brush.applyFilter(brush, brush.rect, new Point(), new BlurFilter(8, 8));
 
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			var tx:Number = (mouseX - prev.x) / 10;
			var ty:Number = (mouseY - prev.y) / 10;
 
			for (var i:int = 0; i < 10; i++)
			{
				bd.copyPixels(brush, brush.rect, new Point(prev.x - brush.width / 2, prev.y - brush.height / 2));
				prev.x += tx;
				prev.y += ty;
			}
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
