/**
 * Copyright JorgeBraccini ( http://wonderfl.net/user/JorgeBraccini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vfzc
 */

package
{
    
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.net.URLVariables;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.system.Security;
    
    
    import net.badimon.five3D.display.Bitmap3D;
    
    [SWF(backgroundColor="#000000")]
    public class FlickrGalleryViewer extends Sprite {
        
        private var _connector    :FlickrConnector;
        private var _mode        :String;
        private var _user        :FlickrUser;
        private var _assets        :AssetLoader;
        private var _container    :Sprite;
        private var _status        :TextField;
        private var _ui            :BasicUI;

        public function FlickrGalleryViewer(){
            
            Security.allowDomain("*", "api.flickr.com");
            init();
        }
        
        private function init():void {
            
            _status = new TextField();
            _status.background = true;
            _status.transform.colorTransform.color = 0xFFFFFF;
            _status.setTextFormat(new TextFormat("Arial", 20, 0xffffff));
            _status.width = 300;
            _status.height = 25;
            addChild(_status);
            
            _user = new FlickrUser();
            _mode = FlickrConnectorMode.GETTING_USER_ID;
            _connector = new FlickrConnector("c512bd33216771ddf747f529d945d4a3", "84f479fc5e9c9ed1");
            _connector.addEventListener(FlickrConnectorEvent.RESPONSE, handleFlickrResponse);
            _assets = new AssetLoader();
            _assets.addEventListener(AssetLoaderEvent.COMPLETE, handleOnAssetsLoaded);
            _assets.addEventListener(AssetLoaderEvent.PROGRESS, handleOnAssetProgress);
            
            nextStep();
        }
        
        /*
        s    cuadrado pequeño 75x75
        t    imagen en miniatura, 100 en el lado más largo
        m    pequeño, 240 en el lado más largo
        -    mediano, 500 en el lado más largo
        z    mediano 640, 640 en el lado más largo
        b    grande, 1024 en el lado más largo*
        o    imagen original, ya sea jpg, gif o png, según el formato de origen
        
        http://farm{farm-id}.static.flickr.com/{server-id}/{id}_{secret}.jpg
        or
        http://farm{farm-id}.static.flickr.com/{server-id}/{id}_{secret}_[mstzb].jpg
        or
        http://farm{farm-id}.static.flickr.com/{server-id}/{id}_{o-secret}_o.(jpg|gif|png)
        
        
        */
        private function handleFlickrResponse(e:FlickrConnectorEvent):void {
            
            switch(_mode){
                case FlickrConnectorMode.GETTING_USER_ID:
                    _status.text = "Getting NSID..."
                    _user.nsid = e.response.user.attribute("id");
                    _user.username = e.response.user.username;
                    _mode = FlickrConnectorMode.GETTING_USER_PHOTOS;
                    break;
                case FlickrConnectorMode.GETTING_USER_PHOTOS:
                    _status.text = "Getting User Photos..."
                    var photos:XMLList = e.response.photos.children();
                    var photos_arr:Array = [];
                    var url:String;
                    var id:String;
                    var photo:FlickrPhoto;
                    
                    for each(var photo_xml:XML in photos){
                        Security.loadPolicyFile("http://farm"+photo_xml.attribute("farm")+".static.flickr.com/crossdomain.xml");
                        photo = new FlickrPhoto();
                        photo.id = photo_xml.attribute("id");
                        photo.url = "http://farm"+photo_xml.attribute("farm")+".static.flickr.com/"+photo_xml.attribute("server")+"/"+photo_xml.attribute("id")+"_"+photo_xml.attribute("secret")+"_s.jpg";
                        
                        photos_arr.push(photo);
                    }
                    
                    _user.photos = photos_arr;
                    _mode = FlickrConnectorMode.COMPLETE;
                    break;
            }
                
            nextStep();
        }
        
        private function nextStep():void {
            var vars:URLVariables = new URLVariables();
            
            switch(_mode){
                case FlickrConnectorMode.GETTING_USER_ID:
                    vars.url = "http://www.flickr.com/photos/_cici_/";
                    _connector.request("flickr.urls.lookupUser", vars); 
                    break;
                case FlickrConnectorMode.GETTING_USER_PHOTOS:
                    vars.user_id = _user.nsid;
                    vars.per_page = 200;
                    _connector.request("flickr.photos.search", vars);
                    break;
                case FlickrConnectorMode.COMPLETE:
                    setupAssets();
                    break;
            }
        }
        
        private function setupAssets():void {
            var photo:FlickrPhoto;
            for each(photo in _user.photos){
                _assets.addAsset(new Asset(photo.id, new URLRequest(photo.url)));
            }
            _assets.load();
        }
        
        private function handleOnAssetProgress(e:AssetLoaderEvent):void {
            _status.text = "Loading photo " + e.assetLoaded + " of " + e.assetTotal;
        }
        
        private function handleOnAssetsLoaded(e:AssetLoaderEvent):void {
            
            _ui = new BasicUI(_assets);
            addChild(_ui);
            _ui.init();
            
            _status.visible = false;
        }
    
    }
}

import flash.display.Sprite;
import flash.geom.Point;

import net.badimon.five3D.display.Scene3D;
import net.badimon.five3D.display.Sprite3D;

class Basic3DStage extends Sprite implements IRendereableObject {
    
    private var _assets        :AssetLoader;
    private var _scene        :Scene3D;
    private var _container    :Sprite3D;
    private var _renderer    :BasicRenderEngine;
    private var _origin        :Point3D;
    
    public function Basic3DStage(assets:AssetLoader){
        _assets = assets;
    }
    
    public function init():void {
        
        _scene = new Scene3D();
        _scene.x = stage.stageWidth / 2;
        _scene.y = stage.stageHeight / 2;
        
        _origin = new Point3D(0, 0, 0);
        
        _container = new Sprite3D();
        _container.childrenSorted = true;
        _container.x = _origin.x;
        _container.y = _origin.y;
        _container.z = _origin.z;
        
        _scene.addChild(_container);
        addChild(_scene);
        
        _renderer = new BasicRenderEngine();
        _renderer.addRendereableObject(this);
        
        initialize();
    } 
    
    protected function initialize():void {
        
    }
    
    protected function renderFrame():void {
        
    }
    
    public function doRender():void {
        renderFrame();
    }
    
    public function get scene():Scene3D { return _scene; }
    public function get container():Sprite3D { return _container; }
    public function get assets():AssetLoader { return _assets; }
    public function get renderer():BasicRenderEngine { return _renderer; }
    public function get origin():Point3D { return _origin; }
}


interface IRendereableObject {
    function doRender():void;
}

import flash.display.Bitmap;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.ui.Mouse;

import net.badimon.five3D.display.Bitmap3D;
import net.badimon.five3D.display.Sprite3D;

class BasicUI extends Basic3DStage {
    
    private var _prev_pos            :Point;
    private var _origin_mouse        :Point;
    private var _origin_container    :Point;
    private var _distance            :Number = 0;
    private var _offset                :Number = 0;
    private var _width                :Number;
    private var _ang                :Number = 0;
    private var _max_ang            :Number = 20;
    
    public function BasicUI(assets:AssetLoader){
        super(assets);
    }
    
    protected override function initialize():void {
        super.initialize();
        
        var asset:Asset;
        var pos:Point = new Point(-(stage.stageWidth / 2), -(stage.stageHeight / 2) + 40);
        var bmp:Bitmap;
        var sprite:Sprite3D;
        var bmp3d:Bitmap3D;
        var count:Number = 0;
        
        for each(asset in assets.assets){
            bmp = asset.asset as Bitmap;
            bmp3d = new Bitmap3D(bmp.bitmapData);
            bmp3d.x = pos.x;
            bmp3d.y = pos.y;
            
            if(count + 1 < 5){
                pos.y += bmp.height;
                count++;
            }else {
                pos.y = -(stage.stageHeight / 2) + 40;
                pos.x += bmp.width;
                count = 0;
            }
            
            container.addChild(bmp3d);
        }
        
        _width = pos.x + bmp.width;
        stage.addEventListener(MouseEvent.MOUSE_DOWN,     handleMouseDown);
        
        renderer.start();
        
    }
    
    protected override function renderFrame():void {
        super.renderFrame();
        container.x += Math.round((_offset - container.x) / 10);
        scene.rotationY += (_ang - scene.rotationY) / 5;
        
        if(_ang > 0){
            _ang = Math.round(_ang - 1);
        }else if(_ang < 0){
            _ang = Math.round(_ang + 1);
        }

    }
    
    private function handleMouseMove(e:MouseEvent):void {
        _distance = stage.mouseX - _origin_mouse.x;
        _offset = _origin_container.x + _distance;
        _ang += Math.round(stage.mouseX - _prev_pos.x);
        
        if(_ang < - _max_ang) _ang = -_max_ang;
        if(_ang > _max_ang) _ang = _max_ang;
        if(_offset > 0) _offset = 0;
        if(_offset < -(_width - (stage.stageWidth/2))) _offset = -(_width - (stage.stageWidth/2));
        
        _prev_pos = new Point(stage.mouseX, stage.mouseY);
    }
    
    private function handleMouseDown(e:MouseEvent):void {
        _distance = 0;
        _origin_mouse = new Point(stage.mouseX, stage.mouseY);
        _prev_pos = new Point(stage.mouseX, stage.mouseY);
        _origin_container = new Point(container.x, container.y);
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
        stage.addEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
    }
    
    private function handleMouseUp(e:MouseEvent):void {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
    }
}

import com.adobe.serialization.json.*;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IEventDispatcher;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.net.URLVariables;

class FlickrConnector extends EventDispatcher {
    
    private var _loader                :URLLoader;
    private var _api_url            :String;
    private var _api_key            :String;
    private var _api_secret            :String;
    
    public function FlickrConnector(api_key:String, api_secret:String){
        _api_key = api_key;
        _api_secret = api_secret;
        init();
    }
    
    private function init():void {
        _loader = new URLLoader();
        _loader.addEventListener(Event.COMPLETE, handleAPIResponse);
        
        _api_url = "http://api.flickr.com/services/rest/";
    }
    
    public function request(method:String, args:URLVariables):void {
        var url:URLRequest = new URLRequest(_api_url + "?method=" + method + "&api_key=" + _api_key + "&" + args.toString());
        _loader.load(url);
    }
    
    private function handleAPIResponse(e:Event):void {
        var response:XML = XML(e.target.data);
        dispatchEvent(new FlickrConnectorEvent(FlickrConnectorEvent.RESPONSE, response));
    }
    
}

import flash.display.Loader;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.ProgressEvent;
import flash.net.URLRequest;

class AssetLoader extends EventDispatcher {
    
    private var _assets                    :Array = [];
    private var _asset_id                :Number = 0;
    private var _loader                    :Loader;
    
    public function AssetLoader(){
        init();
    }
    
    private function init():void {
        _loader = new Loader();
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleAssetLoaded);
        _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, handleAssetProgress);
    }
    
    public function addAsset(assetData:Asset):void {
        _assets.push(assetData);
    }
    
    public function getAssetByName(name:String):Asset {
        var asset:Asset;
        for each(asset in _assets){
            if(asset.name == name){
                break;
            }
        }
        
        return asset;
    }
    
    public function load():void {
        loadAsset();
    }
    
    private function loadAsset():void {
        
        var assetData:Asset = _assets[_asset_id] as Asset;
        _loader.load(assetData.request);
        
        dispatchEvent(new AssetLoaderEvent(AssetLoaderEvent.PROGRESS, false, false, _assets.length, _asset_id + 1));
    }
    
    private function handleAssetLoaded(e:Event):void {
        var assetData:Asset = _assets[_asset_id] as Asset;
        assetData.asset = e.target.content;
        
        if(_asset_id + 1 < _assets.length){
            _asset_id++;
            loadAsset();
        }else{
            _asset_id = 0;
            dispatchEvent(new AssetLoaderEvent(AssetLoaderEvent.COMPLETE));
        }
    }
    
    private function handleAssetProgress(e:ProgressEvent):void {
        dispatchEvent(new ProgressEvent(ProgressEvent.PROGRESS, false, false, e.bytesLoaded, e.bytesTotal));
    }
    
    public function get assets():Array {
        return _assets;
    }
}


import flash.net.URLRequest;

class Asset {
    
    private var _name            :String;
    private var _request        :URLRequest;
    private var _asset            :*;
    
    public function Asset(name:String, request:URLRequest)    {
        _name = name;
        _request = request;
    }
    
    public function get name():String { return _name; }
    public function get request():URLRequest { return _request; }
    public function get asset():* { return _asset; }
    public function set asset(v:*):void { _asset = v; }
}

import flash.events.Event;

class FlickrConnectorEvent extends Event {
    
    private var _response:XML;
    
    public static var RESPONSE        :String = "response";
    
    public function FlickrConnectorEvent(type:String, response:XML, bubbles:Boolean=false, cancelable:Boolean=false){
        _response = response;
        super(type, bubbles, cancelable);
    }
    
    public function get response():XML { return _response; }
}

import flash.events.Event;

class AssetLoaderEvent extends Event {
    
    public static var PROGRESS    :String = "progreso";
    public static var COMPLETE    :String = "complete";
    
    private var _assetTotal        :Number;
    private var _assetLoaded    :Number;
    
    public function AssetLoaderEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false, assetTotal:Number=0, assetLoaded:Number=0){
        _assetTotal = assetTotal;
        _assetLoaded = assetLoaded;
        super(type, bubbles, cancelable);
    }
    
    public function get assetTotal():Number { return _assetTotal; }
    public function get assetLoaded():Number { return _assetLoaded; }
    
}

import flash.events.EventDispatcher;
import flash.events.TimerEvent;
import flash.utils.Timer;

class BasicRenderEngine extends EventDispatcher {
    
    private var _coreRender            :Timer;
    private var _renderList            :Array;
    
    public function BasicRenderEngine(){
        init();
    }
    
    private function init():void {
        _coreRender = new Timer(33);
        _coreRender.addEventListener(TimerEvent.TIMER, renderFrame);
        
        _renderList = [];
    }
    
    public function addRendereableObject(obj:IRendereableObject):void {
        _renderList.push(obj);
    }
    
    public function start():void {
        _coreRender.start();
    }
    
    public function stop():void {
        _coreRender.stop();
    }
    
    private function renderFrame(e:TimerEvent):void {
        var obj:IRendereableObject;
        for each(obj in _renderList){
            obj.doRender();
        }
    }
}

class Point3D {
    
    private var _x:Number;
    private var _y:Number;
    private var _z:Number;
    
    public function Point3D(x:Number=0, y:Number=0, z:Number=0){
        _x = x;
        _y = y;
        _z = z;
    }
    
    public function get x():Number { return _x; };
    public function get y():Number { return _y; };
    public function get z():Number { return _z; };
    
    public function set x(v:Number):void { _x = v; }
    public function set y(v:Number):void { _y = v; }
    public function set z(v:Number):void { _z = v; }
}

class FlickrConnectorMode{
    
    public static var GETTING_USER_ID            :String = "gettingUserId";
    public static var GETTING_USER_SET            :String = "gettingUserSet";
    public static var GETTING_USER_PHOTOS        :String = "gettingUserPhotos";
    public static var GETTING_PHOTO                :String = "gettingPhoto";
    public static var COMPLETE                    :String = "complete";
    
}





class FlickrUser {
    
    public var nsid:String;
    public var username:String;
    public var seturl:String;
    public var photos:Array = [];
}

class FlickrPhoto {
    public var url:String;
    public var id:String;
}