/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vfcN
 */

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    /**
     * クリックするたびに10fps〜60fpsの範囲で
     * 10fpsずつフレームレートが増えていきます
     */
    public class FlashTest extends Sprite {
  		
        private var child:Sprite;
        private var frameRate:int = 10;
        
        public function FlashTest() {
            // write as3 code here..
            super();
            this.stage.frameRate = 10;
            this.child = new Sprite();
            this.child.graphics.beginFill(0x000000);
            this.child.graphics.moveTo(0, 0);
            this.child.graphics.lineTo(0, 200);
            this.child.graphics.lineTo(100, 100 * Math.sqrt(3));
            this.child.graphics.lineTo(0, 0);
            this.child.x = this.stage.stageWidth / 2;
            this.child.y = this.stage.stageHeight / 2;
            this.addChild(this.child);
            this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown)
        }
        
        private function onEnterFrame(event:Event):void {
            this.child.rotation += 30;
        }
        
        private function onMouseDown(event:MouseEvent):void {
            this.frameRate += 10;
            if (this.frameRate > 60) {
                this.frameRate = 10;
            }
            this.stage.frameRate = this.frameRate;
        }
        
    }
}