/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vfEY
 */

// forked from _wonder's 3D速度・加速度
// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    import flash.accessibility.Accessibility;
    public class Velocity3D extends Sprite {
    		private var balls:Array;
    		private var numBalls:Number = 50;
    		private var fl:Number = 250;
    		private var vpX:Number = stage.stageWidth / 2;
    		private var vpY:Number = stage.stageHeight / 2;
    		private var top:Number = -100;
    		private var bottom:Number = 100;
    		private var left:Number = -100;
    		private var right:Number = 100;
    		private var front:Number = 100;
    		private var back:Number = -100;
    		
    		public function Velocity3D() {
            init();
        }
        
        private function init():void {
        		balls = new Array();
        		for( var i:uint = 0; i < numBalls; i++ ){
        				var ball:Ball = new Ball( 15 );
        				balls.push( ball );
        				ball.vx = Math.random() * 10 - 5;
        				ball.vy = Math.random() * 10 - 5;
        				ball.vz = Math.random() * 10 - 5;
        				addChild( ball );
        		}
        		addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
        		for( var i:uint = 0; i < numBalls; i++ ){
        			var ball:Ball = balls[i];
        			move( ball );
        		}
        		sortZ();
        }
        
        private function sortZ():void {
        		balls.sortOn("zpos", Array.DESCENDING | Array.NUMERIC);
        		for( var i:uint = 0; i < numBalls; i++ ){
        			var ball:Ball = balls[i];
        			setChildIndex( ball, i );
        		}
        }
        
        private function move(ball:Ball):void {
        		var radius:Number = ball.radius;
        		
        		ball.xpos += ball.vx;
        		ball.ypos += ball.vy;
        		ball.zpos += ball.vz;
        		
        		if( ball.xpos + radius > right ){
        			ball.xpos = right - radius;
        			ball.vx *= -1;
        		} else if ( ball.xpos - radius < left ){
        			ball.xpos = left + radius;
        			ball.vx *= -1;
        		}
        		
        		if( ball.ypos + radius > bottom ){
        			ball.ypos = bottom - radius;
        			ball.vy *= -1;
        		} else if ( ball.ypos - radius < top ){
        			ball.ypos = top + radius;
        			ball.vy *= -1;
        		}
        		
        		if( ball.zpos + radius > front ){
        			ball.zpos = front - radius;
        			ball.vz *= -1;
        		} else if ( ball.zpos - radius < back ){
        			ball.zpos = back + radius;
        			ball.vz *= -1;
        		}
        		
        		if( ball.zpos > -fl ){
        			var scale:Number = fl / ( fl + ball.zpos );
        			ball.scaleX = ball.scaleY = scale;
        			ball.x = vpX + ball.xpos * scale;
        			ball.y = vpY + ball.ypos * scale;
        			ball.visible = true;
        		} else {
        			ball.visible = false;
        		}
        }
        
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var vz:Number = 0;
	public var xpos:Number = 0;
	public var ypos:Number = 0;
	public var zpos:Number = 0;
	public var mass:Number = 1;
	
	public function Ball(radius:Number=40, color:uint=0Xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.lineStyle( 0 );
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}