/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/velQ
 */

//Japanino test
//画面をクリックするとパターンを変える。

package {
    import flash.display.Sprite;
    import flash.events.*;

    import caurina.transitions.Tweener;

    import funnel.*;

    [SWF(frameRate="60")]

    public class JapaninoTest extends Sprite {
        // 光残像キットを取付けたJapaninoボード
        private var _japanino:Arduino;

        public function JapaninoTest() {
            // Japaninoのインスタンスを生成する
            _japanino = new Arduino(Arduino.FIRMATA);

            // Japaninoの準備が完了した時に発生するイベントに対してリスナをセット
            _japanino.addEventListener(FunnelEvent.READY, onJapaninoReady);
            
            this.stage.addEventListener(MouseEvent.CLICK, onStageClick);
        }

        private function onJapaninoReady(e:Event):void {
        		// Japaninoの準備完了
            // Japaninoからのイベントに対してイベントリスナをセット
            _japanino.addEventListener(FunnelEvent.FIRMATA_STRING, onMessage);

            // 光残像キットのデフォルトパターン（7行×15桁）
            // なんかXX　こんな感じの。
            var pattern:Array = [
                parseInt("0000000", 2),
                parseInt("1000001", 2),
                parseInt("0100010", 2),
                parseInt("0010100", 2),
                parseInt("0001000", 2),
                parseInt("0010100", 2),
                parseInt("0100010", 2),
                parseInt("1000001", 2),
                parseInt("0100010", 2),
                parseInt("0010100", 2),
                parseInt("0001000", 2),
                parseInt("0010100", 2),
                parseInt("0100010", 2),
                parseInt("1000001", 2),
                parseInt("0000000", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送して表示をクリアする
            _japanino.sendSysexMessage(0x10, pattern);
        }

        // Japaninoからメッセージを受信すると呼ばれる
        private function onMessage(event:FunnelEvent):void {
            // メッセージが"!"であれば（＝光残像キットのハンドルが回転した通知であれば）
            if (event.message == "!") {
            }
        }

        private function onStageClick(evt:MouseEvent):void
        {
        		//Jananinoにメッセージを送る
        		sendMessage();
        }
        
        private function sendMessage():void
        {
            var pattern:Array;

            //魚のパターン
                pattern = [
                    parseInt("0001000", 2),
                    parseInt("0010100", 2),
                    parseInt("0010100", 2),
                    parseInt("0100010", 2),
                    parseInt("0100010", 2),
                    parseInt("1000001", 2),
                    parseInt("1000001", 2),
                    parseInt("1000001", 2),
                    parseInt("0100010", 2),
                    parseInt("0010100", 2),
                    parseInt("0001000", 2),
                    parseInt("0010100", 2),
                    parseInt("0100010", 2),
                    parseInt("1111111", 2),
                    parseInt("0000000", 2),];

            // パターンをカスタムのメッセージとしてJapaninoに転送する
            _japanino.sendSysexMessage(0x10, pattern);

        }

    }
}
