/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vehb
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width="465",height="465",frameRate="30")]
    public class MoveTest extends Sprite {
        private var circle:Sprite;
        private var _startX:Number = 5;
        private var _endX:Number = stage.stageWidth;
        private var _startY:Number = stage.stageHeight/2;
        private var _radius:Number = 5;
        private var _color:uint = 0x000000;
        private var _rate:Number = 0.2;
        private var _frames:Array;
        private var _frameCount:Number = 0;
        private var _frameLimit:Number = 30;
        
        public function MoveTest() {
            circle = new Sprite;
            circle.graphics.beginFill(_color);
            circle.graphics.drawCircle(0,0,_radius);
            circle.graphics.endFill();
            circle.x = _startX;
            circle.y = _startY;
            
            addChild(circle);
            
            _frames = make_frame();
            start();
        }
        
        private function start():void{
            circle.addEventListener(Event.ENTER_FRAME,move);
        }
        
        private function stop():void{
            circle.removeEventListener(Event.ENTER_FRAME,move);
        }
        
        private function make_frame():Array{
            var tmp:Array = new Array();
            var curX:Number = _startX;
            for(var i:int=0;i<_frameLimit;i++){
                curX += (_endX-curX)*_rate;
                tmp.push(curX);
            }
            return tmp;
        }
        
        private function move(e:Event):void{
            if(_frameCount < _frameLimit){
                circle.x = _frames[_frameCount];  
                _frameCount++; 
            } else {
                stop();
                end_func();   
            }
        }
        
        private function end_func():void{
            circle.x = 5; 
        }
    }
}