/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/veRP
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	/**
	 * ...
	 * @author Thi
	 */
	public class Main extends Sprite 
	{
		
		// sizes
		private var w:Number = stage.stageWidth
		private var h:Number = stage.stageHeight
		private var cx:Number = w>>1, cy:Number = h>>1 // center
		
		// layers
		private var layer0:Sprite, layer1:Sprite, layer2:Sprite
		
		// background
		private var back:Sprite
		private var backB:Bitmap
		private var backD:BitmapData
		
		// options buttons
		private var o1:Boolean, o2:Boolean
		private var O1:Sprite, O2:Sprite
		private var Opos:Vector.<Number>
		
		// temp var* reference
		private var g:Graphics
		private var s:Sprite
		private var t:TextField
		private var f:TextFormat
		
		// - - - - - - - - - - - - - - - - //
		
		// mouse states
		private var down:Boolean
		private var move:Boolean
		private var up:Boolean
		private var X:Number, Y:Number
		
		// objetos variables
		private var objetos:Vector.<Objeto>
		private var length:int // Vector length
		private var obj:Objeto // temp
		
		// physics variables
		private var G:Number = 1// gravitacional constant.000000000067
		private var M:Number = 1000 // planet mass
		
		// looping temp
		private var i:int
		
		
		
		// - - - - - - - - - - - - - - - - //
		
		// effect
		private var B:Bitmap
		private var D:BitmapData
		private var RECT:Rectangle
		private var COL:ColorTransform
		
		
		
		
		// class function
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		// initialize function
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			stage.scaleMode = StageScaleMode.NO_SCALE
			stage.align = StageAlign.TOP_LEFT
			
			// init layers
			layer0 = new Sprite()
			layer1 = new Sprite()
			layer2 = new Sprite()
			stage.addChild(layer0)
			stage.addChild(layer1)
			stage.addChild(layer2)
			
			// init buttons
			o1 = false
			o2 = false
			O1 = new Sprite()
			O2 = new Sprite()
			layer1.addChild(O1)
			layer1.addChild(O2)
			O1.addEventListener(MouseEvent.CLICK, click)
			O2.addEventListener(MouseEvent.CLICK, click)
			// init button positions
			Opos = new Vector.<Number>(4)
			Opos[0] = 20; Opos[1] = 430; Opos[2] = 140; Opos[3] = 430; 
			// draw button
			drawButton()
			
			// effect init
			D = new BitmapData(w,h,true,0xFFFFFF)
			B = new Bitmap(D, "auto", true)
			RECT = D.rect
			COL = new ColorTransform(1,1,1,.9)
			layer0.addChild(B)
			
			// draw background Sprite
			back = new Sprite()
			g = back.graphics
			//g.beginFill(0x0)
			g.drawRect(0,0,w,h)
			g.endFill()
			g.beginFill(0x0)
			g.drawCircle(cx, cy, 10)
			g.endFill()
			// init background Bitmap/Data
			backD = new BitmapData(w, h, true, 0xFFFFFF)
			backB = new Bitmap(backD, "auto", true)
			backD.draw(back)
			g.clear()
			// re-draw background Sprite and init texts
			t = new TextField()
			f = new TextFormat("Verdana", 18)
			t.defaultTextFormat = f
			t.autoSize = TextFieldAutoSize.LEFT
			back.addChild(t)
			// create textsField's text
			t.text = "normal" // = perpendicular = taproot = apeak
			t.x = Opos[0] + 20
			t.y = Opos[1] + 10
			backD.draw(back)
			// another text
			t.text = "circular"
			t.x = Opos[2] + 20
			t.y = Opos[3] + 10
			backD.draw(back)
			// clean
			back.removeChild(t)
			f = null
			t = null
			// add the Bitmap background (with BitmapData background) to the Sprite background
			back.addChild(backB)
			layer0.addChild(back)
			// simplify
			back.doubleClickEnabled = false
			back.cacheAsBitmap = true
			
			// - - - - - - - - - - - - - - - - //
			
			// init objetos
			objetos = new Vector.<Objeto>()
			
			// Listeners
			back.addEventListener(MouseEvent.MOUSE_DOWN, Down) // create an object
			stage.addEventListener(MouseEvent.MOUSE_UP, Up) // release an object
			//
			stage.addEventListener(Event.ENTER_FRAME, ef) // update (each frame)
			
			
			
		}
		
		// - - - - - - - - - - - - - - - - //
		
		// draw button graphics
		private function drawButton():void
		{
			// draw first button
			g = O1.graphics
			g.clear()
			g.lineStyle(1, 0, 1, true)
			if (o1)
			{
				g.beginFill(0x00FF00)
			} else 
			{
				g.beginFill(0x00FF00, 0)
			}
			g.drawRoundRect(Opos[0], Opos[1], 20, 20, 2, 2)
			g.endFill()
			
			// draw second button
			g = O2.graphics
			g.clear()
			g.lineStyle(1, 0, 1, true)
			if (o2)
			{
				g.beginFill(0x00FF00)
			} else 
			{
				g.beginFill(0x00FF00, 0)
			}
			g.drawRoundRect(Opos[2], Opos[3], 20, 20, 2, 2)
			g.endFill()
		}
		
		// event click, from options buttons
		private function click(e:MouseEvent):void
		{
			o1 = o2 = !o1
			drawButton()
			
			// commented, its not ready yet :/
			/*s = e.target as Sprite
			if (s == O1)
			{
				// change option value, and redraw all buttons
				o1 = !o1
				drawButton()
			} else 
			{
				// change option value, and redraw all buttons
				o2 = !o2
				drawButton()
			}*/
		}
		
		
		// - - - - - - - - - - - - - - - - //
		
		// Listener for create an new Object
		private function Down(e:MouseEvent):void
		{
			down = true
			stage.addEventListener(MouseEvent.MOUSE_MOVE, Move) // change object proprieties
			
			// crate an Objeto
			obj = new Objeto()
			objetos.push(obj)
			layer2.addChild(obj)
			// init objt proprieties
			obj.X = mouseX
			obj.Y = mouseY
			obj.dx = cx - obj.X
			obj.dy = cy - obj.Y
			obj.d = Math.sqrt(obj.dx * obj.dx + obj.dy * obj.dy)
			
			if (o1 && o2)
			{
				obj.v = Math.sqrt(G * M / obj.d)
				obj.vx = -obj.v * obj.dy / obj.d
				obj.vy = obj.v * obj.dx / obj.d
				
			} else if(o1)
			{
				obj.v = 0
				obj.vx = -obj.v * obj.dy / obj.d
				obj.vy = obj.v * obj.dx / obj.d
			} else if (o2)
			{
				obj.v = Math.sqrt(G * M / obj.d)
				obj.vx = obj.v * obj.dx / obj.d
				obj.vy = obj.v * obj.dy / obj.d
			} else
			{
				obj.v = 0
				obj.vx = 0
				obj.vy = 0
			}
			
			// draw object body
			obj.corpse()
			obj.velocity(obj.X + obj.vx*10, obj.Y + obj.vy*10)
			
		}
		
		private function Move(e:MouseEvent):void
		{
			move = true
			obj = objetos[objetos.length - 1]
			
			if (o1 && o2)
			{
				
				/*
				obj.v = Math.sqrt(G * M / obj.d)
				obj.vx = -obj.v * obj.dy / obj.d
				obj.vy = obj.v * obj.dx / obj.d
				*/
				
				obj.velocity(obj.X + obj.vx*10, obj.Y + obj.vy*10)
				
			} else if(o1)
			{
				/*
				obj.v = 0
				obj.vx = -obj.v * obj.dy / obj.d
				obj.vy = obj.v * obj.dx / obj.d
				*/
			} else if (o2)
			{
				/*
				obj.v = Math.sqrt(G * M / obj.d)
				obj.vx = obj.v * obj.dx / obj.d
				obj.vy = obj.v * obj.dy / obj.d
				*/
			} else
			{
				X = obj.X - mouseX
				Y = obj.Y - mouseY
				
				obj.vx = -X * .1
				obj.vy = -Y * .1
				
				obj.velocity(mouseX,mouseY)
			}
			
		}
		
		private function Up(e:MouseEvent):void
		{
			up = true
			if (down)
			{
				down = false
				++length
				stage.removeEventListener(MouseEvent.MOUSE_MOVE, Move) // change object proprieties
			}
			
		}
		
		// - - - - - - - - - - - - - - - - //
		
		private function ef(e:Event):void
		{
			i = 0
			while (i < length)
			{
				obj = objetos[i]
				//
				obj.X += obj.vx
				obj.Y += obj.vy
				
				
				obj.dx = cx - obj.X
				obj.dy = cy - obj.Y
				obj.d = Math.sqrt(obj.dx * obj.dx + obj.dy * obj.dy)
				obj.v = G*M/(obj.d*obj.d)
				obj.vx += obj.v * obj.dx / obj.d
				obj.vy += obj.v * obj.dy / obj.d
				// draw object body
				obj.corpse()
				
				
				++i
			}
			
			//
			D.draw(layer2)
			D.colorTransform(RECT, COL)
			
			
		}
		
		
	}
	
}



//


//package  
//{
	import flash.display.Graphics;
	import flash.display.Sprite;
	/**
	 * ...
	 * @author Thi
	 */
	/*public*/ class Objeto extends Sprite
	{
		// proprieties
		public var X:Number, Y:Number
		public var dx:Number, dy:Number, d:Number
		public var vx:Number, vy:Number, v:Number
		
		// temp graphic
		private var g:Graphics
		
		// draws in this Object
		public var C:Sprite // corpse
		public var V:Sprite // velocity graphic
		
		
		
		
		public function Objeto() 
		{
			C = new Sprite()
			V = new Sprite()
			this.addChild(V)
			this.addChild(C)
			//
			g = C.graphics
			g.clear()
			g.beginFill(uint((Math.random()*0xFF)<<16 | (Math.random()*0xFF)<<8 | Math.random()*0xFF))
			g.drawCircle(0, 0, 2)
			g.endFill()
			// simplify
			C.doubleClickEnabled = false
			C.cacheAsBitmap = true
			//
		}
		
		public function corpse():void
		{
			C.x = X
			C.y = Y
			//
			V.graphics.clear()
		}
		
		public function velocity(dx:Number, dy:Number):void
		{
			g = V.graphics
			g.clear()
			g.lineStyle(1, 0xFF0000)
			g.moveTo(X, Y)
			g.lineTo(dx,dy)
		}
		
	}

//}
