/**
 * Copyright heart_thai ( http://wonderfl.net/user/heart_thai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/veQt
 */

package 
{
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	/**
	 * ...
	 * @author heart
	 */
	[SWF(width = "550", height = "400", frameRate = "30", backgroundColor = "#000000")]
	
	public class Main extends Sprite 
	{
		private var viewport:BitmapData;
		private var particleList:Array;
		private var cTran:ColorTransform;
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			viewport = new BitmapData(stage.stageWidth , stage.stageHeight , false , 0);
			var canvas:Bitmap = new Bitmap(viewport);
			addChild(canvas);
			particleList = new Array();
			cTran = new ColorTransform(.9, .8, .8, 1.0)
			for (var i:Number = 0 ; i <= 100 ; i++ ) {
				particleList.push(new Particle());
			}
			this.addEventListener(Event.ENTER_FRAME , update );
		}
		private function update(e:Event):void {
			for (var i:Number = 0 ; i <=100 ; i++ ) {
				var p:Particle = particleList[i] as Particle;
				p.update();
			}
			render();
		}
		private function render():void {
			viewport.applyFilter(viewport , new Rectangle(0, 0, viewport.width , viewport.height), new Point(), new BlurFilter(3, 3));
			viewport.scroll(5, 0);
			for (var i:Number = 0 ; i <= 100 ; i++ ) {
				var p:Particle = particleList[i] as Particle;
				var pt:Point = p.getPoint(stage.stageWidth / 2 , stage.stageHeight / 2);
				var color:Number = 0xFFFFFF;
				//var color:Number = p.color
				viewport.setPixel(pt.x , pt.y , color);
				
				viewport.setPixel(pt.x-1 , pt.y-1 , color);
				viewport.setPixel(pt.x , pt.y-1 , color);
				viewport.setPixel(pt.x+1 , pt.y-1 , color);
				viewport.setPixel(pt.x-1 , pt.y , color);
				viewport.setPixel(pt.x+1 , pt.y , color);
				viewport.setPixel(pt.x-1 , pt.y+1 , color);
				viewport.setPixel(pt.x , pt.y+1 , color);
				viewport.setPixel(pt.x+1 , pt.y+1 , color);
			}
		}
	}
	
}


import flash.geom.Point;

class Particle 
	{
		private var angle:Number;
		private var radius:Number;
		private var v:Number;
		private var s:Number;
		
		private var dir:String;
		private var max:Number;
		public var color:Number;
		public function Particle() 
		{
			 angle = Math.random() * Math.PI * 2;
			 radius = 0;
			 s = 0;
			 v = Math.random();
			 dir = (Math.random() < 0.5) ? "back" : "go";
			 max = Math.random() * 10;
			 color = Math.random() * 0xFFFFFF;
		}
		public function update():void {
			if (dir == "go") {
				s += v;
				s = (s > 10)? 10 :s;
				if (radius > max) {
					dir = "back";
				}
			}else if (dir == "back") {
				s -= v;
				s = (s < -10)? -10 :s;
				if (radius < max) {
					dir = "go";
				}
			}
			
			radius += s;
		}
		public function getPoint(mx:Number,my:Number ):Point {
			var x:Number = mx+radius * Math.cos(angle);
			var y:Number = my+radius * Math.sin(angle);
			return new Point(x, y);
		}
		
	}