/**
 * Copyright Sjeiti ( http://wonderfl.net/user/Sjeiti )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/veQX
 */

package {
 
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldType;	
	import flash.events.MouseEvent;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
 
	public class ResizableTextField extends Sprite {
 
		private var textCustomField:TextField;
 
		//handles
		private var square1:Sprite;
		private var square2:Sprite;
		private var square3:Sprite;
		private var square4:Sprite;
 
		//dragging
		private var origX:int;
		private var origY:int;
		private var dragTimer:Timer = new Timer(10,10000);
		private var handleHolder:Object;
 
		// Initialization:
		public function ResizableTextField()
		{
			textCustomField = new TextField();
			textCustomField.type = TextFieldType.INPUT;
			textCustomField.multiline = !true;
			textCustomField.wordWrap = !true;
			textCustomField.width=200;
			textCustomField.height=100;
			textCustomField.x=50;
			textCustomField.y=50;
			textCustomField.text="type here";
			textCustomField.border=true;
			createHandles();
			this.addChild(textCustomField);
		}
 
		//create 4 draggable handles
		private function createHandles():void
		{
 
			square1 = new Sprite();
			square1.graphics.lineStyle(1,0x000000);
			square1.graphics.beginFill(0xFFFFFF);
			square1.graphics.drawRect(0,0,10,10);
			square1.graphics.endFill();
 
			square2 = new Sprite();
			square2.graphics.lineStyle(1,0x000000);
			square2.graphics.beginFill(0xFFFFFF);
			square2.graphics.drawRect(0,0,10,10);
			square2.graphics.endFill();
 
			square3 = new Sprite();
			square3.graphics.lineStyle(1,0x000000);
			square3.graphics.beginFill(0xFFFFFF);
			square3.graphics.drawRect(0,0,10,10);
			square3.graphics.endFill();
 
			square4 = new Sprite();
			square4.graphics.lineStyle(1,0x000000);
			square4.graphics.beginFill(0xFFFFFF);
			square4.graphics.drawRect(0,0,10,10);
			square4.graphics.endFill();
 
			updateHandlePositions();
 
			this.addChild(square1);
			square1.buttonMode=true;
			this.addEventListener(MouseEvent.MOUSE_OUT,hideHandles);
			square1.addEventListener(MouseEvent.MOUSE_DOWN,startHandleDrag);
 
			this.addChild(square2);
			square2.buttonMode=true;
			this.addEventListener(MouseEvent.MOUSE_OUT,hideHandles);
			square2.addEventListener(MouseEvent.MOUSE_DOWN,startHandleDrag);
 
			this.addChild(square3);
			square3.buttonMode=true;
			this.addEventListener(MouseEvent.MOUSE_OUT,hideHandles);
			square3.addEventListener(MouseEvent.MOUSE_DOWN,startHandleDrag);
 
			this.addChild(square4);
			square4.buttonMode=true;
			this.addEventListener(MouseEvent.MOUSE_OUT,hideHandles);
			square4.addEventListener(MouseEvent.MOUSE_DOWN,startHandleDrag);
		}
 
		private function hideHandles(e:MouseEvent):void
		{
			square1.alpha=0;
			square2.alpha=0;
			square3.alpha=0;
			square4.alpha=0;
			this.textCustomField.border=false;
			this.addEventListener(MouseEvent.MOUSE_OVER,showHandles);
		}
 
		private function showHandles(e:MouseEvent):void
		{
			square1.alpha=1;
			square2.alpha=1;
			square3.alpha=1;
			square4.alpha=1;
			this.textCustomField.border=true;
		}
 
		private function startHandleDrag(e:MouseEvent):void
		{
			handleHolder=e.target;
			origX=mouseX;
			origY=mouseY;
			dragTimer.addEventListener(TimerEvent.TIMER, resizeField);
            dragTimer.start();
		}
 
		private function stopHandleDrag(e:MouseEvent):void
		{
			removeEventListener(MouseEvent.MOUSE_UP,stopHandleDrag);
			dragTimer.stop();
			dragTimer.reset();
		}
		// resize text field depending on which direction dragging
		private function resizeField(e:TimerEvent):void
		{
			addEventListener(MouseEvent.MOUSE_UP,stopHandleDrag);
			var updatedX:int = mouseX-origX;
			var updatedY:int = mouseY-origY;
			if(handleHolder===square1)
			{
				this.textCustomField.width-=updatedX;
				this.textCustomField.height-=updatedY;
				this.textCustomField.x+=updatedX;
				this.textCustomField.y+=updatedY;
			}
			else if(handleHolder===square2)
			{
				this.textCustomField.width+=updatedX;
				this.textCustomField.height-=updatedY;
				this.textCustomField.y+=updatedY;
			}
			else if(handleHolder===square3)
			{
				this.textCustomField.width-=updatedX;
				this.textCustomField.height+=updatedY;
				this.textCustomField.x+=updatedX;
			}
			else if(handleHolder===square4)
			{
				this.textCustomField.width+=updatedX;
				this.textCustomField.height+=updatedY;
			}
 
			origX=mouseX;
			origY=mouseY;
			updateHandlePositions();
			e.updateAfterEvent();
		}
		//adjust handles to the new size/position
		private function updateHandlePositions():void
		{
			square1.x=textCustomField.x-square1.width;
			square1.y=textCustomField.y-square1.height;
			square2.x=textCustomField.x+textCustomField.width;
			square2.y=textCustomField.y-square2.width;
			square3.x=textCustomField.x-square3.height;
			square3.y=textCustomField.height+textCustomField.y;
			square4.x=textCustomField.x+textCustomField.width;
			square4.y=textCustomField.height+textCustomField.y;
		}
	}
 
}