/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/veHU
 */

// 2012-04-23 11:57:03
package
{
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.filters.DropShadowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.ui.Keyboard;
    
    [SWF(backgroundColor="#ffffff", frameRate="60")]
    
    public class FontTest extends Sprite
    {
        private var font:HGEFont;
        private var font1_fnt:String = '[HGEFONT]\n\nBitmap=font1.png\n\nChar=" ",0,0,8,27,0,0\nChar="!",8,0,5,27,0,0\nChar=""",13,0,9,27,0,0\nChar="#",22,0,13,27,0,0\nChar="$",35,0,13,27,0,0\nChar="%",48,0,14,27,0,0\nChar="&",62,0,19,27,0,0\nChar="\'",81,0,5,27,0,0\nChar="(",86,0,6,27,0,0\nChar=")",92,0,6,27,0,0\nChar="*",98,0,13,27,0,0\nChar="+",111,0,14,27,0,0\nChar=",",125,0,6,27,0,0\nChar="-",131,0,13,27,0,0\nChar=".",144,0,5,27,0,0\nChar="/",149,0,14,27,0,0\nChar="0",163,0,13,27,0,0\nChar="1",176,0,13,27,0,0\nChar="2",189,0,14,27,0,0\nChar="3",203,0,14,27,0,0\nChar="4",217,0,14,27,0,0\nChar="5",231,0,14,27,0,0\nChar="6",0,27,14,27,0,0\nChar="7",14,27,13,27,0,0\nChar="8",27,27,13,27,0,0\nChar="9",40,27,14,27,0,0\nChar=":",54,27,5,27,0,0\nChar=";",59,27,6,27,0,0\nChar="<",65,27,6,27,0,0\nChar="=",71,27,12,27,0,0\nChar=">",83,27,6,27,0,0\nChar="?",89,27,13,27,0,0\nChar="@",102,27,17,27,0,0\nChar="A",119,27,13,27,0,0\nChar="B",132,27,13,27,0,0\nChar="C",145,27,14,27,0,0\nChar="D",159,27,14,27,0,0\nChar="E",173,27,14,27,0,0\nChar="F",187,27,14,27,0,0\nChar="G",201,27,14,27,0,0\nChar="H",215,27,14,27,0,0\nChar="I",229,27,9,27,0,0\nChar="J",238,27,14,27,0,0\nChar="K",0,54,14,27,0,0\nChar="L",14,54,13,27,0,0\nChar="M",27,54,13,27,0,0\nChar="N",40,54,13,27,0,0\nChar="O",53,54,14,27,0,0\nChar="P",67,54,14,27,0,0\nChar="Q",81,54,14,27,0,0\nChar="R",95,54,14,27,0,0\nChar="S",109,54,14,27,0,0\nChar="T",123,54,14,27,0,0\nChar="U",137,54,13,27,0,0\nChar="V",150,54,13,27,0,0\nChar="W",163,54,18,27,0,0\nChar="X",181,54,14,27,0,0\nChar="Y",195,54,14,27,0,0\nChar="Z",209,54,14,27,0,0\nChar="[",223,54,6,27,0,0\nChar="\",229,54,14,27,0,0\nChar="]",243,54,7,27,0,0\nChar="^",0,81,13,27,0,0\nChar="_",13,81,16,27,0,0\nChar="`",29,81,7,27,0,0\nChar="a",36,81,14,27,0,0\nChar="b",50,81,14,27,0,0\nChar="c",64,81,14,27,0,0\nChar="d",78,81,14,27,0,0\nChar="e",92,81,14,27,0,0\nChar="f",106,81,6,27,0,0\nChar="g",112,81,13,27,0,0\nChar="h",125,81,14,27,0,0\nChar="i",139,81,7,27,0,0\nChar="j",146,81,6,27,0,0\nChar="k",152,81,14,27,0,0\nChar="l",166,81,7,27,0,0\nChar="m",173,81,19,27,0,0\nChar="n",192,81,13,27,0,0\nChar="o",205,81,14,27,0,0\nChar="p",219,81,14,27,0,0\nChar="q",233,81,14,27,0,0\nChar="r",0,108,11,27,0,0\nChar="s",11,108,14,27,0,0\nChar="t",25,108,7,27,0,0\nChar="u",32,108,13,27,0,0\nChar="v",45,108,13,27,0,0\nChar="w",58,108,19,27,0,0\nChar="x",77,108,14,27,0,0\nChar="y",91,108,14,27,0,0\nChar="z",105,108,14,27,0,0\nChar="{",119,108,9,27,0,0\nChar="|",128,108,4,27,0,0\nChar="}",132,108,9,27,0,0\nChar="~",141,108,13,27,0,0\n';
        private var items:Array = [];
        private var currentIndex:int = -1;
        private var f0:Array = [new DropShadowFilter(4, 30, 0x0, 0.25, 1, 1, 1)];
        private var f1:Array = [new DropShadowFilter(12, 30, 0x0, 0.25, 1, 1, 1)];
        private var c0:ColorTransform = new ColorTransform(0,0,0,1.0,0xff,0xe0,0x60,0);
        private var c1:ColorTransform = new ColorTransform(0,0,0,1.0,0xff,0xff,0xff,0);
        private var bg:BitmapData;
        private var bgMatrix:Matrix = new Matrix();
        
        public function FontTest()
        {
            loadFont();
            loadImage();
        }
        
        private function loadFont():void 
        {
            font = new HGEFont();
            font.addEventListener(Event.INIT, onFontInit);
            //font.load("font1.fnt");
            
            font1_fnt = font1_fnt.replace("font1.png", "http://assets.wonderfl.net/images/related_images/4/42/428b/428bf97545c6dcb165ad21ba969c2acf5f06d553");
            font.loadFromText(font1_fnt);
        }
        
        private function loadImage():void
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/de/de81/de81d0bac4ff29eb0b76e4eb0fe5c6429f1f8387"), new LoaderContext(true));
        }
        
        private function initMenu():void
        {
            items = [
                new Bitmap( font.createText("Play") ),
                new Bitmap( font.createText("Option") ),
                new Bitmap( font.createText("Instructions") ),
                new Bitmap( font.createText("Credits") ),
                new Bitmap( font.createText("Exit") )
            ];
            
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            for(var i:int=0, num:int=items.length; i < num; ++i) {
                var item:Bitmap = items[i];
                var lineHeight:int = item.height * 1.5;
                item.x = w - item.width >> 1;
                item.y = (h - num * lineHeight >> 1) + i* lineHeight;
                item.bitmapData.colorTransform(item.bitmapData.rect, c0);
                item.filters = f0;
                this.addChild(item);
            }
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            
            select(0);
        }
        
        private function select(index:int):void
        {
            var item:Bitmap = items[currentIndex];
            if(item) {
                item.bitmapData.colorTransform(item.bitmapData.rect, c0);
                item.filters = f0;
                item.x += 4;
                item.y += 4;
            }
            
            item = items[index];
            if(item) {
                item.bitmapData.colorTransform(item.bitmapData.rect, c1);
                item.filters = f1;
                item.x -= 4;
                item.y -= 4;
                this.currentIndex = index;
            }
        }
        
        private function initBackground(texture:BitmapData):void
        {
            this.bg = texture;
            
            stage.addEventListener(Event.ENTER_FRAME, onFrameLoop);
        }
        
        //---Event Handlers
        
        private function onFontInit(e:Event):void
        {
            font.removeEventListener(Event.INIT, onFontInit);
            
            initMenu();
        }
        
        private function onImageLoaded(event:Event):void
        {
            var info:LoaderInfo = event.currentTarget as LoaderInfo;
            info.removeEventListener(Event.COMPLETE, onImageLoaded);
            
            var bmp:Bitmap = info.content as Bitmap;
            if(bmp) initBackground(bmp.bitmapData);
        }
        
        private function onFrameLoop(event:Event):void
        {
            bgMatrix.ty -= 1;
            bgMatrix.tx += 0.25;
            
            if(Math.abs(bgMatrix.tx) >= bg.width) bgMatrix.tx = 0;
            if(Math.abs(bgMatrix.ty) >= bg.height) bgMatrix.ty = 0;
            
            this.graphics.clear();
            this.graphics.beginBitmapFill(bg, bgMatrix);
            this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
        }
        
        private function onKeyDown(event:KeyboardEvent):void
        {
            var i:int;
            switch(event.keyCode) {
                case Keyboard.UP:
                    i = currentIndex - 1;
                    if(i < 0) i = items.length-1;
                    select(i);
                    break;
                
                case Keyboard.DOWN:
                    i = currentIndex + 1;
                    if(i > items.length-1) i = 0;
                    select(i);
                    break;
            }
        }
    }
}

import flash.system.LoaderContext;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.IOErrorEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;

class HGEFont extends EventDispatcher
{
    private var _loader:URLLoader;
    private var _charHash:Object = {};
    private var _rectangles:Array = [];
    private var _imageURL:String;
    
    private var _map:Object = {};
    private var _spacing:int = 8;
    
    
    public function HGEFont()
    {
        _loader = new URLLoader();
        _loader.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
        _loader.addEventListener(Event.COMPLETE, onFileLoadComplete);
    }
    
    public function load(url:String):void
    {
        _loader.dataFormat = URLLoaderDataFormat.TEXT;
        _loader.load(new URLRequest(url));
    }
    
    public function loadFromText(fnt:String):void
    {
        parse(fnt);
    }
    
    public function createText(str:String, useHex:Boolean=false):BitmapData
    {
        var clip:BitmapData;
        var maxWidth:int;
        var maxHeight:int;
        var a:Array;
        var i:int;
        var len:int;
        
        if(useHex) {
            a = str.split(' ');
        }
        else {
            len = str.length;
            a = [];
            for(i=0; i<len; ++i) a[a.length] = str.charAt(i);
        }
        
        //calculate maxWidth
        len = a.length;
        
        for(i = 0; i < len; ++i)
        {
            clip = _map[ a[i] ] as BitmapData;
            if(clip) {
                maxWidth += clip.width;
                if(maxHeight < clip.height) maxHeight = clip.height;
            }
            else {
                maxWidth += _spacing;
            }
        }
        
        //merge
        var bd:BitmapData = new BitmapData(maxWidth, maxHeight, true, 0x00000000);
        var pt:Point = new Point(0, 0);
        
        for(i = 0; i < len; ++i)
        {
            clip = _map[ a[i] ] as BitmapData;
            if(clip) {
                bd.copyPixels(clip, clip.rect, pt);
                pt.x += clip.width;
            }
            else {
                pt.x += _spacing;
            }
        }
        
        return bd;
    }
    
    private function parse(data:String):void
    {
        //clear array
        _rectangles.length = 0;
        
        //image URL
        var imageURL:String;
        
        data = data.replace(/\s\n/g, '\n');
        var lines:Array = data.split('\n');
        var num:int = lines.length;
        for(var i:int = 0; i<num; ++i)
        {    
            var line:String = lines[i];
            
            var key:String = line.substring(0, line.indexOf('='));
            key = key.toLowerCase();
            
            //if(key == '')
            
            if(key == "char") {                
                var value:String = line.substr( line.indexOf('=') + 1 );
                
                //character itself or it's hexadecimal code
                var char:String;
                var a:Array;
                if(value.indexOf('"') == 0) {
                    char = value.substring( 1, value.lastIndexOf('"') );
                    a = value.substr( value.lastIndexOf('"') + 2 ).split(',');
                }
                else {
                    char = value.substring( 0, value.indexOf(',') );
                    a = value.substr( value.indexOf(',') + 1 ).split(',');
                }
                
                //the character placing on the font bitmap (x, y, w, h)
                _charHash[char] = _rectangles.length;
                _rectangles.push( new Rectangle(a[0], a[1], a[2], a[3]) );
                //trace(char, new Rectangle(a[0], a[1], a[2], a[3]));
                
                //TODO: horizontal position offsets
            }
            else if(key == "bitmap") {
                imageURL = line.substr(line.indexOf('=') + 1);
            }
        }
        
        //next step
        loadImage(imageURL);
    }
    
    private function loadImage(url:String):void
    {
        var imageLoader:Loader = new Loader();
        imageLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
        imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoadComplete);
        imageLoader.load(new URLRequest(url), new LoaderContext(true));
    }
    
    private function createFont(source:BitmapData):void
    {
        var list:Array = cutFontBitmap(source, _rectangles);
        
        for(var char:String in _charHash)
        {
            var i:int = _charHash[char];
            var clip:BitmapData = list[i];
            
            _map[char] = clip;
        }
        
        //load and parse complete.
        this.dispatchEvent(new Event(Event.INIT));
    }
    
    private function cutFontBitmap(source:BitmapData, rectangles:Array):Array
    {
        var list:Array = [];
        
        var rect:Rectangle;
        var pt:Point = new Point(0, 0);
        var clip:BitmapData;
        
        var num:int = rectangles.length;
        for(var i:int = 0; i < num; ++i)
        {
            rect = rectangles[i];
            
            clip = new BitmapData(rect.width, rect.height, true, 0x00000000);
            clip.copyPixels(source, rect, pt);
            
            list[list.length] = clip;
        }
        return list;
    }
    
    //---EVENT HANDLERS
    
    private function onFileLoadComplete(e:Event):void
    {
        parse( _loader.data );
    }
    
    private function onImageLoadComplete(e:Event):void
    {
        var bmp:Bitmap = e.currentTarget.content as Bitmap;
        if(bmp) {
            createFont( bmp.bitmapData );
            //bmp.bitmapData.dispose();
        }
    }
    
    private function onIOError(e:IOErrorEvent):void
    {
        trace(e.text);
    }
}