/**
 * Copyright hiro_loveness1 ( http://wonderfl.net/user/hiro_loveness1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vdTX
 */

// forked from nulldesign's Fractals
/*
    JActionScriptersにあてられて昼休みにフラクタルしてみる。
    昼休みフラクタル。
    http://nulldesign.jp/blog/

    
*/
package{

    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")];
    
    public class Fractals extends Sprite
    {
        
        private var w:Number;
        private var h:Number;
        private var g:Graphics = graphics;
        private var _fractalData:Array = new Array();
        private var _minSize:Number = 8;
        private var _reDrawPar:Number = .2;
        private var now:uint = getTimer();
        private var then:uint = now;

        public function Fractals()
        {
            addEventListener( Event.ADDED_TO_STAGE, initialize );
        }

        private function initialize( e:Event ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, initialize );

            //ステージの設定
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.HIGH;
            stage.frameRate = 60;
            
            //ステージの幅と高さを取得しとく
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            //最初の行が領域を設定
            var _data:Data = new Data( 0, 0, w, h );
            _fractalData.push( _data );
            
            //描画開始
            addEventListener( Event.ENTER_FRAME, loop );
            
            //リセット用
            stage.addEventListener(MouseEvent.MOUSE_DOWN, reset );
            
        }
        
        private function reset( e:MouseEvent ):void
        {
            
            g.clear();
            _fractalData= [];
            
            //最初の行が領域を設定
            var _data:Data = new Data( 0, 0, w, h );
            _fractalData.push( _data );
            
            //描画開始
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop( e:Event ):void
        {
            //リストからデータの引き出し
            now = getTimer();
            for( var i:uint = 0; i < now - then; i++ ){
                var dat:Data = _fractalData.pop();
                if( dat != null ){
                    var _x:Number = dat.a;
                    var _y:Number = dat.b;
                    var _w:Number = dat.c;
                    var _h:Number = dat.d;
                    //ビット演算だとずれちゃうので普通に半分
                    var __w:Number = _w *.5;
                    var __h:Number = _h *.5;
                    //draw( _x, _y, _w, _h );
                    
                     //幅もしくは高さが10以上あればふらくたるする
                    if( _w > _minSize  || _h > _minSize ){
                        
                        //ステージサイズの半分以上なら描画、もしくは4つにひとつくらいは描画を停止するようにしてます
                        if(  _w > w >> 1 || Math.random() > _reDrawPar ){
                            _fractalData.push( new Data( _x, _y, __w, __h ) );
                            _fractalData.push( new Data( _x + __w, _y,  __w, __h ) );
                            _fractalData.push( new Data( _x, _y + __h, __w, __h ) );
                            _fractalData.push( new Data( _x + __w, _y + __h, __w, __h ) );
                        } else {
                            draw( _x, _y, _w, _h );
                        }
                    } else {
                        draw( _x, _y, _w, _h );
                    }
                     
                } else {
                    //描画するデータがなくなったら終了
                    removeEventListener( Event.ENTER_FRAME, loop );
                    break;
                }
            }
            then = now;
        }
        
        private function draw( _x:Number, _y:Number, _w:Number, _h:Number ):void
        {
            //g.beginFill( 0x000000, .1 );
            g.lineStyle( 1, 0x000000, 1, false, "none" );
            g.drawRect( _x, _y, _w, _h );
            g.moveTo( _x, _y );
            g.lineTo( _x+_w, _y+_h );
            g.moveTo( _x, _y+_h );
            g.lineTo( _x+_w, _y );
            g.endFill();
        }

    }
}

class Data{
    public var a:Number;
    public var b:Number;
    public var c:Number;
    public var d:Number;
    
    public function Data( a:Number, b:Number, c:Number, d:Number )
    {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }
}