/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vdQq
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class ArcDraw extends Sprite {
        public var center:Point;
        public var rad:Number;
        public var angle:Number; 
        
        public function ArcDraw() {
            center = new Point(465 / 2, 465 / 2);
            rad = Math.random() * 45 + 5;
            angle = 0;
            
            this.graphics.lineStyle(1, 0, 1);
            this.graphics.moveTo(Math.cos(angle * Math.PI / 180) * rad + center.x, Math.sin(angle * Math.PI / 180) * rad + center.y);
            
            this.addEventListener(Event.ENTER_FRAME, draw);
        }
        
        private function draw(e:Event):void {
            this.graphics.lineTo(Math.cos(angle * Math.PI / 180) * rad + center.x, Math.sin(angle * Math.PI / 180) * rad + center.y);
            
            angle += 10;
            
            if (Math.floor(Math.random() * 10) == 0) {
                var rrad:Number = Math.random() * 45 + 5;;
                if (Math.random() < 0.5) {
                    if (rrad > rad) {
                        center = new Point(Math.cos((angle - 180) * Math.PI / 180) * (rrad - rad) + center.x, Math.sin((angle - 180) * Math.PI / 180) * (rrad - rad) + center.y);
                    } else {
                        center = new Point(Math.cos(angle * Math.PI / 180) * (rad - rrad) + center.x, Math.sin(angle * Math.PI / 180) * (rad - rrad) + center.y);
                    }
                    
                    rad = rrad;
                } else {
                    center = new Point(Math.cos(angle * Math.PI / 180) * (rad + rrad) + center.x, Math.sin(angle * Math.PI / 180) * (rad + rrad) + center.y);
                    
                    angle -= 180;
                    
                    rad = rrad;
                }
            }
        }
    }
}