/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vdNL
 */

package  {
	
	/**
	 * 仕事でどう使ったか思い出しながら復習。
	 * 
	 * 参考
	 * 
	 * Box2D v2.0.2 User Manual
	 * http://www.box2d.org/manual.html
	 * 
	 * ずっと君のターン - Box2Dユーザマニュアル
	 * http://d.hatena.ne.jp/technohippy/20080203#1202009227
	 * 
	 * Box2D test
	 * http://wonderfl.kayac.com/code/293aab35ed23c7658f556dfbcea4dc69c40cd5d8
	 */
	
	import Box2D.Collision.b2AABB;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import Box2D.Dynamics.b2BodyDef;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Dynamics.b2World;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#ffffff")]
	
	/**
	 * 
	 */
	public class Main extends Sprite {
		
		// 1m を何 pixel にするか
		private const drawScale:Number = 100;
		
		private const iterations:int = 1;
		
		/**
		 * ワールド
		 */
		private var world:b2World;
		
		/**
		 * コンストラクタ
		 */
		public function Main():void {
			
			/** --------------------------------------------------
			* World の設定
			*/
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set( -stage.stageWidth / 2, -stage.stageHeight / 2 );
			worldAABB.upperBound.Set( stage.stageWidth / 2, stage.stageHeight / 2 );
			
			var gravity:b2Vec2 = new b2Vec2( 0, 10 );
			var doSleep:Boolean = true;
			
			world = new b2World( worldAABB, gravity, doSleep );
			
			
			
			/** --------------------------------------------------
			 * 地面の作成
			 */
			
			var groundBodyDef:b2BodyDef = new b2BodyDef();
			groundBodyDef.position.Set( pixelToMeter( stage.stageWidth / 2 ), pixelToMeter( stage.stageHeight - 100 ) );
			
			var groundBody:b2Body = world.CreateBody( groundBodyDef );
			
			var groundShapeDef:b2PolygonDef = new b2PolygonDef();
			groundShapeDef.SetAsBox( pixelToMeter( stage.stageWidth / 4 ), pixelToMeter( 1 ) );
			
			groundBody.CreateShape( groundShapeDef );
			
			
			
			/** --------------------------------------------------
			 * 箱の作成
			 */
			var bodyDef:b2BodyDef = new b2BodyDef();
			bodyDef.position.Set( pixelToMeter( stage.stageWidth / 2 ), pixelToMeter( 100 ) );
			var body:b2Body = world.CreateBody( bodyDef );
			
			var shapeDef:b2PolygonDef= new b2PolygonDef();
			shapeDef.SetAsBox( pixelToMeter( 100 / 2 ), pixelToMeter( 100 / 2 ) );
			shapeDef.density = 1;       // 密度
			shapeDef.friction = 0.3;    // 摩擦係数
			shapeDef.restitution = 0.4; // 反発係数
			
			body.CreateShape( shapeDef );
			body.SetMassFromShapes();
			
			
			
			/** --------------------------------------------------
			 * デバッグ描画設定
			 */
			var dbgDraw:b2DebugDraw = new b2DebugDraw();
			dbgDraw.m_sprite = this;
			dbgDraw.m_drawScale = drawScale;
			dbgDraw.m_fillAlpha = 0.3;
			dbgDraw.m_lineThickness = 1.0;
			dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit;
			world.SetDebugDraw( dbgDraw );
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			world.Step( 1 / stage.frameRate, iterations );
		}
		
		/**
		 * 
		 * @param	meter
		 * @return
		 */
		private function meterToPixcel( meter:Number ):Number {
			
			return meter * drawScale;
		}
		
		/**
		 * 
		 * @param	meter
		 * @return
		 */
		private function pixelToMeter( pixel:Number ):Number {
			
			return pixel / drawScale;
		}
	}
}