/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vdAN
 */

package {
    //----------------------------------------------
    //AlertクラスTEST
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageScaleMode; 
    import flash.display.StageAlign;
    import flash.text.TextFieldAutoSize;
    //import cls.*;

    public class  testAlert extends Sprite {
        private var cMess:clsText;
        
        public function testAlert() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            addChild(new clsButton("BTN-OK","OK" ,    5, 5, 80, 20 ,fncAlert));
            addChild(new clsButton("BTN-YN","YES/NO" ,    90, 5, 80, 20 ,fncAlert));
            addChild(new clsButton("BTN-YNC", "YES/NO/CANCEL" , 175, 5, 100, 20 , fncAlert));
            cMess=new clsText("",5, 30, 200, 20,true)
            addChild(cMess);
        }
        private function fncAlert(btn:clsButton):void {
            var s:String = btn.name;
            this.mouseEnabled = false;
            switch(s) {
                case "BTN-OK":
                    //clsAlert.show(root,"Alertクラスのテストプログラムです。", "AlertクラスTEST");
                    clsAlert.show(root, "Alertクラスのテストプログラムです。",
                            "AlertクラスTEST",clsAlert.OK,onAlter);
                    break;
                case "BTN-YN":
                    clsAlert.show(root,"YES/NO\nボタンテスト", "YES/NO test",clsAlert.YES|clsAlert.NO,onAlter);
                    break;
                case "BTN-YNC":
                    clsAlert.show(root, "使用できるボタンは\n　YES\n　NO\n　CANCEL\nボタンタイプです。", 
                            "YES/NO/CANCELを使うAlertのTESTです。(タイトル長)",
                            clsAlert.YES|clsAlert.NO|clsAlert.CANCEL,onAlter);
                    break;
            }
        }
        private function onAlter(flag:uint):void {
            if(flag==clsAlert.OK) {cMess.text = "OKが押されました。";}
            if(flag==clsAlert.YES) {cMess.text = "YESが押されました。";}
            if(flag==clsAlert.NO) {cMess.text = "NOが押されました。";}
            if(flag==clsAlert.CANCEL) {cMess.text = "CANCELが押されました。";}
        }
    }
}
//======================================================
//package cls {
    //----------------------------------------------
    //Alertクラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
//    public class clsAlert {
    class clsAlert {
        private static var spPar:Object;    //親(root)
        private static var spBack:Sprite;    //モーダルのための領域
        private static var spMain:Sprite;    //Alertのエリア

        //Alertの移動用
        public static var blMouseFlg:Boolean = false;
        public static var intMouseX:int;
        public static var intMouseY:int;
        //Alertのサイズ
        public static var intW:int;
        public static var intH:int;
        //ボタンの押されたときの関数
        public static var fncBtn:Function;
        
        //ボタンの列挙型
        public static const YES:uint = 0x0001;
        public static const NO:uint = 0x0002;
        public static const OK:uint = 0x0004;
        public static const CANCEL:uint = 0x0008;
        
        //----------------------------------------------------------------------------
        // Alertを表示
        //  clsAlert.show(root,"メッセージ", "タイトル",clsAlert.YES|clsAlert.NO,cloFnc);
        // par:親(rootを指定)
        // text:メッセージ（改行も対応）
        // title:タイトル
        // flags:表示するボタン（YES/NO/OK/CANCEL)
        // cloFnc:ボタンが押されたとき実行する関数(cloFnc(ui:uint):void)が押されたボタンの値
        public static function show(par:Object, text:String = "", title:String = "",
                    flags:uint = OK, cloFnc:Function = null):void {
                    
            fncBtn = cloFnc;
            // rootのサイズ
            spPar = par;
            var iWid:int = spPar.stage.stageWidth;
            var iHei:int = spPar.stage.stageHeight;
            // モーダルにするために四角を書く
            spBack=new Sprite();
            spBack.graphics.beginFill(0xffffff,0.5);
            spBack.graphics.lineStyle(1,0xffffff,0.5);
            spBack.graphics.drawRect(0, 0,  spPar.stage.stageWidth, spPar.stage.stageHeight);
            // Alertの各部品を配置するエリア
            spMain = new Sprite();
            spPar.addChild(spBack);
            spBack.addChild(spMain);
            //タイトルを配置
            var tfTit:TextField = new TextField();
            tfTit.autoSize = "left";
            tfTit.text = title;
            tfTit.selectable = false;
            var idx:int = tfTit.width;    //Alertの大きさ
            var idy:int = 20;
            spMain.addChild(tfTit);
            //メッセージを配置
            var tfMes:TextField = new TextField();
            tfMes.multiline = true;
            tfMes.autoSize = "left";
            tfMes.text = text;
            tfMes.selectable = false;
            if(idx< tfMes.width+4) {idx= tfMes.width+4;}
            idy += tfMes.height+4;
            spMain.addChild(tfMes);
            tfMes.y = 22;
            tfMes.x = 2;
            //ボタンの配置
            var ibx:int = 20;
            if ((flags & YES) != 0x0000) {ibx += 65;}
            if ((flags & NO) != 0x0000) {ibx += 65;}
            if ((flags & OK) != 0x0000) {ibx += 65;}
            if ((flags & CANCEL) != 0x0000) {ibx += 65;}
            ibx += 20-10;
            if (ibx > idx) { 
                idx = ibx;
                ibx = 20;
            } else {
                ibx = 20 + (idx - ibx) / 2;
            }
            if ((flags & YES) != 0x0000) {
                spMain.addChild(new clsButton("YES", "YES" , ibx, idy, 55, 20 , fncBtnOn));
                ibx += 65;
            }
            if ((flags & NO) != 0x0000) {
                spMain.addChild(new clsButton("NO", "NO" ,    ibx, idy, 55, 20 , fncBtnOn));
                ibx += 65;
            }
            if ((flags & OK) != 0x0000) {
                spMain.addChild(new clsButton("OK", "OK" ,    ibx, idy, 55, 20 , fncBtnOn));
                ibx += 65;
            }
            if ((flags & CANCEL) != 0x0000) {
                spMain.addChild(new clsButton("CANCEL", "CANCEL" ,    ibx, idy, 55, 20 , fncBtnOn));
                ibx += 65;
            }
            idy += 25;
            
            //Alertの外形
            spMain.graphics.beginFill(0xffffff);
            spMain.graphics.lineStyle(1,0x000000);
            spMain.graphics.drawRect(0, 0, idx, idy);
            spMain.x = int((iWid - idx) / 2);
            spMain.y = int((iHei - idy) / 2);
            //タイトルの外形
            tfTit.autoSize = "none";
            tfTit.width = idx;
            tfTit.height = 20;
            tfTit.border = true;
            tfTit.background = true;
            tfTit.backgroundColor = 0xbbbbbb;
            //MOUSE_DOWN以外はstageを付ける
            tfTit.addEventListener(MouseEvent.MOUSE_DOWN,onDown);
            tfTit.stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            tfTit.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
            intW = idx;
            intH = idy;
        }
        //Alertのドラッグによる移動
        private static function onDown(e:MouseEvent):void {
            blMouseFlg = true;
            intMouseX=spPar.mouseX;
            intMouseY=spPar.mouseY;
        }
        private static function onMove(e:MouseEvent):void {
            if(e.buttonDown==false) {blMouseFlg = false;}
            if (blMouseFlg == true) {
                var x1:int = spPar.mouseX;
                var y1:int = spPar.mouseY;
                var x2:int=spMain.x + x1 - intMouseX ;
                var y2:int=spMain.y + y1 - intMouseY ;
                fncChkXY(x2,y2);
                intMouseX = x1;
                intMouseY = y1;
            }
        }
        private static function onUp(e:MouseEvent):void {
            blMouseFlg = false;
        }
        //Alertが領域外に出ないようにする
        private static function fncChkXY(x1:int,y1:int):void {
            if (x1 > spPar.stage.stageWidth - intW-1) { x1 = spPar.stage.stageWidth - intW-1; }
            if (y1 > spPar.stage.stageHeight - intH-1) { y1 = spPar.stage.stageHeight - intH-1; }
            if (x1 < 0) { x1 = 0; }
            if (y1 < 0) { y1 = 0; }
            spMain.x=x1;
            spMain.y=y1;
        }
        //ボタンが押されたときの処理===============================
        private static function fncBtnOn(btn:clsButton):void {
            spPar.removeChild(spBack);    //Alertの削除
            spBack = null;
            spMain = null;
            if (fncBtn != null) {    //呼び出し側の関数を実行
                if (btn.name == "YES") { fncBtn(YES); }
                if (btn.name == "NO") { fncBtn(NO); }
                if (btn.name == "OK") { fncBtn(OK); }
                if (btn.name == "CANCEL") { fncBtn(CANCEL); }
            }
        }
    }
//}
//========================================================
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    //   長押し(LongPress)の対応
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.getTimer;
    
//    public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var fncChkFnc:Function;
        private var fncLongPress:Function;
        private var intTim:int;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // nam:ボタンの名称（ボタンを区別するために使用）
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(b:clsButton):void」
        // fLongPress:ボタンの長押ししたときの関数「fLongPress(b:clsButton):void」
        // bItalic：ボタンの文字をItalicにするか？
        public function clsButton(nam:String,sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function=null,
                fLongPress:Function = null, bItalic:Boolean = false) {
                    
            name = nam;
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0x000000;
            this.background = true;
            this.backgroundColor = 0xcccccc;
            this.textColor = 0x000000;
            this.selectable = false;    //ボタンの表示文字は選択不可
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.italic = bItalic;
            this.setTextFormat(tfFormat);
            //マウスがのった時の色の変更
            this.addEventListener(MouseEvent.ROLL_OVER, onOver);
            this.addEventListener(MouseEvent.ROLL_OUT, onOut);
            //クリック時の処理
            fncChkFnc = fChk;
            if(fncChk!=null) {this.addEventListener(MouseEvent.CLICK, fncChk);}
            //長押し時の処理
            fncLongPress = fLongPress;
            if (fncLongPress != null) {
                this.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
                this.addEventListener(MouseEvent.MOUSE_UP, onUp);
            }
            this.enable(true);    //ボタンを有効に
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            this.mouseEnabled = bflg;
            if (bflg == true) { this.alpha = 1.0; }
            else {this.alpha = 0.5;}
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function onOver(e:MouseEvent):void {
            e.target.backgroundColor = 0xaaaaaa;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function onOut(e:MouseEvent):void {
            e.target.backgroundColor = 0xcccccc;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
        //長押し(LongPress)の対応
        public function onDown(e:MouseEvent):void {
            intTim = getTimer();
            this.addEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onUp(e:MouseEvent):void {
            this.removeEventListener(Event.ENTER_FRAME, onLongPress);
        }
        public function onLongPress(e:Event):void {
            //ボタンを押し続けて0.5秒以上たったら長押し
            if (intTim < getTimer() - 500) { fncLongPress(this); }
        }
        //クリック
        public function fncChk(e:Event):void {
            fncChkFnc(this);
        }
    }
//}
//=====================================================
//package cls {
    //----------------------------------------------
    //テキストの表示クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.text.TextField;
    
//    public class  clsText extends TextField {
    class  clsText extends TextField {
        //テキストの表示クラス
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:表示するサイズ
        // bBorder：外枠の有無
        public function clsText(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number ,bBorder:Boolean=false) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = bBorder;
            this.background = bBorder;
        }
    }
//}