/**
 * Copyright hubert.teo.hk ( http://wonderfl.net/user/hubert.teo.hk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vczE
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    public class Repulsion extends Sprite {
        public static var PX:Number = 0.1;
        public static var MINPY:Number = 0.1;
        public static var MAXPY:Number = 0.9;
        public static var VX:Number = 1;
        public static var TS:Number = 8;
        public static var NP:int = 20;
        public static var MAXK:int = 1000;
        public var K:Number = 30;
        public var sw:Number = 0;
        public var sh:Number = 0;
        public var q:Vector.<Point> = new Vector.<Point>();
        
        public function Repulsion() {
            addEventListener(Event.ADDED_TO_STAGE, function(e:Event):void {
                sw = stage.stageWidth;
                sh = stage.stageHeight;  
                drawScene();
            });
            stage.addEventListener(MouseEvent.MOUSE_MOVE, function(e:MouseEvent):void {
                drawScene();
            });
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
                var m:Point = new Point(stage.mouseX, stage.mouseY);
                var n:int = q.length;
                var deleted:Boolean = false;
                for (var i:int = 0; i < n; ++i) {
                    var o:Point = q[i];
                    var d2:Number = (o.x - m.x) * (o.x - m.x) + (o.y - m.y) * (o.y - m.y);
                    if (d2 < 8.0 * 8.0) {
                        q.splice(i, 1);
                        deleted = true;
                        break;
                    }
                }
                
                if (!deleted) q.push(m);
                drawScene();
            });
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, function(e:MouseEvent):void {
                if (e.delta > 0) K *= 1.5;
                else K /= 1.5;
                drawScene();
            });
        }

        public function drawScene():void {
            graphics.clear();
            var m:Point = new Point(stage.mouseX, stage.mouseY);
            
            q.push(m);
            for (var i:int = 0; i < NP; ++i) {
                var x:Point = new Point(PX * sw, (Number(i) / (NP - 1) * (MAXPY - MINPY) + MINPY) * sh);
                var v:Point = new Point(VX, 0.0);
                addCharge(x, v);
            }
            q.pop();
            
            with (graphics) {
                beginFill(0xEE1122);
                drawCircle(m.x, m.y, 2);
                endFill();
            }
            
            q.forEach(function(o:Point, id:int, v:Vector.<Point>):void {
                with (graphics) {
                    beginFill(0x11EE22);
                    drawCircle(o.x, o.y, 2);
                    endFill();
                }
            });
        }
        
        public function addCharge(x:Point, v:Point):void {
            with (graphics) {
                beginFill(0x000000);
                drawCircle(x.x, x.y, 2);
                endFill();
            }

            graphics.lineStyle(1, 0x000000);
            
            var px:Point = new Point(x.x, x.y);
            for (var k:int = 0; k < MAXK; ++k) {
                var a:Point = new Point(0.0, 0.0);
                q.forEach(function(o:Point, id:int, v:Vector.<Point>):void {
                    var d:Point = new Point(x.x - o.x, x.y - o.y);
                    var d2:Number = d.x * d.x + d.y * d.y;
                    var f:Number = K / Math.pow(d2, 1.5);
                    a.x += f * d.x;
                    a.y += f * d.y;
                });
                v.x += TS * a.x;
                v.y += TS * a.y;
                x.x += TS * v.x;
                x.y += TS * v.y;
                
                with (graphics) {
                    moveTo(px.x, px.y);
                    lineTo(x.x, x.y);
                }
                
                if (x.x < 0 || x.y < 0 || x.x > sw || x.y > sh) break;
                px.x = x.x;
                px.y = x.y;
            }
            
            graphics.lineStyle();
        }
    }
}