/**
 * Copyright tsmallfield ( http://wonderfl.net/user/tsmallfield )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vcv4
 */

package {
    import flash.display.PixelSnapping;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.display.Stage;
    
    import flash.events.MouseEvent;
    import flash.events.Event;
    
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    
    public class Main extends Sprite {
        private static const POWER:uint = 15;
        private static const GLOW_SCALE:uint = 3;
        private static const GLOW_MATRIX:Matrix = new Matrix(1 / GLOW_SCALE, 0, 0, 1 / GLOW_SCALE);
        private static const CVS_COLOR_TRANSFORM:ColorTransform = new ColorTransform(1, 1, 1, .7);
        
        public static const WIDTH:uint  = 465;
        public static const HEIGHT:uint = 465;
        
        private var cvs:BitmapData;
        private var glow:BitmapData;
        private var particleList:Vector.<Particle> = new Vector.<Particle>;
        private var inactiveParticleList:Vector.<Particle> = new Vector.<Particle>;
        
        public function Main() {
            [SWF(width = WIDTH, height = WIDTH, framerate = 30)]
            
            // bmd for particles
            cvs = new BitmapData(WIDTH, HEIGHT, false, 0);
            addChild(new Bitmap(cvs));
            
            // bmd for glow effect (@see http://wonderfl.net/c/g9s1)
            glow = new BitmapData(WIDTH / GLOW_SCALE, HEIGHT / GLOW_SCALE, false, 0);
            
            var bm:Bitmap = new Bitmap(glow/*, PixelSnapping.NEVER, true*/);
            bm.scaleX = bm.scaleY = GLOW_SCALE;
            bm.blendMode = BlendMode.ADD;
            addChild(bm);
            
            stage.addEventListener(Event.ENTER_FRAME, handleEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
        }
        
        private function handleMouseDown(evt:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP,   handleMouseUp);
        }
        
        private function handleMouseUp(evt:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP,   handleMouseUp);
        }
        
        private function handleMouseMove(evt:MouseEvent):void {
            var pl:Vector.<Particle> = particleList,
                ipl:Vector.<Particle> = inactiveParticleList,
                s:Stage = stage,
                mx:uint = s.mouseX,
                my:uint = s.mouseY,
                i:uint = POWER,
                p:Particle,
                rnd:Function = Math.random;
                
            while (i--) {
                p = ipl.pop();
                
                if (!p) {
                    pl.push(p = new Particle);
                } else {
                    p.init();
                }

                p.x = mx + rnd() * 2;
                p.y = my + rnd() * 2;
            }
        }
        
        private function handleEnterFrame(evt:Event):void {
            var c:BitmapData = cvs,
                g:BitmapData = glow,
                pl:Vector.<Particle> = particleList,
                ipl:Vector.<Particle> = inactiveParticleList,
                i:uint = pl.length,
                p:Particle;
            
            c.lock();
            c.colorTransform(c.rect, CVS_COLOR_TRANSFORM);
            
            while (i--) {
                p = pl[i];
                if (p.isActive) {
                    c.setPixel32(p.x, p.y, p.color);
                    p.move();
                } else {
                    ipl.push(p);
                }
            }
            
            g.fillRect(g.rect, 0);
            g.draw(this, GLOW_MATRIX);
             
            c.unlock();
        }
    }
}

////////////////////////////////////////////////

/**
 *
 */
class Particle {
    private static const SPEED:uint = 10;
    private static const LIFE_MAX:uint = 40;
    
    private var vy:int = 0;
    private var vx:int = 0;
    private var life:uint = LIFE_MAX;
    
    public var x:int;
    public var y:int;
    public var color:int;
    public var isActive:Boolean;
    
    public function Particle(){
        init();
    }
    
    public function init():void{
        vx = (Math.random() * 2 - 1) * SPEED || 1;
        vy = (Math.random() * 2 - 1) * SPEED || 1;
        color = Math.random() * 0xffffff | 0;
        life = Math.random() * LIFE_MAX || 1;
        isActive = true;
    }
    
    public function move():void{
        x += vx;
        if (x < 0 || x >= Main.WIDTH) {
            vx *= -1;
        }
        
        y += vy;
        if (y < 0 || y >= Main.HEIGHT) {
            vy *= -1;
        }
        
        if (--life <= 0) {
            life = 0;
            isActive = false;
        }
    }
}