/**
 * Copyright yumgsta ( http://wonderfl.net/user/yumgsta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vcu8
 */

package
{
	import Box2D.Collision.Shapes.b2CircleDef;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Collision.b2AABB;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import Box2D.Dynamics.b2BodyDef;
	import Box2D.Dynamics.b2World;
 
	import flash.events.Event;
 
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
 
	[SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
	public class Box2DFlashWithPapervision3D extends BasicView
	{
		private var WORLD_SCALE:Number = 30;
		private var WIDTH:Number = 640;
		private var HEIGHT:Number = 480;
 
		private var world:b2World;
 
		private var iterations:int = 10;
		private var timeStep:Number = 1.0/30.0;
 
		public function Box2DFlashWithPapervision3D()
		{
			setupPapervision3D();
			createWorld();
			createFloor();
			createShapes();
 
			startRendering();
		}
 
		private function setupPapervision3D():void
		{
			camera.focus = 10;
			camera.zoom = 100;
		}
 
		private function createWorld():void {
			var worldBounds:b2AABB = new b2AABB();
			worldBounds.lowerBound = new b2Vec2( 0, 0 );
			worldBounds.upperBound = new b2Vec2(WIDTH/WORLD_SCALE, HEIGHT/WORLD_SCALE);
 
 			var gravity:b2Vec2 = new b2Vec2(0, 10);
			var sleep:Boolean = true;
 
			world = new b2World(worldBounds, gravity, sleep);
		}
 
		private function createFloor():void
		{
			// Create border of boxes
			var floorShapeDef:b2PolygonDef = new b2PolygonDef();
			var floorBodyDef:b2BodyDef = new b2BodyDef();
			var floor:b2Body;
 
			//bottom shape definition
			floorShapeDef.SetAsBox((WIDTH+40)/WORLD_SCALE/2, 100/WORLD_SCALE);
 
			// Bottom
			floorBodyDef.position = new b2Vec2(WIDTH/WORLD_SCALE/2, (HEIGHT+95)/WORLD_SCALE);
			floor = world.CreateBody(floorBodyDef);
			floor.CreateShape(floorShapeDef);
 
			floor.SetMassFromShapes();
		}
 
		private function createShapes():void
		{
			for (var i:Number = 0; i < 20; i++)
			{
				//radius for physics circle and sphere
				var radius:Number = Math.random() * 50 + 10;
 
				var bodyDef:b2BodyDef = new b2BodyDef();
				//random position toward the top of the stage
				bodyDef.position = new b2Vec2(Math.random() * WIDTH / WORLD_SCALE, Math.random() * 50 /WORLD_SCALE);
 
				var body:b2Body = world.CreateBody(bodyDef);
 
				var shapeDef:b2CircleDef = new b2CircleDef();
				shapeDef.radius = radius/WORLD_SCALE;
				shapeDef.density = 1;
				shapeDef.friction = .7;
				shapeDef.restitution = .7;
				body.CreateShape(shapeDef);
				body.SetMassFromShapes();
 
				var sphere:Sphere = new Sphere(null, radius);
 
				scene.addChild(sphere);
				body.m_userData = sphere;
			}
		}
 
		override protected function onRenderTick(event:Event=null):void
		{
			world.Step(timeStep, iterations);
 
			//sets the position of any DisplayObject3D to the body position
			for (var bb:b2Body = world.m_bodyList; bb; bb = bb.m_next)
			{
                if (bb.m_userData is DisplayObject3D)
                {
                        bb.m_userData.x = bb.GetPosition().x * WORLD_SCALE - WIDTH * .5;
                        bb.m_userData.y = -bb.GetPosition().y * WORLD_SCALE + HEIGHT * .5;
                        bb.m_userData.rotationZ = -bb.GetAngle() * (180/Math.PI);
                }
			}
			renderer.renderScene(scene, camera, viewport);
		}
	}
}