/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vcjt
 */

/**
 * Stardust Particle Engine
 * 
 * Homepage
 * 	http://code.google.com/p/stardust-particle-engine/
 * 
 * Documentation
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/docs/index.html
 * 
 * PDF Manual
 * 	http://stardust-particle-engine.googlecode.com/svn/trunk/manual/Stardust%20Particle%20Engine%20Manual.pdf
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import idv.cjcat.stardust.common.clocks.ImpulseClock;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	[SWF(backgroundColor="#000010", frameRate=60)]
	
	public class Main extends Sprite {
		
		private var clock:ImpulseClock;
		private var emitter:CircleEmitter;
		
		public function Main():void {
			//container
			var container:Sprite = new Sprite();
			addChild(container);
			
			//clock
			clock = new ImpulseClock(5);
			
			//emitter & renderer
			emitter = new CircleEmitter(clock);
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(container);
			renderer.addEmitter(emitter);
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			addEventListener(Event.ENTER_FRAME, mainLoop);
		}
		
		private function onMouseMove(e:MouseEvent):void {
			emitter.point.x = mouseX;
			emitter.point.y = mouseY;
			clock.impulse();
		}
		
		private function mainLoop(e:Event):void {
			emitter.step();
		}
	}
}

//------------------------------------------------------------------------------------------------

import flash.display.Shape;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Accelerate;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;

//------------------------------------------------------------------------------------------------

//I have no idea why this line must be added in order to compile successfully on Wonderfl.
//Just ignore this class :p
class BugFixer extends Shape { public function BugFixer() { } }

//------------------------------------------------------------------------------------------------

class CircleEmitter extends Emitter2D {
	
	public var point:SinglePoint;
	
	public function CircleEmitter(clock:Clock) {
		super(clock);
		
		//initializers
		point = new SinglePoint(0, 0);
		
		addInitializer(new DisplayObjectClass(Circle));
		addInitializer(new Life(new UniformRandom(50, 0)));
		addInitializer(new Position(point));
		addInitializer(new Velocity(new LazySectorZone(0, 0.00001)));
		
		//actions
		addAction(new Age());
		addAction(new DeathLife());
		addAction(new Move());
		addAction(new Accelerate(0.03));
		addAction(new ScaleCurve(10, 10));
	}
}

//------------------------------------------------------------------------------------------------

class Circle extends Shape {
	
	public static const RADIUS:Number = 3;
	
	public function Circle() {
		graphics.beginFill(0xFFFFFF);
		graphics.drawCircle(0, 0, RADIUS);
	}
}