/**
 * Copyright points ( http://wonderfl.net/user/points )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vc4BG
 */

package {
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import flash.display.Sprite;
    import flash.events.MouseEvent;

    /**
     * ...
     * @author
     */
    public class Main extends Sprite {
        private var input1:InputText;
        private var input2:InputText;
        private var label:Label;

        public function Main(){
            input1 = new InputText(this, 200, 100, "0100#1011##01111", null);
            input1.width = 200;
            input1.restrict = "01#";
            input1.maxChars = 16;
            input2 = new InputText(this, 200, 150, "0100110110101111", null);
            input2.width = 200;
            input2.restrict = "01";
            input2.maxChars = 16;
            new PushButton(this, 200, 200, "verify", onPush);
            label = new Label(this, 200, 250, "result");
        }

        private function onPush(e:MouseEvent):void {
            var gene:Gene = new Gene(input1.text);
            label.text = String(gene.verify(input2.text));
        }

    }

}

class Gene extends Object {
    private var _wild:uint;
    private var _must:uint;

    public function Gene(gene:String):void {
        var arr:Array = gene.split("");
        _wild = 0;
        _must = 0;
        for (var i:int = 0; i < 16; i++){
            _wild <<= 1;
            _must <<= 1;
            if (arr[i] == "#"){
                _wild += 1;
            } else {
                _must += uint(arr[i]);
            }
        }
    }

    public function verify(gene:String):Boolean {
        return !(((parseInt(gene, 2) ^ _must) | _wild) ^ _wild);
    }
}