/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vbz4
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;

    
    /**
     * 変位マップフィルターのサンプル
     * @author Hikipuro
     */
    public class Main extends Sprite 
    {
        private var size:uint        = 160;
        private var offset:uint      = 60;
        private var labelText:String = "大相撲初場所（来年1月13日）";
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化メソッド
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            draw();
            createFilter();
            createLabel();
        }

        /**
         * ステージに、赤色のグラデーションの円を描く
         */
        private function draw():void
        {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(size, size);
            graphics.beginGradientFill(GradientType.RADIAL,
                                       [0xFF0000, 0x000000],
                                       [100, 100],
                                       [55, 200],
                                       matrix,
                                       SpreadMethod.PAD);
            graphics.drawRect(0, 0, size, size);
        }
        
        /**
         * フィルターを作ってステージに適用
         */
        private function createFilter():void
        {
            var filter:BitmapFilter = getDisplacementMapFilter();
            filters = new Array(filter);
        }

        /**
         * 変位フィルターを作成して返す
         * @return
         */
        private function getDisplacementMapFilter():BitmapFilter
        {
            var mapBitmap:BitmapData = createBitmapData();
            var mapPoint:Point       = new Point(0, 0);
            var channels:uint        = BitmapDataChannel.RED;
            var componentX:uint      = channels;
            var componentY:uint      = channels;
            var scaleX:Number        = 0;
            var scaleY:Number        = 30;
            var mode:String          = DisplacementMapFilterMode.CLAMP;
            var color:uint           = 0;
            var alpha:Number         = 0;
            return new DisplacementMapFilter(mapBitmap,
                                             mapPoint,
                                             componentX,
                                             componentY,
                                             scaleX,
                                             scaleY,
                                             mode,
                                             color,
                                             alpha);
        }

        /**
         * ステージに表示されている内容をコピーしてビットマップデータを返す
         * @return
         */
        private function createBitmapData():BitmapData
        {
            var bitmapData:BitmapData = new BitmapData(size, size, true, 0x000000);
            bitmapData.draw(this, new Matrix());
            var bitmap:Bitmap = new Bitmap(bitmapData);
            bitmap.x = size;
            addChild(bitmap);
            return bitmapData;
        }

        /**
         * テキストフィールドを作成する
         */
        private function createLabel():void
        {
            var tf:TextField = new TextField();
            tf.text = labelText;
            tf.y = offset;
            tf.textColor = 0xFFFFFF;
            tf.width = size - 2;
            tf.height = 18;
            tf.border = true;
            tf.borderColor = 0xFFFFFF;
            addChild(tf);
        }

    }
    
}        