/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZzQ
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;
    
    [SWF(backgroundColor=0xFFFFFF, frameRate=1)] // フレームレートを下げておく
    public class TestWebCam extends Sprite
    {
        public function TestWebCam()
        {
            var camera:Camera = Camera.getCamera();
            
            var video:Video = new Video(camera.width, camera.height);
            video.attachCamera(camera);
            
            var bitmapData:BitmapData = new BitmapData(
                                            camera.width, camera.height);
            
            
            addChild(new Bitmap(bitmapData));
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                bitmapData.draw(video);
                
                for (var x:int = 0; x < bitmapData.width; x++) {
                    for (var y:int = 0; y < bitmapData.height; y++) {
                        var p:uint = bitmapData.getPixel(x, y);
                        
                        if (p == 0xFFFFFF) { // 白い部分を赤く塗りつぶす。
                            bitmapData.setPixel(x, y, 0xFF0000);
                        }
                    }
                }
            });
        }
    }
}