/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZxy
 */

//
//	LineEffect
//		移動情報用のクラスを作ってパスの移動管理をしてます。
//
//	@author okoi
//
package 
{
	import adobe.utils.CustomActions;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	[SWF(backgroundColor = "0x000000", frameRate = "60")]
	
	public class Main extends Sprite 
	{
		
		private	var objs:Array = new Array();
		private	var step:int = 0;
		
		private var _canvas:BitmapData;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
						
			_canvas = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0xFF000000 );
			addChild( new Bitmap( _canvas ) );
			
			addEventListener( Event.ENTER_FRAME, Update );
			
		}
		
		private	function Update(e:Event):void
		{
			if ( step % 2 == 0 )
			{
				Generate();
				step = 0;
			}
			
			var filter:BlurFilter = new BlurFilter(2,2);
		
			_canvas.applyFilter( _canvas, _canvas.rect, new Point(), filter );
			
			for ( var i:int = objs.length - 1; i >= 0; i-- )
			{
				var obj:MoveObject = objs[i];
				obj.Update();
				
				_canvas.fillRect( new Rectangle( obj._x - 3, obj._y - 3, 6, 6), obj._color );
				
				if ( obj._x < 0 || obj._x > stage.stageWidth || obj._y < 0 || obj._y > stage.stageHeight )
				{
					objs.splice( i, 1 );
				}
			}
			
			step++;
		}
		
		private	function Generate():void 
		{
			var obj:MoveObject = new MoveObject();
		
			var x:Number = Math.random() * 100 - 50;
			var y:Number = Math.random() * 100 - 50;
			
			obj.Init( stage.stageWidth / 2 + x, stage.stageHeight / 2 + y );
			objs.push(obj);
		}
	}
	
}
//////////////////////////////////////////////////////
//--------------------------
//	パラメータ
//--------------------------
//	回転角度変更関連
const	ACTION_RAND:int = 2;
const	ACTION_MIN:int = 2;
//	回転速度関連
const	ROT_MAX:Number = 2;
const	ROT_MIN:Number = -2;
//	持続フレーム関連
const	FRAME_RAND:int = 100;
const	FRAME_MIN:int = 20;

/////////////////////////////////////////////////////
class MoveAction {
	
	public	var	rotspeed:Number;	//	回転速度
	public	var frame:int;		//	持続フレーム
	
	public	function MoveAction(r:Number, f:int):void 
	{
		rotspeed = r;
		frame = f;
	}
}

class MoveObject {
	
	public	var	_x:Number;
	public	var _y:Number;
	public	var _angle:Number;		//	角度
	public	var	_action:Array = new Array();
	
	public	var _color:uint;
	
	public	function MoveObject():void 
	{
		
	}
	
	public	function Init(x:Number, y:Number):void 
	{
		_x = x;
		_y = y;
		
		var	count:int = int(Math.random() * ACTION_RAND) + ACTION_MIN;
		
		for ( var i:int = 0; i < count; i++ )
		{
			var	rot:Number = (Math.random() * (ROT_MAX - ROT_MIN)) + ROT_MIN;
			var frame:int = (Math.random() * FRAME_RAND) + FRAME_MIN;
			_action.push( new MoveAction( rot, frame ) );			
		}
		
		_angle = Math.random() * 360;
		
		_color = (0xFF << 24) + (int(Math.random() * 0xFF) << 16) + (int(Math.random() * 0xFF) << 8) + (int(Math.random() * 0xFF) << 0);
	}
	
	public	function Update():void 
	{
		if ( _action.length > 0 )
		{
			var action:MoveAction = _action[ _action.length - 1 ];
			
			_angle += action.rotspeed;
			
			action.frame--;
			if ( action.frame == 0 )
			{
				_action.splice(_action.length - 1, 1);
			}
		}
		
		_x += Math.cos( _angle * Math.PI / 180 ) * 3;
		_y += Math.sin( _angle * Math.PI / 180 ) * 3;
	}
	
}