/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZus
 */

package 
{
	// 必要なライブラリをインポートします
	import flash.events.Event;
	//import org.papervision3d.lights.PointLight3D;
	//import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.materials.BitmapFileMaterial;
	import net.hires.debug.Stats;
	import flash.system.Security;
	/**
	 * シンプルな球面デモ(BasicViewを継承すると最低限の必要な3D設定が済んでます)
	 */
	[SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
	public class Main5 extends BasicView
	{
		public function Main5():void 
		{
			Security.loadPolicyFile("http://mztm.heteml.jp/crossdomain.xml");
			addChild(new Stats());
			var material:BitmapFileMaterial = new BitmapFileMaterial("http://mztm.heteml.jp/umhr/wonderfl/er04.jpg");
			material.smooth = true;
			// 球面を作成(引数はテクスチャ、半径、横方向のポリゴン分割数、縦方向のポリゴン分割数)
			var sphere:Sphere = new Sphere(material, 480, 24, 24);
			
			// 3Dシーンに表示(PV3DではsceneにaddChildします)
			scene.addChild(sphere);
			
			// レンダリング開始
			startRendering();
			
			// ループ処理を設定します
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				var mouseY:Number = Math.min(Math.max(stage.mouseY, 0), stage.stageHeight) - stage.stageHeight / 2;
                sphere.rotationX += mouseY / 1000;
			    sphere.localRotationY += 0.2;
		        });
				
				
		 }
	}
}