/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZh0
 */

// perlinNoise()遊び
// 
// クリックでリセット。
// リセットするたびに規則的、不規則的が切り替わります。
// 
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
    public class FlashTest extends Sprite
	{
		private var bmpdata:BitmapData;
		private var bdBack:BitmapData;
		private var spView:Sprite;
		private var crclList:Array;
		
        public function FlashTest()
		{
			graphics.beginFill(0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			bmpdata = new BitmapData(stage.stageWidth, stage.stageHeight, false);
			
            bdBack = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
			addChild(new Bitmap(bdBack));
			
			reset();
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
			{
				rndPos = !rndPos;
				bdBack.fillRect(bdBack.rect, 0);
				removeChild(spView);
				reset();
			});
        }
		
		private function reset():void
		{
			bmpdata.perlinNoise(bmpdata.width * .5, bmpdata.height * .5, 1, Math.random() * 0xFFFFFF, false, false);
			addChild(spView = new Sprite());
			crclList = new Array();
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			for (var c:int = 0; c < 10; c++)
			addCrcl();
			
			for (var i:int = 0; i < crclList.length; i++)
			{
				var obj:Object = crclList[i];
				obj.sp.scaleX = obj.sp.scaleY = ++obj.life / 30;
				if (obj.life >= 30)
				{
					var m:Matrix = new Matrix();
					m.translate(obj.sp.x, obj.sp.y);
					bdBack.draw(obj.sp, m);
					spView.removeChild(obj.sp);
					crclList.splice(i--, 1);
				}
			}
		}
		
		private var rndPos:Boolean = false;
		private var cx:Number = 0;
		private var cy:Number = 0;
		private function addCrcl():void
		{
			var crcl:Sprite = new Sprite();
			spView.addChild(crcl);
			if (rndPos)
			{
				crcl.x = Math.random() * bdBack.width;
				crcl.y = Math.random() * bdBack.height;
			}
			else
			{
				crcl.x = cx;
				crcl.y = cy;
				cx += 40;
				if (cx > bdBack.width)
				{
					cx -= bdBack.width;
					cy += 20;
					if (cy > bdBack.height)
						cy -= bdBack.height;
				}
			}
			crcl.scaleX = crcl.scaleY = 0;
			
			var color:uint = bmpdata.getPixel(crcl.x, crcl.y);
			crcl.graphics.beginFill(color);
			var v:Number = ((color & 0xFF0000 >> 16) / 0xFF + (color & 0x00FF00 >> 8) / 0xFF + (color & 0x0000FF) / 0xFF) / 3;
			crcl.graphics.drawCircle(0, 0, 50 * v);
			crcl.graphics.endFill();
			
			crclList.push({
				sp:crcl,
				life:0
			});
		}
		
    }
}