/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZgq
 */

package {
    import flash.utils.getTimer;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    
    [SWF(frameRate=60, width=465, height=465, backgroundColor=0x000000)]
    public class Pixels extends Sprite {
        
        private static const PIXEL_SIZE:int = 4;
        private static const NUM_PIXELS:int = 2000;
        private static const GRAVITY:Number = 0.2;
        
        private var bmpData:BitmapData;
        private var bmp:Bitmap;
        private var canvas:Sprite;
        
        private var pixel:Array;
        
        private var friction:Number = 0.97;
        
        private var debug:TextField;
        private var sw:int, sh:int;
        private var cw:int, ch:int;
        
        private var oldTime:int;
        
        public function Pixels() {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init():void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            oldTime = getTimer();
            
            sw = stage.stageWidth, sh = stage.stageHeight;
            cw = sw / PIXEL_SIZE;
            ch = sh / PIXEL_SIZE;
            
            canvas = new Sprite();
            addChild(canvas);
            
            bmpData = new BitmapData(cw, ch, false, 0x000000);
            bmp = new Bitmap(bmpData);
            bmp.scaleX = bmp.scaleY = PIXEL_SIZE;
            canvas.addChild(bmp);
            
            debug = new TextField();
            debug.autoSize = TextFieldAutoSize.LEFT;
            debug.defaultTextFormat = new TextFormat("Arial", 24, 0xeeeeee);
            addChild(debug);
            
            pixel = [];
            for (var i:int = 0; i < NUM_PIXELS; i++) {
                pixel[i] = [cw*.5, ch*.5, (Math.random() * 6) - 3, (Math.random() * 10) -8, int(Math.random() * uint.MAX_VALUE), 10];
            }

            stage.addEventListener(MouseEvent.CLICK, toggleFullscreen);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function toggleFullscreen(e:MouseEvent):void {
            if (stage.displayState == "normal") {
                stage.displayState = "fullScreen";
            } else {
                stage.displayState = "normal";
            }
            
        }
        
        private function loop(e:Event):void {
            bmpData.lock();
            
            bmpData.fillRect(bmpData.rect, 0x0f0423);
            for (var i:int = 0; i < NUM_PIXELS; i++) {
                pixel[i][2] *= friction;
                pixel[i][3] *= friction;
                pixel[i][3] += GRAVITY;
                
                pixel[i][0] += pixel[i][2];
                pixel[i][1] += pixel[i][3];
                
                if (pixel[i][0] >= cw) {
                    pixel[i][0] = cw;
                    pixel[i][2] = -pixel[i][2];
                } else if (pixel[i][0] <= 0) {
                    pixel[i][0] = 0;
                    pixel[i][2] = -pixel[i][2];
                }

                if (pixel[i][1] >= ch) {
                    pixel[i][1] = ch;
                    pixel[i][3] = -pixel[i][3];
                    pixel[i][5] -= 1;
                } else if (pixel[i][1] <= 0) {
                    pixel[i][1] = 0;
                    pixel[i][3] = -pixel[i][3];
                }
                
                if (pixel[i][5] <= 0) {
                    pixel[i] = [cw*.5, ch*.5, (Math.random() * 6) - 3, (Math.random() * 6) -5, int(Math.random() * uint.MAX_VALUE), 10];
                }
                
                bmpData.setPixel(pixel[i][0], pixel[i][1], pixel[i][4]);
            }
            
            bmpData.unlock();
        }
    }
}