/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZfN
 */

package {	
    import flash.display.Sprite;
	import flash.events.Event;
    public class HexToFlash extends Sprite {
		
		private var convas:Sprite;
		
		private var axis:Axis;
		
		private var h:Hexagon;
		
		private var mouse:Sprite;
		
		private var output:T;
		
		public function HexToFlash() 
		{
			graphics.beginFill(0);
			graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
			graphics.endFill();
			
			convas = new Sprite();
			addChild( convas );
			
			output = new T();
			output.textColor = 0xFFFFFF;
			output.x = output.y = 10;
			addChild( output );
			
			mouse = new Sprite();
			convas.addChild( mouse );
			
			
			convas.x = stage.stageWidth / 2 - 30;
			convas.y = stage.stageHeight / 2;
			
			axis = new Axis();
			axis.render( convas.graphics );
			
			//h = new Hexagon( 1, 0, -1 );
			
			/*
			Hexagon.Render( convas.graphics, new Hexagon( 1, 0, -1 ) , 0xD6E613 );
			Hexagon.Render( convas.graphics, new Hexagon( 0, 1, -1 ) , 0xD6E613 );
			Hexagon.Render( convas.graphics, new Hexagon( -1, 1, 0 ) , 0xD6E613 );
			Hexagon.Render( convas.graphics, new Hexagon( -1, 0, 1 ) , 0xD6E613 );
			Hexagon.Render( convas.graphics, new Hexagon( 0, -1, 1 ) , 0xD6E613 );
			Hexagon.Render( convas.graphics, new Hexagon( 1, -1, 0 ) , 0xD6E613 );
			*/
			
			var origin:Hexagon = new Hexagon( 0, 0, 0 );
			
			
			Hexagon.Render( convas.graphics, origin , 0xD6E613 );
			
			renderQuee = new Vector.<Hexagon>();
			
			//
			populate( 1, 1, origin, renderHexagon);
			populate( 3, 1, origin, renderHexagon);
			populate( 5, 1, origin, renderHexagon);
			
			addEventListener(Event.ENTER_FRAME, loop);
        }
		
		private function loop(e:Event):void 
		{
			if ( renderQuee.length > 0 )
				Hexagon.Render( convas.graphics, renderQuee.pop() , 0xD6E613 );
				
			mouse.graphics.clear();
			
			var h:Hexagon = Hexagon.ToHex(convas.mouseX, convas.mouseY);
			
			h.notmalize();
			
			Hexagon.Render(mouse.graphics, h, NaN, 0xFFFFFF);
			
			output.text = h.toString();
		}
		
		private var renderQuee:Vector.<Hexagon>;
		
		private function renderHexagon( h:Hexagon ):void
		{
			renderQuee.push( h );
		}
		
		//http://wonderfl.net/c/aVG7
		public function populate( direction:uint, ttl:int = 1, origin:Hexagon = null, onNew:Function = null):void //, populateLeft:int = 1, populateRight:int = 0):void
		{
			// Prevent stack overflow
			if ( ttl <= 0 ) return;
			
			var o:Hexagon = origin.clone();
			o.add( this.direction( direction ) );
			//o.connect( origin );
			//if( leftConnect ) if( o is most left ) o.connect( leftConnect )
			if ( onNew != null ) onNew( o );
			populate( direction, ttl - 1, o, onNew);
			
			// if( populateLeft > 0 ) ...
			
			o = origin.clone();
			o.add( this.direction( direction - 1 ) );
			if ( onNew != null ) onNew( o );
			populate( direction - 1, ttl - 1, o, onNew);
		}
		
		public function direction(dir:uint):Hexagon
		{
			while ( dir > 5 ) dir -= 6;        while ( dir < 0 ) dir += 6;
			
			switch( dir )
			{
				case 0:        return new Hexagon(  0, -1,  1 );    break;
				case 1:        return new Hexagon(  1, -1,  0 );    break;
				case 2:        return new Hexagon(  1,  0, -1 );    break;
				case 3:        return new Hexagon(  0,  1, -1 );    break;
				case 4:        return new Hexagon( -1,  1,  0 );    break;
				case 5:        return new Hexagon( -1,  0,  1 );    break;
			}
			
			// imposible return
			return null;
		}
    }
}
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.geom.Matrix;
import flash.geom.Point;

class Axis
{
	public var xAxis:Vec;
	public var yAxis:Vec;
	public var zAxis:Vec;
	
	public var xColor:uint = 0xF27606;
	public var yColor:uint = 0x8FDD1C;
	public var zColor:uint = 0x26B9D2;
	
	public function Axis()
	{
		xAxis = new Vec(200, 0);
		yAxis = xAxis.clone();
		zAxis = xAxis.clone();
		
		yAxis.degrees += 120;
		zAxis.degrees -= 120;
	}
	
	public function render(g:Graphics):void
	{	
		// Render axis arrows
		xAxis.render(g, null, xColor, 4);
		yAxis.render(g, null, yColor, 4);
		zAxis.render(g, null, zColor, 4);
		
		var tf:TextFormat = new TextFormat("_sans", 14, 0, true);
		
		// Scale to make axis labels visible
		xAxis.lenght += 15;
		yAxis.lenght += 15;
		zAxis.lenght += 15;
		
		// Draw axis labels
		tf.color = xColor;		T.Render(g, "X", xAxis.x, xAxis.y, "center", tf);
		tf.color = yColor;		T.Render(g, "Y", yAxis.x, yAxis.y, "center", tf);
		tf.color = zColor;		T.Render(g, "Z", zAxis.x, zAxis.y, "center", tf);
		
		// Scale back to default
		xAxis.lenght -= 15;
		yAxis.lenght -= 15;
		zAxis.lenght -= 15;
		
	}
}


class Hexagon 
{
	public var z:Number;
	public var y:Number;
	public var x:Number;
	public function Hexagon(x:Number, y:Number, z:Number)
	{
		this.z = z;
		this.y = y;
		this.x = x;
		
	}
	
	public function clone():Hexagon
	{
		return new Hexagon(x, y, z);
	}
	
	/// GLOBAL HEX SCALAR 
	public static var S:Number = 20;
	public static const X32:Number = 3 / 2;
	public static const Y3:Number = Math.sqrt(3);
	public static const X23:Number = 2 / 3;
	public static const Y13:Number = 1 / Y3;
	
	public function toCartesian():Point
	{
		return new Point(
		
			X32 * S * x, 
			Y3 * S * ( x / 2 + y )
		);
	}
	
	static public function ToHex(x:Number, y:Number):Hexagon
	{
		var h:Hexagon = new Hexagon(x * X23 / S,0,0);
		h.y = Y13 * y / S - h.x * 0.5;
		h.z = -h.x - h.y;
		return h;
	}
	
	public function notmalize():void
	{
		x = Math.round( x );
		y = Math.round( y );
		z = -x-y;
	}
	
	static public function Render(g:Graphics, hexagon:Hexagon, line:Number = NaN, fill:Number = NaN):void
	{
		if ( isNaN( line ) && isNaN( fill ) ) return;
		
		var v:Vec = new Vec(S, 0);
		
		var p:Point = hexagon.toCartesian();
		
		if ( !isNaN( line ) ) g.lineStyle( 2, line );
		if ( !isNaN( fill ) ) g.beginFill( fill );
		
		g.moveTo( p.x + S, p.y );
		var i:int = 0;
		while ( i < 6 )
		{
			i++;
			
			v.degrees += 60;
			
			g.lineTo( p.x + v.x, p.y + v.y );
		}
		
		if ( !isNaN( fill ) ) g.endFill();
		
		T.Render
		(
				g, 
					hexagon.x.toFixed(1) 
					+ "\n" + 
					hexagon.y.toFixed(1) 
					+ "\n" + 
					hexagon.z.toFixed(1)
				, 
				p.x, 
				p.y, 
				"center", 
				new TextFormat
				(
					"_sans", 
					8, 
					0xFFFFFF)
				, 
				false
		);
	}
	
	public function add(h:Hexagon):void 
	{
		x += h.x;
		y += h.y;
		z += h.z;
	}
	
	public function toString():String
	{
		return "X: " + x.toFixed(2) + " , Y: " + y.toFixed(2) + " , Z: " + z.toFixed(2);
	}
}




class Vec
{
	// Convert a line between two point into a vector
	static public function PP2V(a:Point, b:Point):Vec{return new Vec(b.x - a.x, b.y - a.y);}
	// Convert line 2 point
	static public function P2V(p:Point):Vec{return new Vec(p.x,p.y);}
	// Angle between two vectors in radians
	static public function RadiansBetween( A:Vec, B:Vec):Number{return Math.acos( A.clone().normalise().dot( B.clone().normalise() ) );}
	// Example: http://wonderfl.net/c/4Zft
	static public function PerpendicularProjection( V:Vec, U:Vec ):Vec
	{return U.clone().subtract( V.projection( U ) );}
    /** @author http://wonderfl.net/user/Vladik */
    public var x:Number, y:Number;
    public function Vec(x:Number = 0, y:Number = 0){this.x = x;this.y = y;}
    public function get lenght():Number{return Math.sqrt(x * x + y * y);}
    public function set lenght(value:Number):void{lenght == 0 ? scale(0) : scale(value / lenght);}
	public function set degrees(value:Number):void{radians = value * Math.PI / 180;}
	public function get degrees():Number{return radians * 180 / Math.PI;}
	public function set radians(value:Number):void{var f:Number = lenght;x = Math.cos(value) * f;y = Math.sin(value) * f;}
	public function scale(n:Number):Vec { x *= n; y *= n; return this; }
	public function clone():Vec{return new Vec(x, y);}
	public function get radians():Number { return Math.atan2(y, x); }
	public function dot( v:Vec ):Number { return x * v.x + y * v.y; }
	public function get point():Point { return new Point(x, y); }
	//Projection method credits: http://jccc-mpg.wikidot.com/vector-projection
	public function projection( u:Vec ):Vec{var l:Number = lenght;return clone().scale( u.dot( this ) / (l * l) );}
	public function normalise():Vec{scale(1);return this;}
	public function distToPoint( p:Point ):Number {return p.length * Math.sin( Vec.RadiansBetween( this, Vec.P2V(p) ) );}
	public function render( g:Graphics, o:Point = null, color:uint = 0xFF0000, thikness:uint = 3 ):void
	{if (o == null) o = new Point(); g.beginFill( color ); g.lineStyle( thikness, color); g.moveTo( o.x, o.y); var B:Point = new Point(o.x + x, o.y + y); g.lineTo( B.x, B.y);
	var v:Vec = Vec.PP2V( o, B );v.lenght = 7;v.degrees -= 45 + 180;g.lineTo( B.x + v.x, B.y + v.y );
	v.degrees += 90;g.lineTo( B.x + v.x, B.y + v.y );g.lineTo( B.x, B.y );g.endFill();}
	public function add( V:Vec ):Vec{this.x += V.x;this.y += V.y;return this;}
	public function subtract(V:Vec):Vec { this.x -= V.x; this.y -= V.y; return this; }
	public function toString():String{return "["+x.toFixed(2)+","+y.toFixed(2)+"]";}
}

import flash.text.TextField;
import flash.text.TextFormat;
class T extends TextField
{
	/** @author http://wonderfl.net/user/Vladik */
    public function T(txt:String = "Text", x:Number = 0, y:Number = 0)
    {var tf:TextFormat = new TextFormat("_sans", 12, 0x000000);
    this.setTextFormat(tf);this.defaultTextFormat = tf;
	this.autoSize = 'left';this.text = txt;
	this.selectable = this.wordWrap = this.multiline = this.mouseEnabled = false;   
	this.x = x - this.width / 2;this.y = y - this.height / 2;
    }
	
	private static var text:TextField;
	
	/**
	 * @param	label The string text value of the text field
	 * @param	x The X coordinates of the text on the target 
	 * @param	y The Y coordinates of the text on the target  
	 * @param	position "<b>topLeft</b>" - unchanged, "<b>center</b>" - the center of the text will be placed on top of the given x & y 
	 * @param	txtFormat
	 */
	public static function Render( target:Graphics, label:String ,x:int = 0, y:int = 0, position:String = "topLeft",txtFormat:TextFormat = null, signelLine:Boolean = true ):void { 
		// Check for empty text
		if ( label == "" || label == " ") return;
		// Set up the text
		if ( text == null ) text = new TextField();	
		text.multiline = !signelLine;
		text.mouseEnabled = text.mouseWheelEnabled = text.wordWrap = text.selectable = false;		
		text.autoSize = "left";var defaultTextFormat:TextFormat = txtFormat == null ? new TextFormat("Arial", 16, 0x0)	:	 txtFormat;
		text.defaultTextFormat = defaultTextFormat;
		text.setTextFormat( defaultTextFormat );text.text = label;
		// Use bitmap data to capture text as image
		var bitmapData:BitmapData = new BitmapData( text.width, text.height , true, 0x0);		
		bitmapData.draw( text );	
		// Translate the image
		var matrix:Matrix = new Matrix();switch( position ){case "center":	matrix.translate( x - text.width / 2, y - text.height / 2 );break;
		case "topLeft":default:matrix.translate( x, y );	break;}
		// Draw bitmapdata to target [Graphics]
		target.lineStyle( );target.beginBitmapFill( bitmapData , matrix , false , true );
		target.drawRect( matrix.tx , matrix.ty , text.width , text.height );	target.endFill( );
	}
}