/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZ9E
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
 
	public class Main extends Sprite
	{
		private var bullets:Array;
 
		public function Main()
		{
			bullets = new Array();
			for (var i:int = 0; i < 20; i++)
			{
				var bullet:Bullet = new Bullet(20 - i);
				addChild(bullet);
				bullets.push(bullet);
			}
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			var degree:Number = Math.atan2(mouseY - bullets[0].y, mouseX - bullets[0].x) / (Math.PI / 180);
			if (degree < 0) degree += 360;
 
			degree = degree - Bullet.degree;
 
			if (degree < 0) degree += 360;
 
			if (degree < 180)
			{
				Bullet.degree = (Bullet.degree + Bullet.D_MAX) % 360; 
			}
			else
			{
				Bullet.degree -= Bullet.D_MAX;
				if (Bullet.degree < 0) Bullet.degree += 360;
			}
 
			for (var i:int = bullets.length - 1; i >= 1; i--)
			{
				bullets[i].x = bullets[i - 1].x;
				bullets[i].y = bullets[i - 1].y;
			}
 
			bullets[0].x += Math.cos(Bullet.degree * Math.PI / 180) * 5;
			bullets[0].y += Math.sin(Bullet.degree * Math.PI / 180) * 5;
		}
	}
}
 
import flash.display.Sprite;
import flash.filters.DropShadowFilter;
 
class Bullet extends Sprite
{
	public static var degree:Number = 0;
	public static const D_MAX:Number = 5;
 
	public function Bullet(size:int)
	{
		graphics.beginFill(0x0);
		graphics.drawCircle(0, 0, size);
		graphics.endFill();
 
		this.alpha = size / 25;
		this.filters = [new DropShadowFilter(3)];
	}
}
