/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vZ27
 */

/**
* DoTextAnimationサンプル
**/
package {
	import flash.accessibility.Accessibility;
	import jp.progression.commands.lists.LoopList;
	import org.libspark.betweenas3.easing.Expo;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.text.TextField;

	/**
	 * @author fumix
	 */
	 [SWF(backgroundColor="#FFFFFF", frameRate="30", width="465", height="465")]
	public class Sample extends MovieClip {
		private var tf1 : TextField;
		private var tf2 : TextField;
		private var tf3 : TextField;
		private var tf4 : TextField;
		private var tf5 : TextField;

		public function Sample() {
			addEventListener(Event.ADDED_TO_STAGE, _initialize);
		}

		private function _initialize(event : Event) : void {
			tf1 = new TextField();
			tf2 = new TextField();
			tf3 = new TextField();
			tf4 = new TextField();
			tf5 = new TextField();
			tf1.x = tf2.x = tf3.x = tf4.x = tf5.x = 5;
			tf1.y = 5;
			tf2.y = 25;
			tf3.y = 45;
			tf4.y = 65;
			tf5.y = 85;

			addChild(tf1);
			addChild(tf2);
			addChild(tf3);
			addChild(tf4);
			addChild(tf5);
			var loop:LoopList = new LoopList();
			loop.addCommand(
				new DoTextAnimation(tf1, "Hello World!!","Wonderfl build flash online.",
					{
						step: 4,
						time: 3
					}),
					[
						new DoTextAnimation(tf2, "","ActionScript3.0 and Papervision3D and Tweener.",
							{
								step: 4,
								time: 3,
								characters:"0123456789/*-+#",
								transition: Expo.easeInOut
							}),
						new DoTextAnimation(tf3, "","Progression and Box2DFlashAS3 and Tweensy.",
							{
								step: 4,
								time: 3,
								delay:0.5,
								transition: Expo.easeInOut
							}),
						new DoTextAnimation(tf4, "","Flex and Mete and yui.",
							{
								step: 4,
								time: 3,
								delay:1.0,
								transition: Expo.easeInOut
							})
					],
				new DoTextAnimation(tf5, "","Hello World! Hello World! Hello World!",
					{
						step: 4,
						time: 3,
						delay:1.0
					})
					
			);
			loop.execute();
		}
	}
}

	import jp.progression.commands.*;

	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.core.easing.IEasing;
	import org.libspark.betweenas3.easing.Expo;

	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.utils.Timer;
	import flash.utils.getTimer;

	/**
	 * CommandTextAnimation
	 * @author fumix
	 */
	class DoTextAnimation extends Command {
		private var _textField : TextField;
		private var _fromText : String;
		private var _toText : String;
		private var _delay : Number;
		private var _time : Number;
		private var _step : Number;
		private var _characters : String;
		private var _replaceTimer : Timer;
		private var _transition : IEasing;
		private var _startTime : int;
		private var _fromArr : Array;
		private var _toArr : Array;
		private var _length : uint;
		private var _stepArray : Array;

		/**
		 * 新しい CommandTextAnimation インスタンスを作成します。
		 * @param tf アニメーションさせるテキストフィールド
		 * @param from 変化前のテキスト
		 * @param to 変化後のテキスト
		 * @param initObject
		 */
		public function DoTextAnimation( tf : TextField,from : String,to : String,initObject : Object = null ) {
			// 親クラスを初期化します。
			super(_executeFunction, _interruptFunction, initObject);
			//各種プロパティの初期値設定
			_delay = 0;
			_time = 2;
			_step = 4;
			_transition = Expo.easeOut;
			for(var i : int = 33;i < 128;i++) {
				_characters += String.fromCharCode(i);
			}

			if(initObject) {
				if(initObject.delay)  _delay = initObject.delay;
				if(initObject.time)  _time = initObject.time;
				if(initObject.step)  _step = initObject.step;
				if(initObject.characters)  _characters = initObject.characters;
				if(initObject.transition)  _transition = initObject.transition;
			}
			
			_fromText = from;
			_toText = to;
			_fromArr = splitText(_fromText);
			_toArr = splitText(_toText);
			_length = _fromArr.length + _toArr.length;
                        
			_textField = tf;
			_textField.autoSize = TextFieldAutoSize.LEFT;
		}

		
		/**
		 * 実行されるコマンドの実装です。
		 */
		private function _executeFunction() : void {
			// 
			_stepArray = new Array();
			_replaceTimer = new Timer(30);
			_replaceTimer.addEventListener(TimerEvent.TIMER, onReplaceTimer);

			_startTime = getTimer();
			_replaceTimer.start();
		}

		private function onReplaceTimer(event : TimerEvent) : void {
			var i : Number, l : Number, s : Number;
            
			var time : Number = (getTimer() - _startTime ) / 1000;
			var p : Number = getPosition(_transition, time, 0, 1, _time);
			if(p < 0) p = 0;
			if(p > 1) p = 1;
            
			p = Math.round(p * _length);
			var d : Number = p - _fromArr.length;
            
			var t : String = "";
			for(i = 0;i <= p;i++) {
				if(isNaN(_stepArray[i])) _stepArray[i] = _step;
			}
			if(d <= 0) {
				l = _fromArr.length;
				for(i = 0;i < l;i++) {
					s = _stepArray[l - i];
					if(isNaN(s)) {
						t += _fromArr[i];
					}else if(s > 0) {
						t += randomChar(_characters);
					} else {
						break;
					}
				}
			}else if(d > 0) {
				l = _toArr.length;
				for(i = 0;i < l;i++) {
					s = _stepArray[i + _fromArr.length + 1];
					if(isNaN(s)) {
						break;
					}else if(s > 0) {
						t += randomChar(_characters);
					} else {
						t += _toArr[i];
					}
				}
			}
			s = 0;
			for(i = 0;i < _stepArray.length;i++) {
				if(_stepArray[i] > 0) _stepArray[i]--;
				s += _stepArray[i];
			}
            
			if(_textField) applyText(t);
			if(time >= _time && s == 0) {
				t = _toArr.join("");

				if(_textField) applyText(t);
				// Timer を破棄する
				_destroyTimer();
				super.executeComplete();
			}
		}

		private function getPosition(transition : IEasing, now : Number, from : Number, to : Number, time : Number) : Number {
			var obj : Object = new Object();
			BetweenAS3.tween(obj, {x:to}, {x:from}, time, transition).gotoAndStop(now);
			return obj.x; 
		}

		private function splitText(str : String) : Array {
			var arr : Array = new Array();
			var c : int = str.length;
			for (var i : int = 0;i < c;i++) {
				arr.push(str.substr(i, 1));
			}
			return arr;
		}

		private function applyText(t : String) : void {
			_textField.htmlText = t;
		}

		private static function randomChar(char : String) : String {
			return char.charAt(Math.round(Math.random() * (char.length - 1)));
		}

		/**
		 * 中断されるコマンドの実装です。
		 */
		private function _interruptFunction() : void {
			// Timer を破棄する
			_destroyTimer();
		}

		/**
		 * インスタンスのコピーを作成して、各プロパティの値を元のプロパティの値と一致するように設定します。
		 */
		public override function clone() : Command {
			return new DoTextAnimation(_textField, _fromText, _fromText, this);
		}

		private function _destroyTimer() : void {
			if ( _replaceTimer ) {
				// イベントリスナーを解除する
				_replaceTimer.removeEventListener(TimerEvent.TIMER, onReplaceTimer);
				
				// Timer を破棄する
				_replaceTimer.stop();
				_replaceTimer = null;
			}
		}
	}

