/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vYc1
 */

/*
ステージクリックでパーティクル発生。
今のところインスタンスが増えると描画処理に負荷がかかったり
メモリ使用量が増大するのでクリックしすぎに注意。
*/
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.DisplayObject;
    
    [SWF(width="465", height="465", backgroundColor="#FFFFFF", frameRate="30")]
    
    public class Main extends Sprite{
        
        private var _incidence:uint

        public function Main() {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, go)
            trace(0xC00000)
        }
        
        private function go(e:MouseEvent):void{
            _incidence = Math.floor(Math.random()*20+10)
            for(var i:int=0;i<_incidence;i++){
                var n:int = Math.floor(Math.random()*49+1)
                var n2:Number = Math.random()*0.5-0.25
                var n3:Number = Math.random()*100-50
                var _circle:Circle = new Circle(n, n2, Math.floor(Math.random()*2))
                addChild(_circle)
                _circle.x = mouseX+Math.floor(Math.random()*(n3*10)-(n3*5))
                _circle.y = mouseY+Math.floor(Math.random()*(n3*10)-(n3*5))
                _circle.cacheAsBitmap = true
                _circle.addEventListener(Event.ENTER_FRAME, _circle.drop)
                _circle.addEventListener(Circle.LIFE_END, removed)               
            }
        }
        
        private function removed(e:Event):void{
            e.target.removeEventListener(Event.ENTER_FRAME, e.target.drop)
            e.target.removeEventListener(Circle.LIFE_END, removed)
            removeChild(e.target as DisplayObject)
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.ColorTransform;

class Circle extends Sprite{
    
    private var _size:int
    private var _speed:Number
    private var _v:Point = new Point(0,0)
    private var _k:Number = 0.95
    private var _ground:int = 465
    private var _vec:uint
    private var _life:uint = 100
    public static const BASE_COLOR:int = 0xFFFFFF
    public static const LIFE_END:String = "life_end"
    
    public function Circle(size:int, speed:Number, vec:uint=0){
        var newColor:int = BASE_COLOR-(Math.floor(Math.random()*BASE_COLOR))
        var colors:Array = [0xFFFFFF, 0xFFFFFF, newColor];
        var alphas:Array = [0.7,0.3,0.1];
        var ratios:Array = [50, 100, 200];
        graphics.lineStyle(1,0xCCCCCC)
        graphics.beginGradientFill("radial", colors,alphas,ratios, null,"pad","rgb",Math.random()*50)
        graphics.drawCircle(0,0,size);
        graphics.endFill();accessibilityImplementation
        _speed = speed
        _size = size
        _vec = vec
        this.mouseChildren = false
         }
    
    public function drop(e:Event):void{
        var n:Number
        var k:Number = Math.random()*0.14+0.01

        if(_vec==0){
            n = _v.x+e.target.width/200
            _v.x = n
        }else{
            n = _v.x-e.target.width/200
            _v.x = n
        }
        e.target.x += _v.x;  
        e.target.rotation +=10
        _v.y += _speed;  
        if(e.target.y > (_ground-_size) && _v.y > 0 ){ 
            _v.y = -_v.y*_k; 
        }else if(e.target.y < _size && _v.y < (_ground-_size) ){ 
            _v.y = -_v.y*_k;
        }else if(e.target.x > (_ground-_size) && _v.x > 0 ){ 
            _v.x = -_v.x*_k;  
        }else if(e.target.x < _size && _v.x < (_ground+_size) ){ 
            _v.x = -_v.x*_k;  
        }
        e.target.y += _v.y; 
        //
        if(_life<=0){
            e.target.addEventListener(Event.ENTER_FRAME,death)
        }
        _life--
    }
    
    private function death(e:Event):void{
        if(e.target.width >= 0.1){
           e.target.scaleX-=0.02
           e.target.scaleY-=0.02
        }else{
            e.target.removeEventListener(Event.ENTER_FRAME, drop)
            e.target.removeEventListener(Event.ENTER_FRAME,death)
            dispatchEvent(new Event(Circle.LIFE_END))
        }
    }
}