/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vXXl
 */

// forked from s8t1h12akj's forked from: forked from: Ice Storm - prototype
// forked from s8t1h12akj's forked from: Ice Storm - prototype
// forked from smirnov48's Ice Storm - prototype
// It is based on greentec's Diffusion-Limited Aggregation
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.utils.getTimer;

    public class FlashTest extends Sprite {
        private var _bitmap:Bitmap;
        private var _bitmapData:BitmapData;
        private var _baseBitmap:Bitmap;
        private var _baseBitmapData:BitmapData;
        private var hitBitmapData:BitmapData;
        private var particleNum:int = 10000;
        private var particles:Vector.<Particle> = new Vector.<Particle>();

        private var tx:Number = 0;
        private var ty:Number = 0;
        private var i:int = 0;
        private var j:int = 0;
        private var n:int = 0;
        private var p:Particle;

        private var debug:TextField = new TextField();
        private var base:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(468, true);

        private var time:uint = 0;
        private var iq:int = 0;
        private var circleTime:int = 0;        
        private var angle:Number = 0.0;

        private var start:Boolean = false;

        public function FlashTest() {
            for (i = 0; i < 468; i++) {
                base[i] = new Vector.<int>(468, true);
            }

            for (i = 0; i < 3; i++) {
                base[232 + i][232 + 0] = 1;
                base[232 + i][232 + 1] = 1;
                base[232 + i][232 + 2] = 1;
            }

            base[232 + 1][232 - 1] = 1;
            base[232 + 1][232 + 3] = 1;
            base[232 - 1][232 + 1] = 1;
            base[232 + 3][232 + 1] = 1;
            base[232 + 1][232 + 1] = 2;

            _bitmapData = new BitmapData(465, 465, true, 0xff292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);

            _baseBitmapData = new BitmapData(465, 465, true, 0x00ffffff);
            _baseBitmap = new Bitmap(_baseBitmapData);
            addChild(_baseBitmap);

            initParticles();

            debug.textColor = 0xFF0000;
            debug.text = "クリックして：あき爺";
            addChild(debug);

            addEventListener(Event.ENTER_FRAME, onLoop);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }

        private function onClick(e:MouseEvent):void 
        {
            start = true;
            debug.text = "";
        }    

        private function onLoop(e:Event):void {
            _bitmapData.fillRect(_bitmapData.rect, 0xff292929);

            var myMatrix:Matrix = new Matrix();
            myMatrix.scale(4, 4);
            myMatrix.translate( -930, -930); 
            myMatrix.rotate(angle); 
            angle += 0.01;
            myMatrix.translate(stage.stageWidth / 2, stage.stageHeight / 2); 
            _baseBitmap.transform.matrix = myMatrix;  
            _bitmap.transform.matrix = myMatrix;  

            i = 0;
            while (i < particleNum) {
                p = particles[i];
                if (p.frozen) {
                    i++;
                    continue;
                }

                if (!start) { 
                    if (Math.sqrt(Math.abs(p.x - 232) * Math.abs(p.x - 232) + Math.abs(p.y - 232) * Math.abs(p.y - 232)) < stage.stageWidth / 12) {
                        if (Math.random() < .5)    {
                            p.x = Math.random() * 465;
                            p.y = Math.random() < .5 ? 0 : 465;
                        } else {
                            p.x = Math.random() < .5 ? 0 : 465;
                            p.y = Math.random() * 465;
                        }
                    }
                }

                tx = Math.round(p.x);
                ty = Math.round(p.y);

                if (
                    base[tx + 0][ty + 0] || base[tx + 0][ty + 1] || base[tx + 0][ty + 2] ||
                    base[tx + 1][ty + 0] || base[tx + 1][ty + 1] ||    base[tx + 1][ty + 2] ||
                    base[tx + 2][ty + 0] ||    base[tx + 2][ty + 1] ||    base[tx + 2][ty + 2]
                   )
                {
                    base[tx + 1][ty + 1] = 4;
                    p.frozen = true;
                } else {
                    p.vx += Math.random() * .05 - .025;
                    p.vy += Math.random() * .05 - .025;
                    p.x += p.vx;
                    p.y += p.vy;

                    if (p.x > 465) {
                        p.x -= 465;
                    } else if (p.x < 0)    {
                        p.x += 465;
                    }

                    if (p.y > 465) {
                        p.y -= 465;
                    } else if (p.y < 0) {
                        p.y += 465;
                    }
                    _bitmapData.setPixel32(p.x, p.y, 0x20ffffff);
                }
                i++;
            }

            draw();
        }

        private function draw():void {
            for (var i:int = 1; i < 466; i++) {
                for (var j:int = 1; j < 466; j++) {
                    if (base[i][j] == 1) {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xffA0A0A0);
                    }
                    if (base[i][j] == 2) {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xff00FF00);
                    }
                    if (base[i][j] == 4) {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xff00ffff);
                    }
                }
            }
        }

        private function initParticles():void {
            var p:Particle;
            for (i = 0; i < particleNum; i += 1)
            {
                p = new Particle(Math.random() * 465, Math.random() * 465);
                particles.push(p);
            }
        }
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var frozen:Boolean;

    public function Particle(x:Number, y:Number) {
        this.x = x;
        this.y = y;
        this.vx = Math.random() * .1 - .05;
        this.vy = Math.random() * .1 - .05;
    }
}