/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vXJp
 */

package {
    import flash.events.Event;
    import flash.display.MovieClip;
   import flash.display.Sprite;
   import flash.text.*;
   import net.hires.debug.Stats;//デバック用
   import org.libspark.betweenas3.BetweenAS3;
   import org.libspark.betweenas3.tweens.ITween;
   
   import com.actionsnippet.qbox.*;
   public class HelloWorld extends MovieClip {

        private var contact:QuickContacts;       
       
       public function HelloWorld() {
           
           addChild(new Stats());//デバック用
           
           var tf:TextField = new TextField;
           addChild(tf);
           tf.text = "ok";
           
           
           
           //デバックモード
           //var sim:QuickBox2D = new QuickBox2D(this,{debug:true});
           //重力を設定
           var sim:QuickBox2D = new QuickBox2D(this,{gravity:50});
           //デフォルト値を設定
           sim.setDefault({fillColor:0x00cc22,lineAlpha:0,width:2});
           
           stage.frameRate = 60;
           sim.createStageWalls();
           
           contact = sim.addContactListener();
           contact.addEventListener(QuickContacts.ADD,onContact);
           
           
           sim.addBox({x:5,y:5,width:5,height:1,
           isBullet:true,//高度な衝突判定
           fillColor:0xff0000,
           fillAlpah:.5//透明度
           })
           //幅のを設定しない(デフォルト値になる)
           sim.addBox({x:5,y:5,height:1,isBullet:true});
           
           //静的オブジェクト
           sim.addBox({x:5,y:5,width:5,height:1,
           angle:0.5,
           isBullet:true,
           density:0//密度を0にして、静的オブジェクトにする
           });
           //sim.addCircle({x:4,y:8,radius:2});//円を描く
           
           sim.start();
           sim.mouseDrag();
           
       }
       
      private function onContact(e:Event):void{
           var rect:Sprite = new Sprite();
           rect.graphics.beginFill(0xff00ff);
           rect.graphics.drawRect(0,0,10,10);
           rect.graphics.endFill();
           //衝突したポイントを取得
           //１mが３０pxなので、３０をかけてあげる。
           rect.x = contact.currentPoint.position.x*30;
           rect.y = contact.currentPoint.position.y*30;
           addChild(rect);
           
           //力の取得
           var stl:Number = contact.currentPoint.velocity.Length()/5;
          // rect.scaleX = stl;
          // rect.scaleY = stl;
           var fadeTween:ITween = BetweenAS3.tween(rect, { scaleX:stl,scaleY:stl,
           x:rect.x - rect.width/2,
           y:rect.y - rect.height/2,
           alpha:0 } );
           fadeTween.play();
           fadeTween.onComplete = fadeComplete;
           fadeTween.onCompleteParams = [rect];
           
       }
       private function fadeComplete(obj:Object):void{
           obj.visible = false;
       }

       
       
       
       
   }
}
