/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vXEk
 */

// forked from checkmate's Saqoosha challenge for professionals
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.parsers.Collada;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.lights.PointLight3D;
    import flash.utils.getTimer;
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0x000000")]
    public class Main extends BasicView{
        private var collada:Collada;
        private var light:PointLight3D;
        public function Main():void {
            super(0, 0, true, false);
            init();
        }
        private function init():void {
            light = new PointLight3D(false);
            light.z = 0;
            light.x = 1000;
            light.y = 1000;
            var material:FlatShadeMaterial = new FlatShadeMaterial(light,0xFFFFFF,0x666666);
            camera.y = 3000;
            camera.z = 6000;
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial( material , "jat");
            collada = new Collada("http://www.k3lab.com/wonderfl/omp/ja.dae", materialsList, .11);
            scene.addChild(collada);
            startRendering(); 	
        }
        override protected function onRenderTick(event:Event = null):void {
            collada.rotationY += (stage.mouseX - (stage.stageWidth/2))/80
            collada.rotationX += (stage.mouseY - (stage.stageHeight / 2)) / 80
            var t:Number = getTimer(); 
            camera.z = Math.sin(t * 0.09) * 400 +600;
            super.onRenderTick(event); 
        }
    }
}