/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vWM7
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	/**
	 * Main
 	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var balls:Array;
		private var numBalls:uint = 8;
		private var bounce:Number = -1.0;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期設定.
		 */
		private function init():void
		{			
			balls = new Array();
			//numBallsの数だけボール生成
			for(var i:uint = 0; i < numBalls; i++)
			{
				var radius:Number = Math.random() * 20 + 20;
				var ball:Ball = new Ball(radius);
				ball.mass = radius;
				ball.x = i * 100
				ball.y = i * 50;
				ball.vx = Math.random() * 10 - 5;
				ball.vy = Math.random() * 10 - 5;
				addChild(ball);
				balls.push(ball);
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			for(var i:uint = 0; i < numBalls; i++)
			{
				var ball:Ball = balls[i];
				//加速
				ball.x += ball.vx;
				ball.y += ball.vy;
				//壁の接触判定
				checkWalls(ball);
			}
			for(i = 0; i < numBalls - 1; i++)
			{
				var ballA:Ball = balls[i];
				for(var j:Number = i + 1; j < numBalls; j++)
				{
					var ballB:Ball = balls[j];
					//衝突判定
					checkCollision(ballA, ballB);
				}
			}
		}
		/**
		 * 壁の接触判定.
		 * @param ball 判定するボール
		 */
		private function checkWalls(ball:Ball):void
		{
			if(ball.x + ball.radius > stage.stageWidth)
			{
				ball.x = stage.stageWidth - ball.radius;
				ball.vx *= bounce;
			}
			else if(ball.x - ball.radius < 0)
			{
				ball.x = ball.radius;
				ball.vx *= bounce;
			}
			if(ball.y + ball.radius > stage.stageHeight)
			{
				ball.y = stage.stageHeight - ball.radius;
				ball.vy *= bounce;
			}
			else if(ball.y - ball.radius < 0)
			{
				ball.y = ball.radius;
				ball.vy *= bounce;
			}
		}
		/**
		 * 衝突判定.
		 * @param ball0　ボール0
		 * @param ball1　ボール1
		 */
		private function checkCollision(ball0:Ball, ball1:Ball):void
		{
			var dx:Number = ball1.x - ball0.x;
			var dy:Number = ball1.y - ball0.y;
			//ボール間の距離
			var dist:Number = Math.sqrt(dx * dx + dy * dy);
			//ボールの半径の合計より、ボール間の距離が短かったら
			if(dist < ball0.radius + ball1.radius)
			{
				// 角度
				var angle:Number = Math.atan2(dy, dx);
				//sin
				var sin:Number = Math.sin(angle);
				//cos
				var cos:Number = Math.cos(angle);
				
				// rotate ball0's position
				var pos0:Point = new Point(0, 0);
				
				// 座標を回転
				var pos1:Point = rotate(dx, dy, sin, cos, true);
				var vel0:Point = rotate(ball0.vx,
										ball0.vy,
										sin,
										cos,
										true);
				
				// 加速ベクトルを回転
				var vel1:Point = rotate(ball1.vx,
										ball1.vy,
										sin,
										cos,
										true);
				//
				var vxTotal:Number = vel0.x - vel1.x
				//運動量保存の法則
				vel0.x = ((ball0.mass - ball1.mass) * vel0.x + 
				          2 * ball1.mass * vel1.x) / 
				          (ball0.mass + ball1.mass);
				vel1.x = vxTotal + vel0.x;
				// 座標をボールに適応
				pos0.x += vel0.x;
				pos1.x += vel1.x;
				// 回転座標を戻す
				var pos0F:Object = rotate(pos0.x,
										  pos0.y,
										  sin,
										  cos,
										  false);
										  
				var pos1F:Object = rotate(pos1.x,
										  pos1.y,
										  sin,
										  cos,
										  false);
				// 正規の座標に適応
				ball1.x = ball0.x + pos1F.x;
				ball1.y = ball0.y + pos1F.y;
				ball0.x = ball0.x + pos0F.x;
				ball0.y = ball0.y + pos0F.y;
				
				// // 回転加速度ベクトルを戻す
				var vel0F:Object = rotate(vel0.x,
										  vel0.y,
										  sin,
										  cos,
										  false);
				var vel1F:Object = rotate(vel1.x,
										  vel1.y,
										  sin,
										  cos,
										  false);
				// 正規の加速度に適応
				ball0.vx = vel0F.x;
				ball0.vy = vel0F.y;
				ball1.vx = vel1F.x;
				ball1.vy = vel1F.y;
			}
		}
		/**
		 * 回転座標を返す.
		 * @param x x座標
		 * @param y y座標
		 * @param sin sin
		 * @param cos cos
		 * @param reverse 負の角度
		 */
		private function rotate(x:Number,
								y:Number,
								sin:Number,
								cos:Number,
								reverse:Boolean):Point
		{
			var result:Point = new Point();
			if(reverse)
			{
				result.x = x * cos + y * sin;
				result.y = y * cos - x * sin;
			}
			else
			{
				result.x = x * cos - y * sin;
				result.y = y * cos + x * sin;
			}
			return result;
		}		
	}
}
/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var mass:Number = 1;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}