/**
 * Copyright yasohachi ( http://wonderfl.net/user/yasohachi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vVhD
 */

/**
 *	XMLからBetweenAS3の設定
 *	あとでserial・parallelにも対応させてみよう。
 */

package {
    import flash.display.Sprite;
    [SWF(backgroundColor="#000000")]
    public class XMLTween extends Sprite {
    		public var xml:XML = 
    			<tweens>
				<tween>
					<start><$x>200</$x><$y>-200</$y></start>
					<end><$x>-200</$x><$y>200</$y></end>
					<time>3</time>
					<easing>Bounce.easeOut</easing>
				</tween>
			</tweens>
		
        public function XMLTween() {
            // write as3 code here..
            var box:Box = new Box();
            box.x = 230;
            box.y = 230;
            this.addChild(box);
            var xmlc:XMLCommand = new XMLCommand(xml,box);
            xmlc.tweens.stopOnComplete = false;
            xmlc.tweens.play();
        }
    }
}

import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.core.easing.IEasing;

class XMLCommand{
	public var tweens:ITween;
	public function XMLCommand(xml:XML,target:Object){
		tweens = makeTweens(xml,target);
	}
	
	private function makeTweens(xml:XML,target:Object):ITween{
		var it:ITween;
		it = makeTween(xml.tween[0],target);
		
		return it;
	}
	
	private function makeTween(xml:XML,target:Object):ITween{
		var strObj:Object = null;
		var endObj:Object = null;
		var easing:IEasing = null;
		var time:Number = 1.0;
		if(xml.hasOwnProperty("start")){
			strObj = makeStatus(xml.start[0]);
		}
		if(xml.hasOwnProperty("end")){
			endObj = makeStatus(xml.end[0]);
		}
		if(xml.hasOwnProperty("time")){
			time = Number(xml.time[0]);
		}
		if(xml.hasOwnProperty("easing")){
			easing = makeEasing(xml.easing[0]);
		}
		
		return BetweenAS3.tween(target,endObj,strObj,time,easing);
	}
	
	private function makeStatus(xml:XML):Object{
		var list:XMLList = xml.children();
		var obj:Object = {};
		var node:XML;
		for each(node in list){
			var prop:String = node.name().localName;
			obj[prop] = Number(node.toString());
		}
		
		return obj;
	}
	
	private function makeEasing(xml:XML):IEasing{
		var str:Array = xml.toString().split(".");
		var type:String = str[0];
		var easing:String = str[1];
		var eClass:Class;
		switch(type){
			case "Back":
				eClass = Back;
				break;
			case "Bounce":
				eClass = Bounce;
				break;
			case "Circ":
				eClass = Circ;
				break;
			case "Circular":
				eClass = Circular;
				break;
			case "Elastic":
				eClass = Elastic;
				break;
			case "Expo":
				eClass = Expo;
				break;
			case "Exponential":
				eClass = Exponential;
				break;
			case "Linear":
				eClass = Linear;
				break;
			case "Physical":
				eClass = Physical;
				break;
			case "Quad":
				eClass = Quad;
				break;
			case "Quadratic":
				eClass = Quadratic;
				break;
			case "Quart":
				eClass = Quart;
				break;
			case "Quartic":
				eClass = Quartic;
				break;
			case "Quint":
				eClass = Quint;
				break;
			case "Quintic":
				eClass = Quintic;
				break;
			case "Sine":
				eClass = Sine;
				break;
			default:
				eClass = Bounce;
		}
		
		return eClass[easing];
	}
}

import flash.display.Sprite;
class Box extends Sprite
{
	public function Box():void{
		
		var r:uint = randomUint();
		var g:uint = randomUint();
		var b:uint = randomUint();
		var color:uint = (r << 16) | (g << 8) | b;
		this.graphics.beginFill(color);
		this.graphics.drawRect(-10,-10,20,20);
		this.graphics.endFill();
	}
	
	private function randomUint():uint{
		var num:uint = 0x80 + int(Math.random()*1000) % 0x80;
		
		return num;
	}
}