/**
 * Copyright azuremous ( http://wonderfl.net/user/azuremous )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vV7Y
 */

 //forked from ta6b's Flashで作る3Dのお勉強6
//Flashで作る3Dのお勉強6
//Point3Dの作成と適用。
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
     [SWF(width=465, height=465, frameRate=60)]
    public class Lines3D2 extends Sprite 
    {
        private var points:Array;
        private var numPoints:uint = 1000;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        
        private var gainer:Gainer;
        
        public function Lines3D2() {
         ////////////////////////////////////////////////////////setting
        	gainer =new Gainer();
        	var smoother:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
        	var smoother1:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
            var smoother2:Convolution = new Convolution(Convolution.MOVING_AVERAGE);
        	var scaler:Scaler = new Scaler(0.01,0.99,0,465,Scaler.LINEAR, true);
            var scaler1:Scaler = new Scaler(0.25,0.65,50,465,Scaler.LINEAR, true);
        	gainer.analogInput(0).filters= [smoother,scaler1];
        	gainer.analogInput(1).filters =[smoother1,scaler];
            gainer.analogInput(2).filters =[smoother2, scaler]; 
         ///////////////////////////////////////////////////////
            init();
            
        }
        
        private function init():void {
            points = new Array();
            for (var i:uint = 0; i < numPoints; i++) {
                var point:Point3D = new Point3D(Math.random() * 200 - 100, Math.random() * 200 - 100, Math.random() * 200 - 100);
                
                point.setVanishingPoint(vpX, vpY);
                points.push(point);
                
            }
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void {
            var moveX:Number = gainer.analogInput(1).value;
            var moveY:Number = gainer.analogInput(2).value;
            var angleX:Number = (moveX - vpY) * .001;
            var angleY:Number = (moveY - vpX) * .001;
            
            for (var i:uint = 0; i < numPoints; i++) {
                var point:Point3D = points[i];
                point.rotateX(angleX);
                point.rotateY(angleY);
            }
            
            graphics.clear();
            graphics.lineStyle(0);
            graphics.moveTo(points[0].screenX, points[0].screenY);
            for (i = 1; i < numPoints; i++) {
                graphics.lineTo(points[i].screenX, points[i].screenY);
            }
        }
    }
    
}
	
	
internal class Point3D 
    {   
      
        public var fl:Number = 250;
        private var vpX:Number = 0;
        private var vpY:Number = 0;
        private var cX:Number = 0;
        private var cY:Number = 0;
        private var cZ:Number = 0;
        private var x:Number = 0;
        private var y:Number = 0;
        private var z:Number = 0;
      
       
      
        	
        	
        	
           
        
        public function Point3D(x:Number = 0, y:Number = 0, z:Number = 0) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
        
        public function setVanishingPoint(vpX:Number, vpY:Number):void {
            this.vpX = vpX;
            this.vpY = vpY;
        }
        
        public function setCenter(cX:Number, cY:Number, cZ:Number = 0):void {
            this.cX = cX;
            this.cY = cY;
            this.cZ = cZ;
        }
        
        public function get screenX():Number {
        	
        	
            var scale:Number = fl / (fl + z + cZ);
            return vpX + cX + x * scale;
        }
        
        public function get screenY():Number {
        	
        
            var scale:Number = fl / (fl + z + cZ);
            return vpY + cY + y * scale;
        }
        
        public function rotateX(angleX:Number):void {
            var cosX:Number = Math.cos(angleX);
            var sinX:Number = Math.sin(angleX);
            
            var y1:Number = y * cosX - z * sinX;
            var z1:Number = z * cosX + y * sinX;
            
            y = y1;
            z = z1;
        }
        
        public function rotateY(angleY:Number):void {
            var cosY:Number = Math.cos(angleY);
            var sinY:Number = Math.sin(angleY);
            
            var x1:Number = x * cosY - z * sinY;
            var z1:Number = z * cosY + x * sinY;
            
            x = x1;
            z = z1;
        }
        
        public function rotateZ(angleZ:Number):void {
            var cosZ:Number = Math.cos(angleZ);
            var sinZ:Number = Math.sin(angleZ);
            
            var x1:Number = x * cosZ - y * sinZ;
            var y1:Number = y * cosZ + x * sinZ;
            
            x = x1;
            y = y1;
        }
    }