/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vV3w
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;

	[SWF(width="465", height="465", backgroundColor= 0xffffff, frameRate="60")]

/*
Spore API
http://www.spore.com/comm/developer/flash
*/
	public class SporeFilms
	extends Sprite
	{
		// our search types:
		public var mQueries:Array = new Array("FEATURED", "RANDOM", "TOP_RATED", "TOP_RATED_NEW", "NEWEST", "CUTE_AND_CREEPY", "MAXIS_MADE");
		// a loader for the query
		public var mLoader:URLLoader;
		
		public var mServerString:String = "http://www.spore.com";
		public var mCurrentQueryString:String = "";
		public var mCurrentQuery:Number = Math.floor(Math.random()*mQueries.length);
		public var mStartIndex:Number = 0;
		public var mCount:Number = 60;
		
		private var slide:Slide;
		public function SporeFilms():void 
		{
			slide = new Slide();
			addChild(slide);
			slide.x = slide.y = 16;
			slide.maxWidth = stage.stageWidth - 50;
			slide.cellSize = 48;
			
			// initiate the query
			mLoader = new URLLoader();
			mLoader.addEventListener(Event.COMPLETE, GotData);

			GetSpecialFeed(mQueries[mCurrentQuery], mStartIndex, mCount); 
		}
		public function GetSpecialFeed(feed:String, startIndex:Number, numAssets:Number):void
		{
			var queryString:String = mServerString + "/rest/assets/search/" + feed + "/" + startIndex + "/" + numAssets;
			mLoader.load(new URLRequest(queryString));			
		}
		public function GotData(e:Event):void
		{
			var dataXML:XML = new XML(e.target.data);
			
			// Parse the XML
			namespace atomenv = "http://www.w3.org/2005/Atom";
			use namespace atomenv;
			
			var counter:Number = 0;
			for each (var asset:XML in dataXML..asset)
			{
				var id:String = asset..id.toString();
				GetSmallPNG(id, counter);
				counter++;
				if(counter == mCount)
				{
					break;
				}
			}
//			mStatusText.text = "Loaded query: " + mCurrentQueryString;
			
		}		
		
		public function GetSmallPNG(assetId:String, counter:Number):void
		{
			var subId1:String = assetId.substr(0,3);
			var subId2:String = assetId.substr(3,3);
			var subId3:String = assetId.substr(6,3);
			var smallPNGURL:String = "http://www.spore.com/static/thumb/" + subId1 + "/" + subId2 + "/" + subId3 + "/" + assetId + ".png"
			
			slide.addImg(smallPNGURL, counter);
		}
	}
}
	
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.display.Sprite
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import caurina.transitions.Tweener;
import flash.net.URLRequest;
import flash.events.Event;
import flash.system.LoaderContext;
import flash.geom.Rectangle;

class Slide
extends Sprite 
{
	private var imgArray:Array = new Array();
	private var imgContainer:Sprite = new Sprite();
	private var minSpan:Number = 2;
	
	public var cellSizeMin:Number = 4;
	public var cellSizeMax:Number = 72;
	public var cellSize:Number = 48;
	public var maxWidth:Number = 400;
	

	public function Slide():void 
	{		
		addEventListener(Event.ADDED_TO_STAGE, init);
	}
	private function init(e:Event):void 
	{
		removeEventListener(Event.ADDED_TO_STAGE, init);
		
		//imgcontainer
		addChild(imgContainer);
		
		//evt
		stage.addEventListener(MouseEvent.MOUSE_WHEEL, wheelHandler);
	}
	public function addImg(url:String, num:uint):void 
	{
		var cell:ImgCell = new ImgCell(url,num);
		cell.orderNum = num;
		cell.x = Math.random() * maxWidth;
		cell.y = stage.stageHeight -Math.random() * 100 - 50;
		imgContainer.addChild(cell);
		cell.addEventListener("loaded", cellLoadCompleteHandler,false,0,true);
	}
	private function cellLoadCompleteHandler(e:Event):void 
	{
		var cell:ImgCell = e.target as ImgCell;
		cell.removeEventListener("loaded", cellLoadCompleteHandler);
		cell.addEventListener("appeared", cellAppearCompleteHandler, false, 0, true);
	}
	private function cellAppearCompleteHandler(e:Event):void 
	{
		var cell:ImgCell = e.target as ImgCell;
		cell.removeEventListener("appeared", cellLoadCompleteHandler);
		
		cell.addEventListener(MouseEvent.ROLL_OVER, cellRollOverHandler,false,0,true);
		cell.addEventListener(MouseEvent.ROLL_OUT, cellRollOutHandler,false,0,true);

		imgArray.push(cell);
		imgArray.sortOn("orderNum", Array.NUMERIC);
		locateCells();
	}

	private function cellRollOverHandler(e:MouseEvent):void 
	{
		var cell:ImgCell = e.target as ImgCell;
		imgContainer.setChildIndex(cell, imgContainer.numChildren - 1);
		cell.focusIn();
	}
	private function cellRollOutHandler(e:MouseEvent):void 
	{
		var cell:ImgCell = e.target as ImgCell;
		cell.focusOut();
	}
	private function locateCells():void 
	{
		var imgWidth:Number = cellSize;
		var imgHeight:Number = cellSize;
		
		var colNum:uint = Math.floor(maxWidth/ (imgWidth + minSpan));
		if (1 > colNum)
		{
			colNum = 1;
			imgWidth = maxWidth - minSpan;
		}			
		var colSpan:Number = (maxWidth - imgWidth * colNum) / colNum + imgWidth;
		
		var i:uint = imgArray.length;
		while (0 < i--)
		{
			var img:ImgCell = imgArray[i] as ImgCell;
			
			var targetX:Number = (i % colNum) * colSpan;
			var targetY:Number = Math.floor(Number(i) / Number(colNum)) * colSpan;
			
			if (
			5 < Math.abs(img.baseRect.x - targetX) 
			|| 5 < Math.abs(img.baseRect.y - targetY) 
			|| 5 < Math.abs(img.baseRect.width - imgWidth)
			|| 5 < Math.abs(img.baseRect.height - imgHeight)
			)
			{
				img.baseRect = new Rectangle(
					targetX,
					targetY,
					imgWidth,
					imgHeight
				);				
				
				var rand:Number = (1 + Math.random() * 0.8);
				img.targetRect = new Rectangle(
					targetX + Math.random() * imgWidth * 0.5,
					targetY + Math.random() * imgWidth * 0.5,
					imgWidth * rand,
					imgHeight * rand
				);
				if(!img.isMouseOver)img.moveToTarget();
			}
		}

	}
	private function wheelHandler(e:MouseEvent):void 
	{
		cellSize = Math.max(cellSizeMin, Math.min(cellSizeMax, (cellSize + e.delta*1)));
		locateCells();
	}
}

import flash.display.GradientType;
import flash.geom.Matrix;
class ImgCell
extends Sprite
{
	private var container:Sprite = new Sprite();
	private var bg:Sprite = new Sprite();
	private var img:Loader;
		
	public var orderNum:uint;
	
	
	public var baseRect:Rectangle;
	public var targetRect:Rectangle;
	public var isMouseOver:Boolean = false;
	private var inCount:uint = 0;

	
	public function ImgCell(url:String, num:uint):void 
	{
		orderNum = num;

		//
		visible = false;
		mouseChildren = false;
		//container
		bg.graphics.beginFill(0xFFFFFF);
		bg.graphics.drawRect(0, 0, 50, 50);
		var mtr:Matrix = new Matrix();
		mtr.createGradientBox(60, 60, (Math.random() *1 + 1) * Math.PI/3 );
		bg.graphics.beginGradientFill(
			GradientType.LINEAR, 
			[RGB2int(Math.random() * 0.5 + 0.5, Math.random() * 0.5 + 0.5, Math.random() * 0.5 + 0.5),
			RGB2int(Math.random()*0.4+0.0, Math.random()*0.4+0.0, Math.random()*0.4+0.0)], 
			[1,1],
			[0, 255],
			mtr
		);
		bg.graphics.drawRect(2.5, 2.5, 45, 45);
		filters = [new DropShadowFilter(6.0,45,0,0.50), new GlowFilter(0x999999)];
		
		container.addChild(bg);
		addChild(container);
		
		//loader
		img = new Loader();
		img.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);
		img.load(new URLRequest(url));
	}
	private function RGB2int(r:Number, g:Number, b:Number):uint
	{
		var i:uint;
		i += r*255;
		i <<= 8;
		i += g*255;
		i <<= 8;
		i += b * 255;
		return i;
	}
	private function loadCompleteHandler(e:Event):void 
	{		
		if (img.height > img.width)
		{
			img.height = bg.height * 0.9;
			img.scaleX = img.scaleY;
		}
		else
		{
			img.width = bg.width * 0.9;
			img.scaleY = img.scaleX;
		}
		img.x = (bg.width - img.width) / 2
		img.y = (bg.height - img.height) / 2
		container.addChild(img);
		
		//
		visible = true;
		dispatchEvent(new Event("loaded"));		

		
		var size:Number = 100 + Math.random() * 50;
		rotation = Math.random() * 360;
		Tweener.addTween(this, {
			x: x - size / 2,
			y: y - size / 2,
			width: size,
			height: size,
			rotation: -10,
			time: 0.1 + Math.random()*0.2,
			transition: "easeInQuint",
			onComplete: appearCompleteHandler,
			onUpdate: resizeFilter
		});
	}
	private function appearCompleteHandler():void 
	{
		targetRect = baseRect = new Rectangle(x, y, width, height);
		dispatchEvent(new Event("appeared"));		
	}
	public function focusIn():void 
	{
		isMouseOver = true;
		Tweener.removeTweens(this);

		var mul:Number = 2.0;
		x = x + width/2 - targetRect.width * mul /2;
		y =  y + height/2 - targetRect.height * mul /2;
		width = targetRect.width * mul;
		height = targetRect.height * mul;
		rotation = 0;
		resizeFilter();
	}
	public function focusOut():void 
	{
		isMouseOver = false;
		moveToTarget();		
	}
	public function moveToTarget():void 
	{
		Tweener.addTween(this, {
			x: targetRect.x,
			y: targetRect.y,
			width: targetRect.width,
			height: targetRect.height,
			rotation: -5 - Math.random() * 30,
			time: 0.2 + Math.random() * 0.8, 
			transition: "easeOutCubic", 
			onUpdate: resizeFilter,
			onComplete: moveCompleteHandler
		});
	}
	private function moveCompleteHandler():void 
	{
		dispatchEvent(new Event("moveComplete"));
	}
	private function resizeFilter():void 
	{
		filters = [
			new DropShadowFilter(width * 0.05, 45, 0, 0.30, width * 0.15, height * 0.15), 
			new GlowFilter(0xCCCCCC, 1.0, width * 0.04, height * 0.04)
		];
	}

}