/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vTl1
 */

package {
    import flash.text.TextField;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    import alternativ7.engine3d.containers.*;
    import alternativ7.engine3d.core.*;
    import alternativ7.engine3d.objects.*;
    import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.primitives.*;
    import alternativ7.engine3d.materials.*;
    import alternativ7.*;
    import alternativ7.engine3d.lights.*;
    
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
    
        public var cam:Camera3D;
        public var cont:ConflictContainer;
        public var mat:TextureMaterial;
        public var msh:Box;
        
        public var bm:BitmapData;
    
        public var deb:Box;
        public var deb2:Box;
        
        public var dt:TextField;
    
        public function FlashTest() {
            // write as3 code here..
            
             cont = new ConflictContainer();
             cam = new Camera3D();
             cam.view = new View(400,400);
             cam.z = -100;
             addChild(cam.view);
             cont.addChild(cam);
             
             dt = new TextField();
             dt.width = 400;
             dt.multiline = true;
             dt.mouseEnabled = false;
             dt.mouseWheelEnabled = false;
             addChild(dt);
             
             bm = new BitmapData(64,64,false,0);
             bm.noise(2);
             
               msh = new Box(100,100,100);
               msh.setMaterialToAllFaces(new TextureMaterial(bm));
            cont.addChild(msh);
            
            msh.z = 200;
            
            deb = new Box(1,1,1);
            deb.setMaterialToAllFaces(new FillMaterial(0xFF0000, 0.5, 1, 0) );
            cont.addChild(deb);
            
            deb2 = new Box(1,1,1);
            deb2.setMaterialToAllFaces(new FillMaterial(0x000000,0.5,1,0) );
            cont.addChild(deb2);
            
            deb2.x += 50;
            
      
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        

        
        public function onEnter(e:Event):void
        {
           var umx:Number;
           var umy:Number;
           
           dt.text = "";
       
           msh.rotationY += 0.004;
           
           umx = ((stage.mouseX / 400)-0.5)*2;
           umy = ((stage.mouseY / 400)-0.5)*2;
           
           calcMouse(umx, umy, 70.0, 1.0, 0.00001, 300.0,
           cam.x,cam.y,cam.z,  0,0,1,  0,1,0,  1,0,0);
           
           deb.x = nmx; deb.y = nmy; deb.z = nmz;
           deb2.x = fmx; deb2.y = fmy; deb2.z = fmz;
           
           
           
           //dt.appendText(" stage w " + stage.width + " h  " + stage.height);
          // dt.appendText("\n mx " + mouseX + "  my  " + mouseY);
          // dt.appendText("\n umx " + umx + "  umy  " + umy);
          // dt.appendText("\n x  "+ nmx + "  y " + nmy + " z  " + nmz);
          // dt.appendText("\n x  "+ fmx + "  y " + fmy + " z  " + fmz);
           
            
            cam.render();
        }//onenter
        
        
        public var nmx:Number=0;
        public var nmy:Number=0;
        public var nmz:Number=0;
        
        public var fmx:Number=0;
        public var fmy:Number=0;
        public var fmz:Number=0;
        
        
        
        public function calcMouse(mx:Number, my:Number,
        fov:Number, aspect:Number, neard:Number, fard:Number,
        posx:Number, posy:Number, posz:Number,
        frontx:Number, fronty:Number, frontz:Number,
        upx:Number, upy:Number, upz:Number,
        sidex:Number, sidey:Number, sidez:Number):void
        {
            var nw:Number;
            var nh:Number;
            var fw:Number;
            var fh:Number;
            var tang:Number;
            
            var fupx:Number, fupy:Number, fupz:Number;
            var fsidex:Number, fsidey:Number, fsidez:Number;
            var nupx:Number, nupy:Number, nupz:Number;
            var nsidex:Number, nsidey:Number, nsidez:Number;
            
            var fcx:Number, fcy:Number, fcz:Number;
            var ncx:Number, ncy:Number, ncz:Number;
            
            fov *= 3.1415 / 180;
            tang = Math.tan ( fov * 0.5 );
            //tang = Math.tan( fov * 0.5);
        //    tang = Math.tan(90);
            //tang  = Math.tan(  (Math.PI/2) * 0.5);
            
           // dt.appendText("\n tang " + tang);            
            
            nh = neard * tang;
            nw = nh * aspect;
            
            fh = fard * tang;
            fw = fh * aspect;
            
            
          //  dt.appendText("\n nw " +nw + " nh " + nh);
         //   dt.appendText("\n fw " +fw + " fh " + fh);
             
            
            fupx = upx * fh;
            fupy = upy * fh;
            fupz = upz * fh;
            
            fsidex = sidex * fw;
            fsidey = sidey * fw;
            fsidez = sidez * fw;
            
            nupx = upx * nh;
            nupy = upy * nh;
            nupz = upz * nh;
            
            nsidex = sidex * nw;
            nsidey = sidey * nw;
            nsidez = sidez * nw;
            
            fcx = posx + frontx * fard;
            fcy = posy + fronty * fard;
            fcz = posz + frontz * fard;
            
            ncx = posx + frontx * neard;
            ncy = posy + fronty * neard;
            ncz = posz + frontz * neard;
            
            nmx = ncx + (nupx*my)+(nsidex*mx);
            nmy = ncy + (nupy*my)+(nsidey*mx); 
            nmz = ncz + (nupz*my)+(nsidez*mx);
            
            fmx = fcx + (fupx*my)+(fsidex*mx);
            fmy = fcy + (fupy*my)+(fsidey*mx);
            fmz = fcz + (fupz*my)+(fsidez*mx);
            
        }//calcmouse
        
        
        
        public function multMatrix(a:Vector.<Number>, b:Vector.<Number>, r:Vector.<Number>):void
        {
            var i:int;          
            for (i = 0; i < 16; i += 4)
            {
                r[i] = a[0] * b[i]  +  a[4] * b[i + 1] + a[8] * b[i + 2] +  a[12] * b[i + 3];
                r[i + 1] = a[1] * b[i] + a[5] * b[i + 1] + a[9] * b[i + 2] + a[13] * b[i + 3];
                r[i + 2] = a[2] * b[i] + a[6] * b[i + 1] + a[10] * b[i + 2] + a[14] * b[i + 3];
                r[i + 3] = a[3] * b[i] + a[7] * b[i + 1] + a[11] * b[i + 2] + a[15] * b[i + 3];
            }//nexti
            
        }//multmat
        
        public function makePersp(mat:Vector.<Number>,
        fov:Number=90.0, aspect:Number=1.0, nearp:Number=1.0, farp:Number = 300.0 ):void
        {
            var i:int;
            var f:Number;
            
            for (i = 0; i < 16; i++)
            { mat[i] = 0; }    
                
            f = 1.0 / Math.tan( (fov*(3.1415/180.0)) *0.5 );
            
            mat[0] = f / aspect;
            mat[5] = f;
            mat[10] = (farp + nearp) / (nearp - farp);
            mat[14] = (2.0 * farp * nearp) / (nearp - farp);
            mat[11] = -1.0;
            mat[15] = 0.0;
    
        }//makepersp
        
        public function makeView(mat:Vector.<Number>,
        sidex:Number, sidey:Number, sidez:Number,
        upx:Number, upy:Number, upz:Number,
        frontx:Number, fronty:Number, frontz:Number,
        posx:Number, posy:Number, posz:Number):void
        {
            mat[0] = mat[5] = mat[10] = mat[15] = 1.0; 

            mat[0] = sidex;
            mat[4] = sidey;
            mat[8] = sidez;
            
            mat[1] = upx;
            mat[5] = upy;
            mat[9] = upz;

            mat[2] = -frontx;
            mat[6] = -fronty;
            mat[10] = -frontz;
            
            mat[12] = (sidex *-posx) + (sidey * -posy) + (sidez * -posz);
            mat[13] = (upx *-posx) + (upy * -posy) + (upz * -posz);
            mat[14] = (-frontx *-posx) + (-fronty * -posy) + (-frontz * -posz);
            
        }//makeview
        
        
        
        
        
        
        
    }//classend
}