/**
 * Copyright rogerluiz ( http://wonderfl.net/user/rogerluiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vTMw
 */

package
{
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import gs.TweenMax;
    import gs.easing.*;
    
    /**
     * InLine
     * 
     * @author    Roger Luiz (rogerluizm.com.br)
     * @size    19.03.2011
     */
    [SWF(backgroundColor="0x000000")]
    public class InLine extends Sprite
    {
        private var _xAxis:Number = 10;
        private var _total:Number = 40;
        private var _totalWidth:Number = (_total-1) * _xAxis;
        private var _mimColor:Number = 0;
        private var _maxColor:Number = 50;
        private var _offset:Number;
        private var _inc:Number = 3;
        private var _colorinc:Number = 4;
        private var _yOscilation:Number = 1;
        private var _mimScale:Number = 0.01;
        private var _maxScale:Number = 0.2;
        
        public function InLine()
        {
            for(var i:int = 0; i < _total; i++)
            {
                var ball:Ball = new Ball();
                ball.y = stage.stageHeight * 0.5;
                ball.x = (stage.stageWidth  - _totalWidth) / 2 + _xAxis * i;
                ball.scaleX = ball.scaleY = _mimScale;
                ball.minScale = _mimScale;
                ball.maxScale = _maxScale;
                addChild(ball);
                //
                ball.addEventListener(Event.ENTER_FRAME, onUpdate);
            }
        }
        
        private function onUpdate(e:Event):void
        {
            TweenMax.to(e.target, .8, {scaleX:Math.random() * (e.target.maxScale - e.target.minScale), 
            onUpdate:updateScale, onUpdateParams:[e.target], ease:Expo.easeOut });
            setBrightness(e.target, Math.random() * 100 - 40, Math.random() * 100 -40, Math.random() * 100-40)
        }

        private function updateScale(target:Object):void
        {
            target.scaleY = target.scaleX;
        }

        protected function setBrightness(target:*, red:Number, green:Number, blue:Number):void
        {
            var color:ColorTransform = new ColorTransform();
            color.redOffset   = red;
            color.greenOffset = green;
            color.blueOffset  = blue;
            //
            target.transform.colorTransform = color;  
        }

    }
}

import flash.display.MovieClip;

class Ball extends MovieClip
{
    private var _ball:MovieClip;
    private var _minScale:Number;
    private var _maxScale:Number;
    private var _degree:Number;
    private var _mimbr:Number;
    private var _maxbr:Number;
    
    public function Ball()
    {
        _ball = new MovieClip();
        _ball.graphics.beginFill(0xff0000);
        _ball.graphics.drawCircle(0, 0, 42);
        _ball.graphics.endFill();
        addChild(_ball);
    }
    
    public function set degree(value:Number):void { _degree = value; }
    public function get degree():Number { return _degree; }
    
    public function set minScale(value:Number):void { _minScale = value; }
    public function get minScale():Number { return _minScale; }
    
    public function set maxScale(value:Number):void { _maxScale = value; }
    public function get maxScale():Number { return _maxScale; }
    
}
