/**
 * Copyright kjkmr ( http://wonderfl.net/user/kjkmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vSFx
 */

package {
    
    /*--------------------------------------------------
    * Arrayは forより、for eachの方が処理速度が早いのに、
    * Vectorは逆にfor each使うと遅くなる。
    * ObjectよりDictionaryの方が、シーケンシャルアクセスが速い
    * for ( key in something )はとても遅い
    * メモリ使用量の取得のしかたをちゃんとわかってない
    --------------------------------------------------*/
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.utils.Dictionary;
    import flash.system.System;
    import flash.text.TextField;
    
    public class Main extends Sprite {
        
        /*--------------------------------------------------
        * プロパティ
        --------------------------------------------------*/
        
        //始めに生成する要素の数
        public static const ITEM_COUNT:uint = 500000;
        
        
        //ENTER_FRAMEで順次実行するファンクション
        private var _funcs:Array = [ _dictionary, _object, _vector, _array ];
        
        //実行結果のテキスト
        private var _resultString:String = "";
        
        //
        private var _text:TextField = new TextField();
        
        /*--------------------------------------------------
        * コンストラクタ
        --------------------------------------------------*/
        public function Main() {
            
            //
            _text.width = stage.stageWidth;
            _text.height = stage.stageHeight;
            _text.text = "しばらくお待ちください。";
            addChild( _text );
            
            //立ち上がりの不安定な状態を避ける
            var timer:Timer = new Timer( 2000, 1 );
            timer.addEventListener( TimerEvent.TIMER_COMPLETE, _init );
            timer.start();
        }
        
        /*--------------------------------------------------
        * TIMERイベントハンドラ
        --------------------------------------------------*/
        private function _init( i_event:TimerEvent ):void {
            i_event.target.removeEventListener( i_event.type, arguments.callee );
            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
            //System.gc();
        }
        
        /*--------------------------------------------------
        * ログ
        --------------------------------------------------*/
        private function _log( i_string:String ):void {
            _resultString = _resultString + i_string + "\n";
        }
        
        
        /*--------------------------------------------------
        * ENTER_FRAMEイベントハンドラ
        --------------------------------------------------*/
        private function _onEnterFrame( i_event:Event ):void {
            if ( !_funcs.length ) {
                i_event.target.removeEventListener( i_event.type, arguments.callee );
                _text.text = _resultString;
                return;
            }
            var f:Function = _funcs.pop();
            f();
            //System.gc();
        }
        
        
        
        
        /*--------------------------------------------------
        * Array
        --------------------------------------------------*/
        private function _array():void {
            var i:uint, j:uint, s:String, n:Number, sum:uint, startTime:Number;
            //var beforeMem:Number = System.totalMemory;
            
            _log( "##### Array #####\n" );
            
            //インスタンス生成
            var array:Array = [];
            
            //-----
            //アイテム追加
            //-----
            startTime = getTimer();
            for ( i=0; i<ITEM_COUNT; i++ ) array.push(i);
            _log( "アイテム追加： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for
            //-----
            startTime = getTimer();
            sum = 0;
            for ( i=0; i<ITEM_COUNT; i++ ) sum += array[i];
            _log( "for ( i=0; i<length; i++ )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for each
            //-----
            startTime = getTimer();
            sum = 0;
            for each ( n in array ) sum += n;
            _log( "for each ( var in array )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for in
            //-----
            startTime = getTimer();
            sum = 0;
            for( s in array ) sum += array[s];
            _log( "for ( key in array )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //使用メモリ
            //-----
            //var mem:Number = ( System.totalMemory - beforeMem ) / 1024 / 1024;
            //_log( "メモリ： " + mem + "MB\n" );
            _log("");
        }
        
        /*--------------------------------------------------
        * Vector
        --------------------------------------------------*/
        private function _vector():void {
            var i:uint, j:uint, s:String, n:Number, sum:uint, startTime:Number;
            //var beforeMem:Number = System.totalMemory;
            
            _log( "##### Vector #####\n" );
            
            //インスタンス生成
            var vector:Vector.<Number> = new Vector.<Number>();
            
            //-----
            //アイテム追加
            //-----
            startTime = getTimer();
            for ( i=0; i<ITEM_COUNT; i++ ) vector.push(i);
            _log( "アイテム追加： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for
            //-----
            startTime = getTimer();
            sum = 0;
            for ( i=0; i<ITEM_COUNT; i++ ) sum += vector[i];
            _log( "for ( i=0; i<length; i++ )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for each
            //-----
            startTime = getTimer();
            sum = 0;
            for each ( n in vector ) sum += n;
            _log( "for each ( var in vector )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for in
            //-----
            startTime = getTimer();
            sum = 0;
            for( s in vector ) sum += vector[s];
            _log( "for ( key in vector )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //使用メモリ
            //-----
            //var mem:Number = ( System.totalMemory - beforeMem ) / 1024 / 1024;
            //_log( "メモリ： " + mem + "MB\n" );
            _log("");
        }
        
        /*--------------------------------------------------
        * Object
        --------------------------------------------------*/
        private function _object():void {
            var i:uint, s:String, n:Number, sum:uint, startTime:Number;
            //var beforeMem:Number = System.totalMemory;
            
            _log( "##### Object #####\n" );
            
            //インスタンス生成
            var object:Object = {};
            
            //-----
            //アイテム追加
            //-----
            startTime = getTimer();
            for ( i=0; i<ITEM_COUNT; i++ ) object[i] = i;
            _log( "アイテム追加： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for each
            //-----
            startTime = getTimer();
            sum = 0;
            for each ( n in object ) sum += n;
            _log( "for each ( var in object )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for in
            //-----
            startTime = getTimer();
            sum = 0;
            for ( s in object ) sum += object[s];
            _log( "for ( key in object )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //使用メモリ
            //-----
            //var mem:Number = ( System.totalMemory - beforeMem ) / 1024 / 1024;
            //_log( "メモリ： " + mem + "MB\n" );
            _log("");
        }
        
        /*--------------------------------------------------
        * Dictionary
        --------------------------------------------------*/
        private function _dictionary():void {
            var i:uint, s:String, n:Number, sum:uint, startTime:Number;
            //var beforeMem:Number = System.totalMemory;
            
            _log( "##### Dictionary #####\n" );
            
            //インスタンス生成
            var dictionary:Dictionary = new Dictionary( true );
            
            //-----
            //アイテム追加
            //-----
            startTime = getTimer();
            for ( i=0; i<ITEM_COUNT; i++ ) dictionary[i] = i;
            _log( "アイテム追加： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for each
            //-----
            startTime = getTimer();
            sum = 0;
            for each ( n in dictionary ) sum += n;
            _log( "for each ( item in dictionary )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //for in
            //-----
            startTime = getTimer();
            sum = 0;
            for ( s in dictionary ) sum += dictionary[s];
            _log( "for ( key in dictionary )： " + ( getTimer() - startTime ) + "ms" );
            
            //-----
            //使用メモリ
            //-----
            //var mem:Number = ( System.totalMemory - beforeMem ) / 1024 / 1024;
            //_log( "メモリ： " + mem + "MB\n" );
            _log("");
        }
        
    }
}