/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vRLc
 */

// 2013-05-21 18:22:51
package
{
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sion.utils.soundfont.SiONSoundFont;
    import org.si.sion.utils.soundloader.SoundLoader;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    public class TestMML extends Sprite
    {
        public var driver:SiONDriver = new SiONDriver(4096);
        
        public function TestMML()
        {
            var soundLoader:SoundLoader = new SoundLoader();
            soundLoader.addEventListener(Event.COMPLETE, onSoundFontLoaded);
            soundLoader.setURL(new URLRequest("http://soundimpulse.sakura.ne.jp/wonderfl/ssf.swf"),  "sondfont", "ssf", true);
            soundLoader.loadAll();
            
            container = this;
            setup();
        }
        
        private function onSoundFontLoaded(event:Event):void
        {
            var soundLoader:SoundLoader = event.currentTarget as SoundLoader;
            soundLoader.removeEventListener(Event.COMPLETE, onSoundFontLoaded);
            var soundFont:SiONSoundFont = soundLoader.hash["sondfont"];
            
            //%7
            driver.setPCMVoice(0, soundFont.pcmVoices[0]);
            
            //mml from: http://www.yatta.com.tw/mabinogi/ac_compview.php?cid=011885
            var mml:String = "#REV; #EFFECT0{delay300,32,1};";
            mml += "%t0,1,1 %7@0 ";
            mml += "t140v10l64c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&c&cr2v8l8o2g>g<g>g<g>g<g>g<e>e<e>e<e>ebe<cb+cb+cb+cb+d>d<d>d>d<ba>d<<g>g<g>g<g>g<g>g<e>e<e>e<e>ebe<cb+cb+d>d<f+>f+<g>dgdbd<grg>g<g>g<g>g<g>e<e>e<e>e<e>e<e>gcb+cb+cb+cb+<a>a<a>a<d>d<d>d<g>g<g>g<g>g<g>e<e>e<e>e<e>e<e>ecb+cb+<d>d<d>d<g>g<g>g<g>g<g>g<e>e<e>e<e>e<e>e<cb+cb+cb+cb+d>d<d>d<d>d<d>d<g>g<g>g<g>gv15<f+>v13f+<e>e<e>e<e>e<e>e<cb+cb+cb+cb+d>d<d>d<d>d<d>d<g>g<g>g<grdrcb+cb+cb+cb+d>d<d>d<d>d<d>d<d+>d+<d+>d+<f+>f+<f+>f+<e>e<e>e<e>e<d>d<ccccrb+rgccccr2d>d<d>d<a>a<agf+v15>f+<v13f+d4v15l32ererl16erf+rl8gv13>g<g>g<g>g<g>f+<e>e<e>e<e>e<e>ecb+cb+cb+cb<d>d<d>d<d>f+<f+>f+<g>g<g>g<g>g<g>f+<e>e<e>e<e>e<eb>cb+cb+cb+cb<g>g<g>g<g>g<g>d<cb+cb+cb+cb+d>d<d>d<d>d<d>d<d+>d+<d+>d+<f+>f+<f+>f+<e>e<e>e<e>e<d>d<cb+cb+cb+cb+d>d<d>d<d>d<d>f+<g>g<g>g<g>g<g>gr2.<gab>bc-bc-bc-a+<g+>g+<g+>g+<g+>g+<g+>g+e>e<e>e<e>e<e>d+<<f+>f+<f+a+4>a+<a+>a+<b>bc-bc-bc-a+<g+>g+<g+>g+<g+>g+<g+>d+e>e<e>e<e>e<e>d+<c-bc-bc-bc-f+<e>e<e>e<e>e<e>e<f+>f+<f+>f+<f+>f+<f+>f+<gggga+a+a+v15b4v13l16g+g+v15>g+8v13<g+rl8g+>g+<f+>f+<e>e<e>e<e>e<e>e<f+>f+<f+>f+<f+>f+<f+>a+c-bc-bc-bc-b>d+f+d+c;";
            mml += "%t1,1,1 %7@0 ";
            mml += "t140r1v15l8dega4bage1degb4>d32e16.d<ba1rgdegab>d1dd4c-d4d<bag1b>ed<bargb4a16b16aggeegal16aga8b8>d8<bb>d8c-8d8<bbl8>d<ba4.rb>d+32e16.d<barg>e4l16ede8g8e8dde8d8d8<bbl8>d<bagaege16e16eag4.ragg4.agd>d<bb4.>ed<abaa4.>d<bag>dgd<b4a4agg4.agd>d<bb4.>ed<abaa4.>d<bag>dgd<g4rabage4edgg4.aa4bb>de<ba>d<abg1reeeer2eeeere4gaaaagegba2.ef+ggg>d4.gd<ggg>d4.gd<gg>d<gbg16b16aga2.r4ggg>d4.gd<ggg>d4.gdgggeba16b16agg2d2<gedegab>d<agf+garag>d<bab>dc-f+a4ggeg2d<bageregagabaga>dr<gg2r4>d<bgagrb>c+<bbb>f+f+f+bf+<bbb>f+f+f+bf+c-d+f+c-a+ba+f+c+2.r4<bbb>f+f+f+bf+c-d+c-f+f+f+bf+bg+b>c+d+c+<ba+b2f+2<bg+f+g+b>c+d+f+c+<ba+b>c+rc+c-f+d+c+d+f+d+a+>c+4<bbg+b2f+d+c+<bg+rg+b>c+<b>c+d+c+c-c+f+r<bb2r4>f+d+c-c+<brb;";
            mml += "%t2,1,1 %7@0 ";
            mml += "t140r1r1l8rv11>degbagar1rd16e16degedgr1ra4gagel1.rrrrrrr2.l8<c-cdv12l4.ec-2r8dc2r8gd2r8c-2g4f+4v13ec-2r8gd2r8c-l2dv12d&d8rl4c.c8c<ba.a8aa+bb>f+f+e2.l8&erv14>eeeer2eeeel2rv12<dcl4.c-dr4v13dgr8g8dgl8rgd4dd4.c4dv11>baf+4edcv13l4.<dgr8g8dgr8g8>cl8c<b4a4gv11>>dc<bl2g<<g.b4a>cdd+e1c.<b4a>cd1r.l8dev13f+f+f+b4.l16brbrf+8f+8f+8b4.brbrf+4brf+8b8>d+8c+rl8<bf+>>d+c+<a+4g+f+e<f+f+f+b4.l16brbrf+8f+8f+8b4.brbrf+8f+8brf+8>d+8c+8d+rl8<a+b>>f+ed+<b2l4.<c-c+d+4c+d+f+4l8gggga+a+a+v15b4v13g+f+ed+2l4.f+c-d+4c+f+a+4v11b1;";
            
            driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME, onNoteOn);
            driver.addEventListener(SiONTrackEvent.NOTE_OFF_FRAME, onNoteOff);
            driver.volume = 0.3;
            driver.play(mml);
        }
        
        private function onNoteOn(e:SiONTrackEvent):void
        {
            noteOn[e.eventTriggerID][e.note] = 1;
            release[e.eventTriggerID][e.note] = 1;
        }
        
        private function onNoteOff(e:SiONTrackEvent):void
        {
            release[e.eventTriggerID][e.note] = 0.84;
        }
    }
}






//from: http://wonderfl.net/c/4IH3
import com.bit101.components.*;

import flash.display.*;
import flash.events.*;
import flash.geom.*;

import org.si.sion.effector.SiEffectBase;
import org.si.sion.midi.*;

var noteOn:Vector.<Vector.<Number>> = new Vector.<Vector.<Number>>(16);
var release:Vector.<Vector.<Number>> = new Vector.<Vector.<Number>>(16);
var noteOnRect:Vector.<Vector.<Rectangle>> = new Vector.<Vector.<Rectangle>>(16);
var noteOnColor:Vector.<uint> = new Vector.<uint>(85);
var keyImage:BitmapData = new BitmapData(465, 445, false, 0);
var keyOnImage:BitmapData = new BitmapData(465, 445, true, 0);
var tempoIndicator:Shape = new Shape();
var keyShape:Shape = new Shape();
var lbl:Label = new Label();
var mat:Matrix = new Matrix();
var rc:Rectangle = new Rectangle();
var container:Sprite;
var tempoIndicatorAlpha:Number = 0;

function setup() : void {
    var tr:int, i:int, x:Number;
    var bw:Array = [0,1,0,1,0,0,1,0,1,0,1,0];
    var g:Graphics;
    
    for (i=0; i<16; i++) {
        noteOn[i] = new Vector.<Number>(128);
        release[i] = new Vector.<Number>(128); 
        noteOnRect[i] = new Vector.<Rectangle>(85);
    }
    
    g = tempoIndicator.graphics
    g.beginFill(0xf06060);
    g.drawCircle(0, 0, 4);
    g.endFill();
    g = keyShape.graphics;
    g.lineStyle(1, 0x808080);
    g.drawPath(Vector.<int>([1,2,2]), Vector.<Number>([0,0, 0,24, 5,24]));
    g.lineStyle(1, 0xc0c0c0);
    g.drawPath(Vector.<int>([1,2,2]), Vector.<Number>([5,24, 5,-1, 0,-1]));
    for (tr=0; tr<16; tr++) {
        rc.setTo(0,tr*28,300,25);
        keyImage.fillRect(rc, 0xf0f0f0);
        rc.setTo(375,tr*28,90,25);
        keyImage.fillRect(rc, 0x202038);
        for (i=0; i<9; i++) {
            rc.setTo(302+i*8,tr*28,6,25);
            keyImage.fillRect(rc, 0x303030);
        }
        for (mat.setTo(1,0,0,1,0,tr*28); mat.tx<300; mat.tx+=6) {
            keyImage.draw(keyShape, mat);
        }
        _drawText(keyImage, 375, tr*28-4, "[TRACK" + String(tr+1) + "]");
    }
    g.clear();
    g.beginFill(0x202020);
    g.lineStyle(1, 0x404040);
    g.drawPath(Vector.<int>([1,2,2,2]), Vector.<Number>([0,0, 0,14, 4,14, 4,0]));
    g.endFill();
    g.lineStyle(1, 0x808080);
    g.drawPath(Vector.<int>([1,2,2]), Vector.<Number>([1,0, 1,12, 2,12]));
    for (i=0,x=0; i<85; i++) {
        var bwf:int = bw[i%12];
        noteOnColor[i] = (bwf) ? 0xffccaa : 0xff2222;
        for (tr=0; tr<16; tr++) {
            noteOnRect[tr][i] = new Rectangle(x+bwf+1, tr*28, 4-bwf, 24-bwf*10);
            if (bwf) {
                mat.ty = tr*28;
                mat.tx = x+1;
                keyImage.draw(keyShape, mat);
            }
        }
        x += (bwf == bw[(i+1)%12])?6:3;
    }
    with(container.addChild(new Bitmap(keyImage))) { x = 0; y = 20; }
    with(container.addChild(new Bitmap(keyOnImage))) { x = 0; y = 20; }
    tempoIndicator.x = 110;
    tempoIndicator.y = 10;
    container.addChild(tempoIndicator);
    container.addEventListener(Event.ENTER_FRAME, draw);
    container.graphics.beginFill(0x303050);
    container.graphics.drawRect(0,0,465,20);
    container.graphics.endFill();
}


function reset() : void {
    var tr:int, nt:int;
    keyOnImage.fillRect(keyOnImage.rect, 0);
    for (tr=0; tr<16; tr++) {
        for (nt=0; nt<128; nt++) {
            noteOn[tr][nt] = 0;
            release[tr][nt] = 0;
        }
        updatePitchBend(tr, 0);
        updateModulation(tr, 0);
        updateExpression(tr, 128);
        updateSustain(tr, 0);
        updatePanpod(tr, 64);
        updateVolume(tr, 128);
        updateReverb(tr, 0);
        updateChorus(tr, 0);
        updateDelay(tr, 0);
    }
}


function _drawText(img:BitmapData, x:Number, y:Number, str:String, scale:Number=1) : void {
    mat.setTo(scale,0,0,scale,x,y);
    lbl.text = str;
    lbl.draw();
    img.draw(lbl, mat);
}


function updateVoiceInformation(midiModule:MIDIModule, tr:int, pn:int, drumMode:int) : void {
    rc.setTo(375, tr*28+13, 90, 13);
    keyOnImage.fillRect(rc, 0);
    if (drumMode) {
        _drawText(keyOnImage, 375, tr*28+8, String(pn) + ":[DRUM MODE]");
    } else {
        _drawText(keyOnImage, 375, tr*28+8, String(pn) + ":" + midiModule.voiceSet[pn].name);
    }
}


function updatePitchBend(tr:int, bend:int) : void { _updateBar(tr, 0, (bend>0) ? (-bend*12/8192) : 0, (bend<0) ? (-bend*12/8192) : 1, 13); }
function updateModulation(tr:int, mod:int) : void { _updateBar(tr, 1, -mod*25/128); }
function updateExpression(tr:int, exp:int) : void { _updateBar(tr, 2, -exp*25/128); }
function updateSustain(tr:int, sus:int) : void    { _updateBar(tr, 3, -sus*25/128); }
function updatePanpod(tr:int, pan:int) : void     { _updateBar(tr, 4, (pan>64) ? (-(pan-64)*12/64) : 0, (pan<64) ? (-(pan-64)*12/64) : 1, 13); }
function updateVolume(tr:int, vol:int) : void     { _updateBar(tr, 5, -vol*25/128); }
function updateReverb(tr:int, rev:int) : void     { _updateBar(tr, 6, -rev*25/128); }
function updateChorus(tr:int, cho:int) : void     { _updateBar(tr, 7, -cho*25/128); }
function updateDelay(tr:int, dly:int) : void      { _updateBar(tr, 8, -dly*25/128); }


function _updateBar(tr:int, index:int, y0:int, y1:int=0, c:int=25) : void {
    rc.setTo(302+index*8, tr*28, 6, 25);
    keyOnImage.fillRect(rc, 0);
    rc.setTo(302+index*8, tr*28+c+y0, 6, y1-y0);
    keyOnImage.fillRect(rc, 0xff8080a0);
}

function draw(e:Event) : void {
    rc.setTo(0, 0, 300, 450);
    keyOnImage.fillRect(rc, 0);
    for (var tr:int=0; tr<16; tr++) {
        var n:Vector.<Number> = noteOn[tr],
            r:Vector.<Number> = release[tr],
            nr:Vector.<Rectangle> = noteOnRect[tr];
        for (var i:int=0, j:int=24; i<85; i++, j++) {
            if (n[j] > 0) {
                n[j] *= r[j];
                if (n[j] < 0.01) n[j] = 0;
                keyOnImage.fillRect(nr[i], ((n[j]*255)<<24)|noteOnColor[i]);
            }
        }
    }
    tempoIndicator.alpha = tempoIndicatorAlpha;
    tempoIndicatorAlpha *= 0.9;
}
